/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.properties;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.preferences.PDECompilersConfigurationBlock;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class CompilersPropertyPage
extends PropertyPage {
    private Map<String, Object> fPageData = null;
    private PDECompilersConfigurationBlock fBlock = null;
    private Button fProjectSpecific = null;
    private Link fWorkspaceLink = null;

    protected Control createContents(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808, 0, 0);
        Composite tcomp = SWTFactory.createComposite(comp, 2, 1, 768, 0, 0);
        this.fProjectSpecific = new Button(tcomp, 32);
        this.fProjectSpecific.setLayoutData((Object)new GridData(1, 128, true, false));
        this.fProjectSpecific.setText(PDEUIMessages.CompilersPropertyPage_useprojectsettings_label);
        this.fProjectSpecific.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean psp = this.fProjectSpecific.getSelection();
            this.fBlock.useProjectSpecificSettings(psp);
            if (this.fWorkspaceLink != null) {
                this.fWorkspaceLink.setEnabled(!psp);
            }
        }));
        if (this.offerLink()) {
            this.fWorkspaceLink = new Link(tcomp, 0);
            this.fWorkspaceLink.setText(PDEUIMessages.CompilersPropertyPage_useworkspacesettings_change);
            this.fWorkspaceLink.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                HashMap<String, Boolean> data = new HashMap<String, Boolean>();
                data.put("PropertyAndPreferencePage.nolink", Boolean.TRUE);
                SWTFactory.showPreferencePage(this.getShell(), "org.eclipse.pde.ui.CompilersPreferencePage", data);
            }));
        }
        this.fBlock = new PDECompilersConfigurationBlock(this.getProject(), (IWorkbenchPreferenceContainer)this.getContainer());
        this.fBlock.createControl(comp);
        boolean ps = this.fBlock.hasProjectSpecificSettings(this.getProject());
        this.fProjectSpecific.setSelection(ps);
        this.fBlock.useProjectSpecificSettings(ps);
        if (this.fWorkspaceLink != null) {
            this.fWorkspaceLink.setEnabled(!ps);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.pde.doc.user.compilers_property_page");
        Dialog.applyDialogFont((Control)comp);
        return comp;
    }

    private IProject getProject() {
        return (IProject)this.getElement().getAdapter(IProject.class);
    }

    public boolean performCancel() {
        this.fBlock.performCancel();
        return super.performCancel();
    }

    public boolean performOk() {
        this.fBlock.performOK();
        return super.performOk();
    }

    protected void performDefaults() {
        this.fBlock.performDefaults();
        super.performDefaults();
    }

    protected void performApply() {
        this.fBlock.performApply();
        super.performApply();
    }

    public void dispose() {
        this.fBlock.dispose();
        super.dispose();
    }

    private boolean offerLink() {
        return this.fPageData == null || !Boolean.TRUE.equals(this.fPageData.get("PropertyAndPreferencePage.nolink"));
    }

    public void applyData(Object data) {
        if (data instanceof Map) {
            Boolean useProjectOptions;
            this.fPageData = (Map)data;
            if (this.fWorkspaceLink != null) {
                this.fWorkspaceLink.setVisible(!Boolean.TRUE.equals(this.fPageData.get("PropertyAndPreferencePage.nolink")));
            }
            if (this.fBlock == null) {
                return;
            }
            if (this.getProject() != null && (useProjectOptions = (Boolean)this.fPageData.get("use_project_specific_key")) != null) {
                this.fBlock.useProjectSpecificSettings(useProjectOptions);
                this.fProjectSpecific.setSelection(useProjectOptions.booleanValue());
            }
            Object key = this.fPageData.get("select_option_key");
            Object qualifier = this.fPageData.get("select_option_qualifier");
            if (key instanceof String && qualifier instanceof String) {
                this.fBlock.selectOption((String)key, (String)qualifier);
            }
        }
    }
}

