/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.BitSetDocIdStream;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DISIDocIdStream;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.RangeDocIdStream;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleScorable;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

final class DenseConjunctionBulkScorer
extends BulkScorer {
    static final int WINDOW_SIZE = 4096;
    static final int DENSITY_THRESHOLD_INVERSE = 32;
    private final int maxDoc;
    private final List<DisiWrapper> iterators;
    private final SimpleScorable scorable;
    private final FixedBitSet windowMatches = new FixedBitSet(4096);
    private final FixedBitSet clauseWindowMatches = new FixedBitSet(4096);
    private final List<DocIdSetIterator> windowApproximations = new ArrayList<DocIdSetIterator>();
    private final List<TwoPhaseIterator> windowTwoPhases = new ArrayList<TwoPhaseIterator>();

    static DenseConjunctionBulkScorer of(List<Scorer> filters, int maxDoc, float constantScore) {
        ArrayList<DocIdSetIterator> iterators = new ArrayList<DocIdSetIterator>();
        ArrayList<TwoPhaseIterator> twoPhases = new ArrayList<TwoPhaseIterator>();
        for (Scorer filter : filters) {
            TwoPhaseIterator twoPhase = filter.twoPhaseIterator();
            if (twoPhase != null) {
                twoPhases.add(twoPhase);
                continue;
            }
            iterators.add(filter.iterator());
        }
        return new DenseConjunctionBulkScorer(iterators, twoPhases, maxDoc, constantScore);
    }

    DenseConjunctionBulkScorer(List<DocIdSetIterator> iterators, List<TwoPhaseIterator> twoPhases, int maxDoc, float constantScore) {
        if (iterators.isEmpty() && twoPhases.isEmpty()) {
            throw new IllegalArgumentException("Expected one or more iterators, got 0");
        }
        this.maxDoc = maxDoc;
        this.iterators = new ArrayList<DisiWrapper>();
        for (DocIdSetIterator iterator : iterators) {
            this.iterators.add(new DisiWrapper(iterator));
        }
        for (TwoPhaseIterator twoPhase : twoPhases) {
            this.iterators.add(new DisiWrapper(twoPhase));
        }
        this.iterators.sort(Comparator.comparing(w -> w.approximation().cost()));
        this.scorable = new SimpleScorable();
        this.scorable.score = constantScore;
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        collector.setScorer(this.scorable);
        List<DisiWrapper> iterators = this.iterators;
        if (collector.competitiveIterator() != null) {
            iterators = new ArrayList<DisiWrapper>(iterators);
            iterators.add(new DisiWrapper(collector.competitiveIterator()));
        }
        for (DisiWrapper w : iterators) {
            min = Math.max(min, w.approximation().docID());
        }
        max = Math.min(max, this.maxDoc);
        DisiWrapper lead = iterators.get(0);
        if (lead.docID() < min) {
            min = lead.approximation.advance(min);
        }
        while (min < max) {
            if (this.scorable.minCompetitiveScore > this.scorable.score) {
                return Integer.MAX_VALUE;
            }
            min = this.scoreWindow(collector, acceptDocs, iterators, min, max);
        }
        if (lead.docID() > max) {
            return lead.docID();
        }
        if (max >= this.maxDoc) {
            return Integer.MAX_VALUE;
        }
        return max;
    }

    private static int advance(FixedBitSet set, int i) {
        if (i >= 4096) {
            return Integer.MAX_VALUE;
        }
        return set.nextSetBit(i);
    }

    private int scoreWindow(LeafCollector collector, Bits acceptDocs, List<DisiWrapper> iterators, int min, int max) throws IOException {
        for (DisiWrapper w : iterators) {
            min = w.docID() >= min ? w.docID() : w.approximation().advance(min);
            if (min < max) continue;
            return min;
        }
        int minDocIDRunEnd = max;
        int minRunEndThreshold = (int)Math.min((long)min + 2048L, (long)max);
        for (DisiWrapper w : iterators) {
            int docIdRunEnd = w.docIDRunEnd();
            if (w.docID() > min || docIdRunEnd < minRunEndThreshold) {
                this.windowApproximations.add(w.approximation());
                if (w.twoPhase() == null) continue;
                this.windowTwoPhases.add(w.twoPhase());
                continue;
            }
            minDocIDRunEnd = Math.min(minDocIDRunEnd, docIdRunEnd);
        }
        if (acceptDocs == null && this.windowApproximations.isEmpty()) {
            collector.collect(new RangeDocIdStream(min, minDocIDRunEnd));
            return minDocIDRunEnd;
        }
        int bitsetWindowMax = (int)Math.min((long)minDocIDRunEnd, 4096L + (long)min);
        if (this.windowTwoPhases.isEmpty()) {
            if (acceptDocs == null && this.windowApproximations.size() == 1) {
                DocIdSetIterator iterator = this.windowApproximations.get(0);
                if (iterator.docID() < min) {
                    iterator.advance(min);
                }
                collector.collect(new DISIDocIdStream(iterator, bitsetWindowMax, this.clauseWindowMatches));
            } else {
                this.scoreWindowUsingBitSet(collector, acceptDocs, this.windowApproximations, min, bitsetWindowMax);
            }
        } else {
            this.windowTwoPhases.sort(Comparator.comparingDouble(TwoPhaseIterator::matchCost));
            DenseConjunctionBulkScorer.scoreWindowUsingLeapFrog(collector, acceptDocs, this.windowApproximations, this.windowTwoPhases, min, bitsetWindowMax);
            this.windowTwoPhases.clear();
        }
        this.windowApproximations.clear();
        return bitsetWindowMax;
    }

    private void scoreWindowUsingBitSet(LeafCollector collector, Bits acceptDocs, List<DocIdSetIterator> iterators, int windowBase, int windowMax) throws IOException {
        int upTo;
        assert (windowMax > windowBase);
        assert (this.windowMatches.scanIsEmpty());
        assert (this.clauseWindowMatches.scanIsEmpty());
        if (iterators.isEmpty()) {
            this.windowMatches.set(0, windowMax - windowBase);
        } else {
            DocIdSetIterator lead = iterators.get(0);
            if (lead.docID() < windowBase) {
                lead.advance(windowBase);
            }
            lead.intoBitSet(windowMax, this.windowMatches, windowBase);
        }
        if (acceptDocs != null) {
            acceptDocs.applyMask(this.windowMatches, windowBase);
        }
        int windowSize = windowMax - windowBase;
        int threshold = windowSize / 32;
        for (upTo = 1; upTo < iterators.size() && this.windowMatches.cardinality() >= threshold; ++upTo) {
            DocIdSetIterator other = iterators.get(upTo);
            if (other.docID() < windowBase) {
                other.advance(windowBase);
            }
            other.intoBitSet(windowMax, this.clauseWindowMatches, windowBase);
            this.windowMatches.and(this.clauseWindowMatches);
            this.clauseWindowMatches.clear();
        }
        if (upTo < iterators.size()) {
            int windowMatch = this.windowMatches.nextSetBit(0);
            block1: while (windowMatch != Integer.MAX_VALUE) {
                int doc = windowBase + windowMatch;
                for (int i = upTo; i < iterators.size(); ++i) {
                    DocIdSetIterator other = iterators.get(i);
                    int otherDoc = other.docID();
                    if (otherDoc < doc) {
                        otherDoc = other.advance(doc);
                    }
                    if (doc == otherDoc) continue;
                    windowMatch = DenseConjunctionBulkScorer.advance(this.windowMatches, otherDoc - windowBase);
                    continue block1;
                }
                collector.collect(doc);
                windowMatch = DenseConjunctionBulkScorer.advance(this.windowMatches, windowMatch + 1);
            }
        } else {
            collector.collect(new BitSetDocIdStream(this.windowMatches, windowBase));
        }
        this.windowMatches.clear();
    }

    private static void scoreWindowUsingLeapFrog(LeafCollector collector, Bits acceptDocs, List<DocIdSetIterator> approximations, List<TwoPhaseIterator> twoPhases, int min, int max) throws IOException {
        assert (twoPhases.size() > 0);
        assert (approximations.size() >= twoPhases.size());
        if (approximations.size() == 1) {
            assert (twoPhases.size() == 1);
            DocIdSetIterator approximation = approximations.get(0);
            TwoPhaseIterator twoPhase = twoPhases.get(0);
            if (approximation.docID() < min) {
                approximation.advance(min);
            }
            int doc = approximation.docID();
            while (doc < max) {
                if ((acceptDocs == null || acceptDocs.get(doc)) && twoPhase.matches()) {
                    collector.collect(doc);
                }
                doc = approximation.nextDoc();
            }
        } else {
            DocIdSetIterator lead1 = approximations.get(0);
            DocIdSetIterator lead2 = approximations.get(1);
            if (lead1.docID() < min) {
                lead1.advance(min);
            }
            int doc = lead1.docID();
            block1: while (doc < max) {
                if (acceptDocs != null && !acceptDocs.get(doc)) {
                    doc = lead1.nextDoc();
                    continue;
                }
                int doc2 = lead2.docID();
                if (doc2 < doc) {
                    doc2 = lead2.advance(doc);
                }
                if (doc != doc2) {
                    doc = lead1.advance(Math.min(doc2, max));
                    continue;
                }
                for (int i = 2; i < approximations.size(); ++i) {
                    DocIdSetIterator other = approximations.get(i);
                    int docN = other.docID();
                    if (docN < doc) {
                        docN = other.advance(doc);
                    }
                    if (doc == docN) continue;
                    doc = lead1.advance(Math.min(docN, max));
                    continue block1;
                }
                for (TwoPhaseIterator twoPhase : twoPhases) {
                    if (twoPhase.matches()) continue;
                    doc = lead1.nextDoc();
                    continue block1;
                }
                collector.collect(doc);
                doc = lead1.nextDoc();
            }
        }
    }

    @Override
    public long cost() {
        return this.iterators.get(0).approximation().cost();
    }

    private record DisiWrapper(DocIdSetIterator approximation, TwoPhaseIterator twoPhase) {
        DisiWrapper(DocIdSetIterator iterator) {
            this(iterator, null);
        }

        DisiWrapper(TwoPhaseIterator twoPhase) {
            this(twoPhase.approximation(), twoPhase);
        }

        int docID() {
            return this.approximation().docID();
        }

        int docIDRunEnd() throws IOException {
            if (this.twoPhase() == null) {
                return this.approximation().docIDRunEnd();
            }
            return this.twoPhase().docIDRunEnd();
        }
    }
}

