/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Model;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.dialogs.MavenRepositorySearchDialog;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenWizardPage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenArtifactComponent;
import org.eclipse.m2e.core.ui.internal.wizards.MavenParentComponent;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizard;
import org.eclipse.m2e.core.ui.internal.wizards.WidthGroup;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MavenProjectWizardArtifactPage
extends AbstractMavenWizardPage {
    private static final ProjectFolder JAVA = new ProjectFolder("src/main/java", "target/classes");
    private static final ProjectFolder JAVA_TEST = new ProjectFolder("src/test/java", "target/test-classes");
    private static final ProjectFolder RESOURCES = new ProjectFolder("src/main/resources", "target/classes");
    private static final ProjectFolder RESOURCES_TEST = new ProjectFolder("src/test/resources", "target/test-classes");
    private static final ProjectFolder WEBAPP = new ProjectFolder("src/main/webapp", null);
    private static final ProjectFolder EAR = new ProjectFolder("src/main/application", null);
    private static final ProjectFolder SITE = new ProjectFolder("src/site", null);
    private static final ProjectFolder[] JAR_DIRS = new ProjectFolder[]{JAVA, JAVA_TEST, RESOURCES, RESOURCES_TEST};
    private static final ProjectFolder[] WAR_DIRS = new ProjectFolder[]{JAVA, JAVA_TEST, RESOURCES, RESOURCES_TEST, WEBAPP};
    private static final ProjectFolder[] EAR_DIRS = new ProjectFolder[]{EAR};
    private static final ProjectFolder[] POM_DIRS = new ProjectFolder[]{SITE};
    private static final Map<String, ProjectFolder[]> directorySets = new HashMap<String, ProjectFolder[]>();
    protected MavenParentComponent parentComponent;
    protected MavenArtifactComponent artifactComponent;
    private boolean readonlyParent = false;
    private boolean isUsed;

    static {
        directorySets.put("war", WAR_DIRS);
        directorySets.put("pom", POM_DIRS);
        directorySets.put("ear", EAR_DIRS);
    }

    public MavenProjectWizardArtifactPage(ProjectImportConfiguration projectImportConfiguration) {
        this("MavenProjectWizardArtifactPage", projectImportConfiguration);
    }

    protected MavenProjectWizardArtifactPage(String name, ProjectImportConfiguration projectImportConfiguration) {
        super(name, projectImportConfiguration);
        this.setTitle(Messages.wizardProjectPageMaven2Title);
        this.setDescription(Messages.wizardProjectPageMaven2Description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)layout);
        WidthGroup widthGroup = new WidthGroup();
        container.addControlListener((ControlListener)widthGroup);
        ModifyListener modifyingListener = e -> this.validate();
        this.artifactComponent = new MavenArtifactComponent(container, 0);
        this.artifactComponent.setLayoutData(new GridData(4, 4, true, true));
        this.artifactComponent.setWidthGroup(widthGroup);
        this.artifactComponent.setModifyingListener(modifyingListener);
        this.artifactComponent.setArtifactIdEditable(!this.readonlyParent);
        this.parentComponent = new MavenParentComponent(container, this.readonlyParent ? 8 : 0);
        this.parentComponent.setLayoutData(new GridData(4, 128, false, false));
        this.parentComponent.setWidthGroup(widthGroup);
        this.parentComponent.addModifyListener(modifyingListener);
        this.parentComponent.addBrowseButtonListener(SelectionListener.widgetSelectedAdapter(e -> {
            IndexedArtifactFile indexedArtifactFile;
            MavenRepositorySearchDialog dialog = MavenRepositorySearchDialog.createSearchParentDialog(this.getShell(), Messages.MavenProjectWizardArtifactPage_searchDialog_title, null, null);
            if (dialog.open() == 0 && (indexedArtifactFile = (IndexedArtifactFile)dialog.getFirstResult()) != null) {
                this.parentComponent.setValues(indexedArtifactFile.group, indexedArtifactFile.artifact, indexedArtifactFile.version);
            }
        }));
        this.createAdvancedSettings(container, new GridData(4, 128, false, false, 2, 1));
        this.resolverConfigurationComponent.setModifyListener(e -> this.validate());
        this.addFieldWithHistory("groupId", this.artifactComponent.getGroupIdCombo());
        this.addFieldWithHistory("artifactId", this.artifactComponent.getArtifactIdCombo());
        this.addFieldWithHistory("version", this.artifactComponent.getVersionCombo());
        this.addFieldWithHistory("name", this.artifactComponent.getNameCombo());
        this.addFieldWithHistory("groupId", this.parentComponent.getGroupIdCombo());
        this.addFieldWithHistory("artifactId", this.parentComponent.getArtifactIdCombo());
        this.addFieldWithHistory("version", this.parentComponent.getVersionCombo());
        container.layout();
        this.validate();
        this.setControl((Control)container);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.artifactComponent.getGroupIdCombo().setFocus();
    }

    public Model getModel() {
        Model model = this.artifactComponent.getModel();
        this.parentComponent.updateModel(model);
        return model;
    }

    private ProjectFolder[] getProjectFolders() {
        ProjectFolder[] folders = directorySets.get(this.artifactComponent.getPackaging());
        return folders == null ? JAR_DIRS : folders;
    }

    public List<String> getFolders() {
        ProjectFolder[] mavenDirectories = this.getProjectFolders();
        return Arrays.stream(mavenDirectories).map(ProjectFolder::getPath).toList();
    }

    void validate() {
        String error = this.validateInput();
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }

    private String validateInput() {
        String error = this.validateGroupIdInput(this.artifactComponent.getGroupId().trim());
        if (error != null) {
            return error;
        }
        error = this.validateArtifactIdInput(this.artifactComponent.getArtifactId().trim());
        if (error != null) {
            return error;
        }
        if (this.artifactComponent.getVersion().trim().length() == 0) {
            return Messages.wizardProjectPageMaven2ValidatorVersion;
        }
        if (this.artifactComponent.getPackaging().trim().length() == 0) {
            return Messages.wizardProjectPageMaven2ValidatorPackaging;
        }
        if (!this.parentComponent.validate()) {
            return Messages.wizardProjectPageMaven2ValidatorParent;
        }
        IStatus nameStatus = MavenProjectWizard.validateProjectName(this.getImportConfiguration(), this.artifactComponent.getModel());
        if (!nameStatus.isOK()) {
            return nameStatus.getMessage();
        }
        return null;
    }

    public void setProjectName(String projectName) {
        if (this.artifactComponent.getArtifactId().equals(this.artifactComponent.getGroupId())) {
            this.artifactComponent.setGroupId(projectName);
        }
        this.artifactComponent.setArtifactId(projectName);
        this.validate();
    }

    public void setParentReadonly(boolean b) {
        this.readonlyParent = b;
    }

    public void setParentProject(String groupId, String artifactId, String version) {
        this.parentComponent.setValues(groupId, artifactId, version);
        this.artifactComponent.setGroupId(groupId);
        this.artifactComponent.setVersion(version);
        this.validate();
    }

    public void setUsed(boolean isUsed) {
        this.isUsed = isUsed;
    }

    public boolean isPageComplete() {
        return !this.isUsed || super.isPageComplete();
    }

    static final class ProjectFolder {
        private String path = null;
        private String outputPath = null;

        ProjectFolder(String path, String outputPath) {
            this.path = path;
            this.outputPath = outputPath;
        }

        String getPath() {
            return this.path;
        }

        String getOutputPath() {
            return this.outputPath;
        }

        boolean isSourceEntry() {
            return this.getOutputPath() != null;
        }
    }
}

