/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal.refactoring;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.cdt.launch.internal.LaunchConfigAffinityExtensionPoint;
import org.eclipse.cdt.launch.internal.refactoring.AbstractLaunchConfigChange;
import org.eclipse.cdt.launch.internal.refactoring.ProjectRenameChange;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class ResourceRenameParticipant
extends RenameParticipant
implements IExecutableExtension {
    private String name;
    private IResource resourceBeingRenamed;

    public String getName() {
        return this.name;
    }

    protected boolean initialize(Object element) {
        if (element instanceof IResource) {
            this.resourceBeingRenamed = (IResource)element;
        } else if (element instanceof IAdaptable) {
            this.resourceBeingRenamed = (IResource)((IAdaptable)element).getAdapter(IResource.class);
        }
        return true;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        Change result = null;
        if (this.resourceBeingRenamed instanceof IProject) {
            String oldName = this.resourceBeingRenamed.getName();
            String newName = this.getArguments().getNewName();
            Collection<ILaunchConfigurationType> launchTypes = ResourceRenameParticipant.getCLaunchConfigTypes();
            if (!launchTypes.isEmpty()) {
                ILaunchManager mgr = DebugPlugin.getDefault().getLaunchManager();
                for (ILaunchConfigurationType type : launchTypes) {
                    ILaunchConfiguration[] launches;
                    ILaunchConfiguration[] iLaunchConfigurationArray = launches = mgr.getLaunchConfigurations(type);
                    int n = launches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunchConfiguration next = iLaunchConfigurationArray[n2];
                        if (next.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "").equals(oldName)) {
                            result = AbstractLaunchConfigChange.append(result, new ProjectRenameChange(next, oldName, newName));
                        }
                        ++n2;
                    }
                }
            }
        }
        return result;
    }

    static Collection<ILaunchConfigurationType> getCLaunchConfigTypes() {
        HashSet<ILaunchConfigurationType> result = new HashSet<ILaunchConfigurationType>();
        HashSet thirdPartyConfgTypeIds = new HashSet(5);
        LaunchConfigAffinityExtensionPoint.getLaunchConfigTypeIds(thirdPartyConfgTypeIds);
        ILaunchManager mgr = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType[] iLaunchConfigurationTypeArray = mgr.getLaunchConfigurationTypes();
        int n = iLaunchConfigurationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationType next = iLaunchConfigurationTypeArray[n2];
            if (next.getPluginIdentifier().startsWith("org.eclipse.cdt.") || thirdPartyConfgTypeIds.contains(next.getIdentifier())) {
                result.add(next);
            }
            ++n2;
        }
        return result;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.name = config.getAttribute("name");
    }
}

