/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContext;

public class CRefactoringContext
extends RefactoringContext {
    private static final int PARSE_MODE = 166;
    private final Map<ITranslationUnit, IASTTranslationUnit> fASTCache;
    private IIndex fIndex;
    private IASTTranslationUnit fSharedAST;

    public CRefactoringContext(CRefactoring refactoring) {
        super((Refactoring)refactoring);
        refactoring.setContext(this);
        this.fASTCache = new ConcurrentHashMap<ITranslationUnit, IASTTranslationUnit>();
    }

    public IASTTranslationUnit getAST(ITranslationUnit tu, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.isDisposed()) {
            throw new IllegalStateException("CRefactoringContext is already disposed.");
        }
        this.getIndex();
        if (pm != null && pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        IASTTranslationUnit ast = this.fASTCache.get(tu = CModelUtil.toWorkingCopy(tu));
        if (ast == null) {
            if (this.fSharedAST != null && tu.equals(this.fSharedAST.getOriginatingTranslationUnit())) {
                ast = this.fSharedAST;
            } else {
                ast = ASTProvider.getASTProvider().acquireSharedAST(tu, this.fIndex, ASTProvider.WAIT_ACTIVE_ONLY, pm);
                if (ast != null && ast.hasNodesOmitted()) {
                    ASTProvider.getASTProvider().releaseSharedAST(ast);
                    ast = null;
                }
                if (ast == null) {
                    if (pm != null && pm.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    ast = tu.getAST(this.fIndex, 166);
                    this.fASTCache.put(tu, ast);
                } else {
                    if (this.fSharedAST != null) {
                        ASTProvider.getASTProvider().releaseSharedAST(this.fSharedAST);
                    }
                    this.fSharedAST = ast;
                }
            }
        }
        if (pm != null) {
            pm.done();
        }
        return ast;
    }

    public IIndex getIndex() throws CoreException, OperationCanceledException {
        if (this.isDisposed()) {
            throw new IllegalStateException("CRefactoringContext is already disposed.");
        }
        if (this.fIndex == null) {
            ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
            IIndex index = CCorePlugin.getIndexManager().getIndex(projects, 1024);
            try {
                index.acquireReadLock();
            }
            catch (InterruptedException e) {
                throw new OperationCanceledException();
            }
            this.fIndex = index;
        }
        return this.fIndex;
    }

    public void dispose() {
        if (this.isDisposed()) {
            throw new IllegalStateException("CRefactoringContext.dispose() called more than once.");
        }
        if (this.fSharedAST != null) {
            ASTProvider.getASTProvider().releaseSharedAST(this.fSharedAST);
        }
        if (this.fIndex != null) {
            this.fIndex.releaseReadLock();
        }
        super.dispose();
    }

    private boolean isDisposed() {
        return this.getRefactoring() == null;
    }

    protected void finalize() throws Throwable {
        if (!this.isDisposed()) {
            CUIPlugin.logError("CRefactoringContext was not disposed");
        }
        super.finalize();
    }
}

