/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFileMidx;
import org.eclipse.jgit.internal.storage.pack.PackExt;

public final class MidxPackList {
    private static final Comparator<DfsPackFile> PACK_NAME_COMPARATOR = Comparator.comparing(pack -> pack.getPackDescription().getPackName());
    private final List<DfsPackFile> packs;

    public static MidxPackList create(DfsPackFile[] packs) {
        return new MidxPackList(packs);
    }

    private MidxPackList(DfsPackFile[] packs) {
        this.packs = Arrays.asList(packs);
    }

    public List<DfsPackFile> getAllPlainPacks() {
        ArrayList<DfsPackFile> plainPacks = new ArrayList<DfsPackFile>();
        ArrayDeque<DfsPackFile> pending = new ArrayDeque<DfsPackFile>(this.packs);
        while (!pending.isEmpty()) {
            DfsPackFile pack = (DfsPackFile)pending.poll();
            if (pack instanceof DfsPackFileMidx) {
                DfsPackFileMidx midxPack = (DfsPackFileMidx)pack;
                plainPacks.addAll(midxPack.getCoveredPacks());
                if (midxPack.getMultipackIndexBase() == null) continue;
                pending.add(midxPack.getMultipackIndexBase());
                continue;
            }
            plainPacks.add(pack);
        }
        return plainPacks;
    }

    public List<DfsPackFileMidx> getAllMidxPacks() {
        List<DfsPackFileMidx> topLevelMidxs = this.packs.stream().filter(p -> p.getPackDescription().hasFileExt(PackExt.MULTI_PACK_INDEX)).map(p -> (DfsPackFileMidx)p).toList();
        ArrayList<DfsPackFileMidx> midxPacks = new ArrayList<DfsPackFileMidx>();
        ArrayDeque<DfsPackFileMidx> pending = new ArrayDeque<DfsPackFileMidx>(topLevelMidxs);
        while (!pending.isEmpty()) {
            DfsPackFileMidx midx = (DfsPackFileMidx)pending.poll();
            midxPacks.add(midx);
            if (midx.getMultipackIndexBase() == null) continue;
            pending.add(midx.getMultipackIndexBase());
        }
        return midxPacks;
    }

    Set<DfsPackFileMidx> findAllCoveringMidxs(DfsPackFile pack) {
        return this.findAllCoveringMidxs(List.of(pack));
    }

    public Set<DfsPackFileMidx> findAllCoveringMidxs(List<DfsPackFile> queryPacks) {
        if (queryPacks.isEmpty()) {
            return Collections.emptySet();
        }
        List<DfsPackFileMidx> topLevelMidxs = this.packs.stream().filter(p -> p.getPackDescription().hasFileExt(PackExt.MULTI_PACK_INDEX)).map(p -> (DfsPackFileMidx)p).toList();
        if (topLevelMidxs.isEmpty()) {
            return Collections.emptySet();
        }
        TreeSet<DfsPackFileMidx> impactedMidxs = MidxPackList.asSet(List.of());
        for (DfsPackFileMidx midx : topLevelMidxs) {
            ArrayList<DfsPackFileMidx> visitedMidxs = new ArrayList<DfsPackFileMidx>();
            DfsPackFileMidx current = midx;
            while (current != null) {
                visitedMidxs.add(current);
                if (MidxPackList.containsAny(current.getCoveredPacks(), queryPacks)) {
                    impactedMidxs.addAll(visitedMidxs);
                    visitedMidxs.clear();
                }
                current = current.getMultipackIndexBase();
            }
            visitedMidxs.clear();
        }
        return impactedMidxs;
    }

    private static boolean containsAny(List<DfsPackFile> inMidx, List<DfsPackFile> queryPacks) {
        TreeSet<DfsPackFile> inMidxSet = MidxPackList.asSet(inMidx);
        return queryPacks.stream().anyMatch(inMidxSet::contains);
    }

    private static <T extends DfsPackFile> TreeSet<T> asSet(List<T> initialValues) {
        TreeSet<DfsPackFile> theSet = new TreeSet<DfsPackFile>(PACK_NAME_COMPARATOR);
        theSet.addAll(initialValues);
        return theSet;
    }
}

