/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editparts;

import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AutoexposeHelper;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.GuideLayer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.SimpleRootEditPart;
import org.eclipse.gef.editparts.ViewportAutoexposeHelper;
import org.eclipse.gef.internal.InternalGEFPlugin;
import org.eclipse.gef.tools.MarqueeDragTracker;

public class FreeformGraphicalRootEditPart
extends SimpleRootEditPart
implements LayerConstants,
LayerManager {
    private ScalableFreeformLayeredPane innerLayers;
    private LayeredPane printableLayers;
    private final PropertyChangeListener gridListener = evt -> {
        String property = evt.getPropertyName();
        if (property.equals("SnapToGrid.GridOrigin") || property.equals("SnapToGrid.GridSpacing") || property.equals("SnapToGrid.isVisible")) {
            this.refreshGridLayer();
        }
    };

    @Override
    protected IFigure createFigure() {
        FreeformViewport viewport = new FreeformViewport();
        this.innerLayers = new ScalableFreeformLayeredPane();
        this.addEditPartListener(InternalGEFPlugin.createAutoscaleEditPartListener((ScalableFigure)this.innerLayers));
        this.createLayers((LayeredPane)this.innerLayers);
        viewport.setContents((IFigure)this.innerLayers);
        return viewport;
    }

    protected GridLayer createGridLayer() {
        return new GridLayer();
    }

    protected void createLayers(LayeredPane layeredPane) {
        layeredPane.add((IFigure)this.createGridLayer(), (Object)"Grid Layer");
        layeredPane.add((IFigure)this.getPrintableLayers(), (Object)"Printable Layers");
        layeredPane.add((IFigure)new FreeformLayer(), (Object)"Handle Layer");
        layeredPane.add((IFigure)new FeedbackLayer(), (Object)"Feedback Layer");
        layeredPane.add((IFigure)new GuideLayer(), (Object)"Guide Layer");
    }

    protected LayeredPane createPrintableLayers() {
        FreeformLayeredPane layeredPane = new FreeformLayeredPane();
        layeredPane.add((IFigure)new FreeformLayer(), (Object)"Primary Layer");
        layeredPane.add((IFigure)new ConnectionLayer(), (Object)"Connection Layer");
        return layeredPane;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == AutoexposeHelper.class) {
            return adapter.cast(new ViewportAutoexposeHelper(this));
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IFigure getContentPane() {
        return this.getLayer("Primary Layer");
    }

    @Override
    public DragTracker getDragTracker(Request req) {
        return new MarqueeDragTracker();
    }

    @Override
    public IFigure getLayer(Object key) {
        if (this.innerLayers == null) {
            return null;
        }
        Layer layer = this.innerLayers.getLayer(key);
        if (layer != null) {
            return layer;
        }
        if (this.printableLayers == null) {
            return null;
        }
        return this.printableLayers.getLayer(key);
    }

    @Override
    public Object getModel() {
        return LayerManager.ID;
    }

    protected LayeredPane getPrintableLayers() {
        if (this.printableLayers == null) {
            this.printableLayers = this.createPrintableLayers();
        }
        return this.printableLayers;
    }

    protected void refreshGridLayer() {
        boolean visible = false;
        GridLayer grid = (GridLayer)this.getLayer("Grid Layer");
        Boolean val = (Boolean)this.getViewer().getProperty("SnapToGrid.isVisible");
        if (val != null) {
            visible = val;
        }
        grid.setOrigin((Point)this.getViewer().getProperty("SnapToGrid.GridOrigin"));
        grid.setSpacing((Dimension)this.getViewer().getProperty("SnapToGrid.GridSpacing"));
        grid.setVisible(visible);
    }

    @Override
    protected void register() {
        super.register();
        if (this.getLayer("Grid Layer") != null) {
            this.getViewer().addPropertyChangeListener(this.gridListener);
            this.refreshGridLayer();
        }
    }

    @Override
    protected void unregister() {
        this.getViewer().removePropertyChangeListener(this.gridListener);
        super.unregister();
    }

    class FeedbackLayer
    extends FreeformLayer {
        FeedbackLayer() {
            this.setEnabled(false);
        }
    }
}

