/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service;

import java.math.BigInteger;
import java.util.Hashtable;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.cdt.dsf.debug.service.IModules2;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.MIFormat;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.CLIInfoSharedLibraryInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class MIModules
extends AbstractDsfService
implements IModules2,
ICachingService {
    private CommandCache fModulesCache;
    private CommandCache fModulesLoadCache;
    private CommandFactory fCommandFactory;

    public MIModules(DsfSession session) {
        super(session);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                MIModules.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        ICommandControlService commandControl = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        this.fModulesCache = new CommandCache(this.getSession(), (ICommandControl)commandControl);
        this.fModulesCache.setContextAvailable((IDMContext)commandControl.getContext(), true);
        this.fModulesLoadCache = new CommandCache(this.getSession(), (ICommandControl)commandControl);
        this.fModulesLoadCache.setContextAvailable((IDMContext)commandControl.getContext(), true);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.register(new String[]{IModules.class.getName(), IModules2.class.getName(), MIModules.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    public void getModules(final IModules.ISymbolDMContext symCtx, final DataRequestMonitor<IModules.IModuleDMContext[]> rm) {
        if (symCtx != null) {
            this.fModulesCache.execute(this.fCommandFactory.createCLIInfoSharedLibrary(symCtx), (DataRequestMonitor)new DataRequestMonitor<CLIInfoSharedLibraryInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)MIModules.this.makeModuleContexts((IDMContext)symCtx, (CLIInfoSharedLibraryInfo)this.getData()));
                    rm.done();
                }
            });
        } else {
            rm.setData((Object)new IModules.IModuleDMContext[]{new ModuleDMContext(this, DMContexts.EMPTY_CONTEXTS_ARRAY, "example module 1"), new ModuleDMContext(this, DMContexts.EMPTY_CONTEXTS_ARRAY, "example module 2")});
            rm.done();
        }
    }

    private IModules.IModuleDMContext[] makeModuleContexts(IDMContext symCtxt, CLIInfoSharedLibraryInfo info) {
        CLIInfoSharedLibraryInfo.DsfMISharedInfo[] sharedInfos = info.getMIShared();
        IModules.IModuleDMContext[] modules = new ModuleDMContext[sharedInfos.length];
        int i = 0;
        CLIInfoSharedLibraryInfo.DsfMISharedInfo[] dsfMISharedInfoArray = sharedInfos;
        int n = sharedInfos.length;
        int n2 = 0;
        while (n2 < n) {
            CLIInfoSharedLibraryInfo.DsfMISharedInfo shared = dsfMISharedInfoArray[n2];
            modules[i++] = new ModuleDMContext(this, new IDMContext[]{symCtxt}, shared.getName());
            ++n2;
        }
        return modules;
    }

    public void getModuleData(final IModules.IModuleDMContext dmc, final DataRequestMonitor<IModules.IModuleDMData> rm) {
        assert (dmc != null);
        IModules.ISymbolDMContext symDmc = (IModules.ISymbolDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IModules.ISymbolDMContext.class);
        if (symDmc != null && dmc instanceof ModuleDMContext) {
            this.fModulesCache.execute(this.fCommandFactory.createCLIInfoSharedLibrary(symDmc), (DataRequestMonitor)new DataRequestMonitor<CLIInfoSharedLibraryInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)MIModules.this.createSharedLibInfo((ModuleDMContext)dmc, (CLIInfoSharedLibraryInfo)this.getData()));
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Unknown DM Context", null));
            rm.done();
        }
    }

    public void loadSymbolsForAllModules(final IModules.ISymbolDMContext symDmc, final RequestMonitor rm) {
        assert (symDmc != null);
        if (symDmc != null) {
            this.fModulesLoadCache.execute(this.fCommandFactory.createCLISharedLibrary(symDmc), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(rm){

                protected void handleSuccess() {
                    MIModules.this.getModules(symDmc, (DataRequestMonitor<IModules.IModuleDMContext[]>)new ImmediateDataRequestMonitor<IModules.IModuleDMContext[]>(){

                        protected void handleCompleted() {
                            if (this.isSuccess()) {
                                MIModules.this.getSession().dispatchEvent((Object)new SymbolsLoadedEvent(symDmc, (IModules.IModuleDMContext[])this.getData()), MIModules.this.getProperties());
                            } else {
                                MIModules.this.getSession().dispatchEvent((Object)new SymbolsLoadedEvent(symDmc, new IModules.IModuleDMContext[0]), MIModules.this.getProperties());
                            }
                            rm.done();
                        }
                    });
                }
            });
        } else {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid DM Context", null));
        }
    }

    public void loadSymbols(final IModules.IModuleDMContext modDmc, final RequestMonitor rm) {
        assert (modDmc != null);
        final IModules.ISymbolDMContext symDmc = (IModules.ISymbolDMContext)DMContexts.getAncestorOfType((IDMContext)modDmc, IModules.ISymbolDMContext.class);
        if (symDmc != null && modDmc instanceof ModuleDMContext) {
            this.fModulesLoadCache.execute(this.fCommandFactory.createCLISharedLibrary(symDmc, ((ModuleDMContext)modDmc).getFile()), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(rm){

                protected void handleSuccess() {
                    MIModules.this.getSession().dispatchEvent((Object)new SymbolsLoadedEvent(symDmc, new IModules.IModuleDMContext[]{modDmc}), MIModules.this.getProperties());
                    rm.done();
                }
            });
        } else {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid DM Context", null));
        }
    }

    private IModules.IModuleDMData createSharedLibInfo(ModuleDMContext dmc, CLIInfoSharedLibraryInfo info) {
        CLIInfoSharedLibraryInfo.DsfMISharedInfo[] dsfMISharedInfoArray = info.getMIShared();
        int n = dsfMISharedInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            CLIInfoSharedLibraryInfo.DsfMISharedInfo shared = dsfMISharedInfoArray[n2];
            if (shared.getName().equals(dmc.fFile)) {
                return new ModuleDMData(shared.getName(), shared.getFrom(), shared.getTo(), shared.isRead());
            }
            ++n2;
        }
        return new ModuleDMData("", "", "", false);
    }

    public void calcAddressInfo(IModules.ISymbolDMContext symCtx, String file, int line, int col, DataRequestMonitor<IModules.AddressRange[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Functionality not supported", null));
        rm.done();
    }

    public void calcLineInfo(IModules.ISymbolDMContext symCtx, IAddress address, DataRequestMonitor<IModules.LineInfo[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Functionality not supported", null));
        rm.done();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IModules2.ISymbolsLoadedDMEvent e) {
        this.fModulesCache.reset();
    }

    public void flushCache(IDMContext context) {
        this.fModulesCache.reset();
        this.fModulesLoadCache.reset();
    }

    static class ModuleDMContext
    extends AbstractDMContext
    implements IModules.IModuleDMContext {
        private final String fFile;

        ModuleDMContext(MIModules service, IDMContext[] parents, String file) {
            super((IDsfService)service, parents);
            this.fFile = file;
        }

        public String getFile() {
            return this.fFile;
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj) && this.fFile.equals(((ModuleDMContext)((Object)obj)).fFile);
        }

        public int hashCode() {
            return this.baseHashCode() + this.fFile.hashCode();
        }

        public String toString() {
            return this.baseToString() + ".file[" + this.fFile + "]";
        }
    }

    static class ModuleDMData
    implements IModules.IModuleDMData {
        private final String fFile;
        private final String fFromAddress;
        private final String fToAddress;
        private final boolean fIsSymbolsRead;

        public ModuleDMData(ModuleDMContext dmc) {
            this.fFile = dmc.fFile;
            this.fFromAddress = null;
            this.fToAddress = null;
            this.fIsSymbolsRead = false;
        }

        public ModuleDMData(String fileName, String fromAddress, String toAddress, boolean isSymsRead) {
            this.fFile = fileName;
            this.fFromAddress = fromAddress;
            this.fToAddress = toAddress;
            this.fIsSymbolsRead = isSymsRead;
        }

        public String getFile() {
            return this.fFile;
        }

        public String getName() {
            return this.fFile;
        }

        public long getTimeStamp() {
            return 0L;
        }

        public String getBaseAddress() {
            return this.fFromAddress;
        }

        public String getToAddress() {
            return this.fToAddress;
        }

        public boolean isSymbolsLoaded() {
            return this.fIsSymbolsRead;
        }

        public long getSize() {
            long result = 0L;
            if (this.getBaseAddress() == null || this.getToAddress() == null) {
                return result;
            }
            BigInteger start = MIFormat.getBigInteger(this.getBaseAddress());
            BigInteger end = MIFormat.getBigInteger(this.getToAddress());
            if (end.compareTo(start) > 0) {
                result = end.subtract(start).longValue();
            }
            return result;
        }
    }

    private static class SymbolsLoadedEvent
    extends AbstractDMEvent<IModules.ISymbolDMContext>
    implements IModules2.ISymbolsLoadedDMEvent {
        private IModules.IModuleDMContext[] fModules;

        public SymbolsLoadedEvent(IModules.ISymbolDMContext context, IModules.IModuleDMContext[] modules) {
            super((IDMContext)context);
            this.fModules = modules;
        }

        public IModules.IModuleDMContext[] getModules() {
            return this.fModules;
        }
    }
}

