/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.importexecutable;

import java.io.File;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.debug.ui.importexecutable.ImportExecutablePageOne;
import org.eclipse.cdt.debug.ui.importexecutable.ImportExecutablePageTwo;
import org.eclipse.cdt.debug.ui.importexecutable.Messages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractImportExecutableWizard
extends Wizard
implements INewWizard {
    public static final String DEBUG_PROJECT_ID = "org.eclipse.cdt.debug";
    protected ImportExecutablePageOne pageOne;
    protected ImportExecutablePageTwo pageTwo;

    public void addBinaryParsers(IProject newProject) throws CoreException {
        ICProjectDescription pd = CCorePlugin.getDefault().getProjectDescription(newProject);
        String[] parserIDs = this.pageOne.getSupportedBinaryParserIds();
        int i = 0;
        while (i < parserIDs.length) {
            pd.getDefaultSettingConfiguration().create("org.eclipse.cdt.core.BinaryParser", parserIDs[i]);
            ++i;
        }
        CCorePlugin.getDefault().setProjectDescription(newProject, pd, true, (IProgressMonitor)new NullProgressMonitor());
    }

    private void addExecutables(ICProject project) {
        String[] executables = this.pageOne.getSelectedExecutables();
        int i = 0;
        while (i < executables.length) {
            IPath location = Path.fromOSString((String)executables[i]);
            String executableName = location.toFile().getName();
            IFile exeFile = project.getProject().getFile(executableName);
            try {
                exeFile.createLink(location, 256, null);
            }
            catch (Exception e) {
                this.getImportExecutablePage2().setErrorMessage("Error importing: " + executables[i]);
            }
            ++i;
        }
    }

    public void addPages() {
        super.addPages();
        this.pageOne = new ImportExecutablePageOne(this);
        this.addPage((IWizardPage)this.pageOne);
        this.pageTwo = new ImportExecutablePageTwo(this);
        this.addPage((IWizardPage)this.pageTwo);
    }

    public IProject createCProjectForExecutable(String projectName) throws OperationCanceledException, CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject newProjectHandle = workspace.getRoot().getProject(projectName);
        IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(null);
        IProject newProject = CCorePlugin.getDefault().createCProject(description, newProjectHandle, null, DEBUG_PROJECT_ID);
        return newProject;
    }

    public void createLaunchConfiguration(ICProject targetProject) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.getSelectedLaunchConfigurationType().newInstance(null, this.getImportExecutablePage2().getNewConfigurationName());
        this.setConfigurationDefaults(wc, targetProject);
        StructuredSelection selection = new StructuredSelection((Object)wc.doSave());
        String identifier = "org.eclipse.debug.ui.launchGroup.debug";
        UIJob openLaunchConfigJob = new UIJob(Messages.AbstractImportExecutableWizard_CreateLaunchConfiguration, (IStructuredSelection)selection){
            private final /* synthetic */ IStructuredSelection val$selection;
            {
                this.val$selection = iStructuredSelection;
                super($anonymous0);
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)CUIPlugin.getActiveWorkbenchShell(), (IStructuredSelection)this.val$selection, (String)"org.eclipse.debug.ui.launchGroup.debug");
                return Status.OK_STATUS;
            }
        };
        openLaunchConfigJob.schedule();
    }

    public abstract String getExecutableListLabel();

    public ImportExecutablePageOne getImportExecutablePage() {
        return this.pageOne;
    }

    public ImportExecutablePageTwo getImportExecutablePage2() {
        return this.pageTwo;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.pageOne) {
            this.pageTwo.checkExecutableSettings();
        }
        return super.getNextPage(page);
    }

    public abstract String getPageOneDescription();

    public abstract String getPageOneTitle();

    public ILaunchConfigurationType getSelectedLaunchConfigurationType() {
        return this.pageTwo.getSelectedLaunchConfigurationType();
    }

    public String getDefaultWindowTitle() {
        return Messages.AbstractImportExecutableWizard_windowTitle;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(this.getDefaultWindowTitle());
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        ICProject targetProject = null;
        try {
            if (this.pageTwo.isCreateNewProjectSelected()) {
                IProject newProject = this.createCProjectForExecutable(this.pageTwo.getNewProjectName());
                this.setupProject(newProject);
                targetProject = CCorePlugin.getDefault().getCoreModel().create(newProject);
            } else {
                targetProject = this.pageTwo.getExistingCProject();
            }
            this.addBinaryParsers(targetProject.getProject());
            this.addExecutables(targetProject);
            if (this.pageTwo.isCreateLaunchConfigurationSelected()) {
                this.createLaunchConfiguration(targetProject);
            }
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return true;
    }

    public void setConfigurationDefaults(ILaunchConfigurationWorkingCopy config, ICProject project) {
        config.setMappedResources(new IResource[]{project.getProject()});
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", project.getProject().getName());
        config.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", new File(this.getImportExecutablePage().getSelectedExecutables()[0]).getName());
    }

    public abstract void setupFileDialog(FileDialog var1);

    public void setupProject(IProject newProject) throws CoreException {
    }

    public abstract boolean supportsConfigurationType(ILaunchConfigurationType var1);

    public boolean userSelectsBinaryParser() {
        return true;
    }

    public String[] getDefaultBinaryParserIDs() {
        String defaultBinaryParserId = CCorePlugin.getDefault().getPluginPreferences().getDefaultString("binaryparser");
        if (defaultBinaryParserId == null || defaultBinaryParserId.length() == 0) {
            defaultBinaryParserId = "org.eclipse.cdt.core.ELF";
        }
        return new String[]{defaultBinaryParserId};
    }

    public String getDefaultProjectName() {
        Object defaultName = "";
        String[] executables = this.getImportExecutablePage().getSelectedExecutables();
        if (executables.length > 0) {
            String fileName = new File(executables[0]).getName();
            defaultName = Messages.ImportExecutablePageTwo_DefaultProjectPrefix + fileName;
        }
        return defaultName;
    }
}

