/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class ExternalSearchAnnotationModel
extends ResourceMarkerAnnotationModel {
    private final IPath fLocation;
    private final int fDepth;
    private final String fLocationAttribute;

    public ExternalSearchAnnotationModel(IResource markerResource, IPath location) {
        this(markerResource, location, 0, "problem.externalLocation");
    }

    ExternalSearchAnnotationModel(IResource markerResource, IPath location, int depth) {
        this(markerResource, location, depth, "problem.externalLocation");
    }

    ExternalSearchAnnotationModel(IResource markerResource, IPath location, int depth, String locationAttribute) {
        super(markerResource);
        this.fLocation = location;
        this.fDepth = depth;
        this.fLocationAttribute = locationAttribute;
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        IMarker[] markers = null;
        if (this.getResource() != null) {
            markers = this.getResource().findMarkers("org.eclipse.core.resources.marker", true, this.fDepth);
        }
        return markers;
    }

    protected boolean isAcceptable(IMarker marker) {
        boolean acceptable = false;
        String externalFileName = marker.getAttribute(this.fLocationAttribute, null);
        if (externalFileName != null) {
            Path externalPath = new Path(externalFileName);
            acceptable = externalPath.equals((Object)this.fLocation);
        }
        return acceptable;
    }
}

