/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.cdtserial.launcher;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.cdt.serial.ByteSize;
import org.eclipse.cdt.serial.Parity;
import org.eclipse.cdt.serial.StopBits;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.terminal.connector.ISettingsStore;
import org.eclipse.terminal.connector.ITerminalConnector;
import org.eclipse.terminal.connector.InMemorySettingsStore;
import org.eclipse.terminal.connector.TerminalConnectorExtension;
import org.eclipse.terminal.view.core.ITerminalService;
import org.eclipse.terminal.view.ui.launcher.AbstractLauncherDelegate;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanel;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanelContainer;
import org.eclipse.tm.terminal.connector.cdtserial.connector.SerialSettings;
import org.eclipse.tm.terminal.connector.cdtserial.controls.SerialConfigPanel;

public class SerialLauncherDelegate
extends AbstractLauncherDelegate {
    public boolean needsUserConfiguration() {
        return true;
    }

    public IConfigurationPanel getPanel(IConfigurationPanelContainer container) {
        return new SerialConfigPanel(container);
    }

    public ITerminalConnector createTerminalConnector(Map<String, Object> properties) throws CoreException {
        Assert.isNotNull(properties);
        String connectorId = (String)properties.get("tm.terminal.connector.id");
        if (connectorId == null) {
            connectorId = "org.eclipse.tm.terminal.connector.cdtserial.SerialConnector";
        }
        SerialSettings settings = new SerialSettings();
        settings.setPortName((String)properties.get("cdtserial.portName"));
        settings.setBaudRateValue((Integer)properties.get("cdtserial.baudRate"));
        settings.setByteSize((ByteSize)properties.get("cdtserial.byteSize"));
        settings.setParity((Parity)properties.get("cdtserial.parity"));
        settings.setStopBits((StopBits)properties.get("cdtserial.stopBits"));
        InMemorySettingsStore store = new InMemorySettingsStore();
        settings.save((ISettingsStore)store);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        connector.setDefaultSettings();
        connector.load((ISettingsStore)store);
        return connector;
    }

    public CompletableFuture<?> execute(Map<String, Object> properties) {
        Assert.isNotNull(properties);
        String name = (String)properties.get("cdtserial.portName");
        properties.put("title", name);
        if (!properties.containsKey("terminal.forceNew")) {
            properties.put("terminal.forceNew", Boolean.TRUE);
        }
        ITerminalService terminal = this.getTerminalService();
        return terminal.openConsole(properties);
    }
}

