/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.io.OutputStream;
import java.net.URI;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.internal.core.ConsoleOutputSniffer;
import org.eclipse.cdt.make.core.MakeBuilder;
import org.eclipse.cdt.make.core.MakeBuilderUtil;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfile;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ScannerInfoConsoleParserFactory {
    public static ConsoleOutputSniffer getESIProviderOutputSniffer(OutputStream outputStream, OutputStream errorStream, IProject project, String id, IScannerConfigBuilderInfo2 info2, IScannerInfoCollector collector, IMarkerGenerator markerGenerator) {
        return ScannerInfoConsoleParserFactory.getESIProviderOutputSniffer(outputStream, errorStream, project, new InfoContext(project), id, info2, collector, markerGenerator);
    }

    public static ConsoleOutputSniffer getESIProviderOutputSniffer(OutputStream outputStream, OutputStream errorStream, IProject project, InfoContext infoContext, String id, IScannerConfigBuilderInfo2 info2, IScannerInfoCollector collector, IMarkerGenerator markerGenerator) {
        IScannerInfoConsoleParser parser = ScannerInfoConsoleParserFactory.getESIConsoleParser(project, infoContext, id, info2, collector, markerGenerator);
        if (parser != null) {
            return new ConsoleOutputSniffer(outputStream, errorStream, (IConsoleParser[])new IScannerInfoConsoleParser[]{parser});
        }
        return null;
    }

    public static IScannerInfoConsoleParser getESIConsoleParser(IProject project, InfoContext infoContext, String id, IScannerConfigBuilderInfo2 info2, IScannerInfoCollector collector, IMarkerGenerator markerGenerator) {
        if (info2.isProviderOutputParserEnabled(id)) {
            SCProfileInstance profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, infoContext, info2.getSelectedProfileId());
            IScannerInfoConsoleParser parser = profileInstance.createExternalScannerInfoParser(id);
            IPath buildDirectory = MakeBuilderUtil.getBuildDirectory(project, MakeBuilder.BUILDER_ID);
            parser.startup(project, buildDirectory, collector, markerGenerator);
            return parser;
        }
        return null;
    }

    public static ConsoleOutputSniffer getMakeBuilderOutputSniffer(OutputStream outputStream, OutputStream errorStream, IProject project, IPath workingDirectory, IScannerConfigBuilderInfo2 info2, IMarkerGenerator markerGenerator, IScannerInfoCollector collector) {
        return ScannerInfoConsoleParserFactory.getMakeBuilderOutputSniffer(outputStream, errorStream, project, new InfoContext(project), workingDirectory, info2, markerGenerator, collector);
    }

    public static ConsoleOutputSniffer getMakeBuilderOutputSniffer(OutputStream outputStream, OutputStream errorStream, IProject project, InfoContext infoContext, IPath workingDirectory, IScannerConfigBuilderInfo2 info2, IMarkerGenerator markerGenerator, IScannerInfoCollector collector) {
        IScannerInfoConsoleParser parser = ScannerInfoConsoleParserFactory.getScannerInfoConsoleParserInternal(project, infoContext, workingDirectory, info2, markerGenerator, collector);
        if (parser != null) {
            return new ConsoleOutputSniffer(outputStream, errorStream, (IConsoleParser[])new IScannerInfoConsoleParser[]{parser});
        }
        return null;
    }

    private static IScannerInfoConsoleParser getScannerInfoConsoleParserInternal(IProject project, InfoContext infoContext, IPath workingDirectory, IScannerConfigBuilderInfo2 info2, IMarkerGenerator markerGenerator, IScannerInfoCollector collector) {
        IScannerInfoConsoleParser parser = null;
        if (info2 == null) {
            try {
                IScannerConfigBuilderInfo2Set container = ScannerConfigProfileManager.createScannerConfigBuildInfo2Set(project);
                info2 = container.getInfo(infoContext);
            }
            catch (CoreException container) {
                // empty catch block
            }
        }
        if (info2 != null && info2.isAutoDiscoveryEnabled() && info2.isBuildOutputParserEnabled()) {
            String id = info2.getSelectedProfileId();
            SCProfileInstance profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, infoContext, id);
            parser = profileInstance.createBuildOutputParser();
            if (parser != null) {
                if (collector == null) {
                    collector = profileInstance.getScannerInfoCollector();
                }
                parser.startup(project, workingDirectory, collector, (IMarkerGenerator)(info2.isProblemReportingEnabled() ? markerGenerator : null));
            }
        }
        return parser;
    }

    public static IScannerInfoConsoleParser getScannerInfoConsoleParser(IProject project, URI workingDirectoryURI, IMarkerGenerator markerGenerator) {
        String pathFromURI = EFSExtensionManager.getDefault().getPathFromURI(workingDirectoryURI);
        if (pathFromURI == null) {
            pathFromURI = System.getProperty("user.dir");
        }
        return ScannerInfoConsoleParserFactory.getScannerInfoConsoleParserInternal(project, new InfoContext(project), (IPath)new Path(pathFromURI), null, markerGenerator, null);
    }

    public static IScannerInfoConsoleParser getScannerInfoConsoleParser(IProject project, InfoContext infoContext, IPath workingDirectory, IScannerConfigBuilderInfo2 info2, IMarkerGenerator markerGenerator, IScannerInfoCollector collector) {
        IScannerInfoConsoleParser parser = null;
        if (info2 != null && info2.isAutoDiscoveryEnabled() && info2.isBuildOutputParserEnabled()) {
            SCProfileInstance profileInstance;
            String id = info2.getSelectedProfileId();
            ScannerConfigProfile profile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(id);
            if (profile.getBuildOutputProviderElement() != null && (parser = (profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, infoContext, id)).createBuildOutputParser()) != null) {
                if (collector == null) {
                    collector = profileInstance.getScannerInfoCollector();
                }
                parser.startup(project, workingDirectory, collector, (IMarkerGenerator)(info2.isProblemReportingEnabled() ? markerGenerator : null));
            }
        }
        return parser;
    }
}

