/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.serial;

public enum ByteSize {
    B5(5),
    B6(6),
    B7(7),
    B8(8);

    private final int size;
    private static final String[] strings;
    private static final ByteSize[] sizes;

    static {
        strings = new String[]{"5", "6", "7", "8"};
        sizes = new ByteSize[]{B5, B6, B7, B8};
    }

    private ByteSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public static String[] getStrings() {
        return strings;
    }

    public static ByteSize fromStringIndex(int size) {
        return sizes[size];
    }

    public static int getStringIndex(ByteSize size) {
        int i = 0;
        while (i < sizes.length) {
            if (size.equals((Object)sizes[i])) {
                return i;
            }
            ++i;
        }
        return ByteSize.getStringIndex(ByteSize.getDefault());
    }

    public static ByteSize getDefault() {
        return B8;
    }
}

