/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.scm;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.scm.MavenProjectScmInfo;
import org.eclipse.m2e.scm.internal.Messages;
import org.eclipse.m2e.scm.internal.ScmHandlerFactory;
import org.eclipse.m2e.scm.spi.ScmHandler;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenCheckoutOperation {
    private static final Logger log = LoggerFactory.getLogger(MavenCheckoutOperation.class);
    private final File location;
    private final Collection<MavenProjectScmInfo> mavenProjects;
    private final List<String> locations = new ArrayList<String>();

    public MavenCheckoutOperation(File location, Collection<MavenProjectScmInfo> mavenProjects) {
        this.location = location;
        this.mavenProjects = mavenProjects;
    }

    public void run(IProgressMonitor monitor) throws InterruptedException, CoreException {
        ArrayList<MavenProjectScmInfo> flatProjects = new ArrayList<MavenProjectScmInfo>();
        for (MavenProjectScmInfo info : this.mavenProjects) {
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            String folderUrl = info.getFolderUrl();
            monitor.setTaskName(NLS.bind((String)Messages.MavenCheckoutOperation_task_scanning, (Object)info.getLabel(), (Object)info.getFolderUrl()));
            boolean isNestedPath = false;
            for (MavenProjectScmInfo info2 : this.mavenProjects) {
                String path;
                if (info == info2 || !folderUrl.startsWith((path = info2.getFolderUrl()) + "/")) continue;
                isNestedPath = true;
                break;
            }
            if (isNestedPath) continue;
            flatProjects.add(info);
        }
        for (MavenProjectScmInfo info : flatProjects) {
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            monitor.setTaskName(NLS.bind((String)Messages.MavenCheckoutOperation_task_checking, (Object)info.getLabel(), (Object)info.getFolderUrl()));
            File workspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
            File location = this.getUniqueDir(this.location == null ? workspaceRoot : this.location);
            ScmHandler handler = ScmHandlerFactory.getHandler(info.getFolderUrl());
            if (handler == null) {
                String msg = "SCM provider is not available for " + info.getFolderUrl();
                log.error(msg);
                continue;
            }
            handler.checkoutProject(info, location, monitor);
            this.locations.add(location.getAbsolutePath());
        }
    }

    protected File getUniqueDir(File baseDir) {
        long suffix = System.currentTimeMillis();
        File tempDir;
        while ((tempDir = new File(baseDir, "maven." + suffix)).exists()) {
            ++suffix;
        }
        return tempDir;
    }

    public Collection<MavenProjectScmInfo> getMavenProjects() {
        return this.mavenProjects;
    }

    public List<String> getLocations() {
        return this.locations;
    }
}

