/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.junit.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;

final class SPIMapping {
    private final Class<?> serviceClass;
    private final Bundle bundle;
    private final Set<String> classes;
    private final URL url;

    SPIMapping(Class<?> serviceClass, Bundle bundle, URL url) {
        this.serviceClass = serviceClass;
        this.bundle = bundle;
        this.url = url;
        this.classes = this.readClasses(url);
    }

    private Set<String> readClasses(URL entry) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(entry.openStream()));){
                return reader.lines().collect(Collectors.toSet());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return new HashSet<String>();
        }
    }

    boolean isCompatible(Bundle other) {
        try {
            return other.loadClass(this.serviceClass.getName()) == this.serviceClass;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    URL getUrl() {
        return this.url;
    }

    boolean hasService(String implementation) {
        return this.classes != null && this.classes.contains(implementation);
    }

    Class<?> loadImplementation(String name) throws ClassNotFoundException {
        return this.bundle.loadClass(name);
    }
}

