/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.namemapping;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.eclipse.m2e.wtp.ArtifactHelper;
import org.eclipse.m2e.wtp.namemapping.FileNameMapping;

public abstract class AbstractFileNameMapping
implements FileNameMapping {
    private boolean useBaseVersion;
    private boolean useGroupIdInWarName;

    protected String generateFileName(Artifact a, boolean addVersion) {
        ArtifactHandler artifactHandler = a.getArtifactHandler();
        ArtifactHelper.fixArtifactHandler(artifactHandler);
        String extension = artifactHandler.getExtension();
        StringBuilder buffer = new StringBuilder(128);
        if (this.getUseGroupIdInWarName()) {
            buffer.append(a.getGroupId() + "-");
        }
        buffer.append(a.getArtifactId());
        if (addVersion) {
            buffer.append('-');
            if (this.useBaseVersion) {
                buffer.append(a.getBaseVersion());
            } else {
                buffer.append(a.getVersion());
            }
        }
        if (a.hasClassifier()) {
            buffer.append('-').append(a.getClassifier());
        }
        if (extension != null && extension.length() > 0) {
            buffer.append('.').append(extension);
        }
        return buffer.toString();
    }

    public void setUseBaseVersion(boolean useBaseVersion) {
        this.useBaseVersion = useBaseVersion;
    }

    public boolean isUseBaseVersion() {
        return this.useBaseVersion;
    }

    public void setUseGroupIdInWarName(boolean useGroupIdInWarName) {
        this.useGroupIdInWarName = useGroupIdInWarName;
    }

    public boolean getUseGroupIdInWarName() {
        return this.useGroupIdInWarName;
    }
}

