/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.wst.common.frameworks.internal.activities.WTPActivityBridgeHelper;

public class WTPActivityBridgeHelperImpl
implements WTPActivityBridgeHelper {
    private IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
    private IActivityManager activityManager = this.workbenchActivitySupport.getActivityManager();

    public void enableActivity(String activityID, boolean enabled) {
        Set enabledActivities = this.activityManager.getEnabledActivityIds();
        HashSet<String> newEnabledActivities = null;
        if (enabled && !enabledActivities.contains(activityID)) {
            newEnabledActivities = new HashSet<String>();
            newEnabledActivities.addAll(enabledActivities);
            newEnabledActivities.add(activityID);
        }
        if (!enabled && enabledActivities.contains(activityID)) {
            newEnabledActivities = new HashSet();
            newEnabledActivities.addAll(enabledActivities);
            newEnabledActivities.remove(activityID);
        }
        if (newEnabledActivities != null) {
            this.setEnabledActivityIds(newEnabledActivities);
        }
    }

    public Set getEnabledActivityIds() {
        return this.activityManager.getEnabledActivityIds();
    }

    public void setEnabledActivityIds(Set activityIDs) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display.getThread() == Thread.currentThread()) {
            this.workbenchActivitySupport.setEnabledActivityIds(activityIDs);
        } else {
            final Set newActivityIDs = activityIDs;
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    WTPActivityBridgeHelperImpl.this.workbenchActivitySupport.setEnabledActivityIds(newActivityIDs);
                }
            });
        }
    }

    public Set getActivityIDsFromContribution(final String localID, final String pluginID) {
        IIdentifier identifier = this.activityManager.getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)new IPluginContribution(){

            public String getLocalId() {
                return localID;
            }

            public String getPluginId() {
                return pluginID;
            }
        }));
        return identifier.getActivityIds();
    }
}

