/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.tasks;

import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.build.Workspace;
import aQute.bnd.osgi.Builder;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.pde.bnd.ui.Central;
import org.eclipse.pde.bnd.ui.Workspaces;
import org.eclipse.pde.bnd.ui.internal.FileUtils;
import org.eclipse.pde.bnd.ui.tasks.BndBuilderCapReqLoader;

public class BndFileCapReqLoader
extends BndBuilderCapReqLoader {
    private Builder builder;

    public BndFileCapReqLoader(File bndFile) {
        super(bndFile);
    }

    @Override
    protected synchronized Builder getBuilder() throws Exception {
        if (this.builder == null) {
            Builder b;
            IFile[] wsfiles = FileUtils.getWorkspaceFiles(this.file);
            if (wsfiles == null || wsfiles.length == 0) {
                throw new Exception("Unable to determine project owner for Bnd file: " + this.file.getAbsolutePath());
            }
            IProject project = wsfiles[0].getProject();
            Workspace ws = Workspaces.getWorkspace(project).orElse(null);
            Project bndProject = Central.getProject(ws, project);
            if (bndProject == null) {
                return null;
            }
            if (this.file.getName().equals("bnd.bnd")) {
                ProjectBuilder pb = bndProject.getBuilder(null);
                boolean close = true;
                try {
                    b = (Builder)pb.getSubBuilders().get(0);
                    if (b == pb) {
                        close = false;
                    }
                    pb.removeClose((AutoCloseable)b);
                }
                finally {
                    if (close) {
                        pb.close();
                    }
                }
            } else {
                b = bndProject.getSubBuilder(this.file);
            }
            if (b == null) {
                b = new Builder();
                b.setProperties(this.file);
            }
            b.build();
            this.builder = b;
        }
        return this.builder;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.builder != null) {
            this.builder.close();
        }
        this.builder = null;
    }
}

