/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.tasks;

import aQute.bnd.service.resource.SupportingResource;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.pde.bnd.ui.ResourceUtils;
import org.eclipse.pde.bnd.ui.model.resolution.RequirementWrapper;
import org.eclipse.pde.bnd.ui.tasks.CapReqLoader;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class ResourceCapReqLoader
implements CapReqLoader {
    private final Resource resource;
    private final String name;
    private final URI uri;

    public ResourceCapReqLoader(Resource resource) {
        this.resource = resource;
        this.name = ResourceUtils.getIdentity(resource);
        URI uri = null;
        try {
            uri = ResourceUtils.getURI(ResourceUtils.getContentCapability(resource));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.uri = uri;
    }

    @Override
    public String getShortLabel() {
        return this.name;
    }

    @Override
    public String getLongLabel() {
        return this.name + "[" + String.valueOf(this.uri) + "]";
    }

    @Override
    public Map<String, List<Capability>> loadCapabilities() throws Exception {
        HashMap<String, List<Capability>> result = new HashMap<String, List<Capability>>();
        ArrayList caps = new ArrayList(this.resource.getCapabilities(null));
        Resource resource = this.resource;
        if (resource instanceof SupportingResource) {
            SupportingResource sr = (SupportingResource)resource;
            for (Resource r : sr.getSupportingResources()) {
                caps.addAll(r.getCapabilities(null));
            }
        }
        for (Capability cap : caps) {
            String ns = cap.getNamespace();
            LinkedList<Capability> listForNamespace = (LinkedList<Capability>)result.get(ns);
            if (listForNamespace == null) {
                listForNamespace = new LinkedList<Capability>();
                result.put(ns, listForNamespace);
            }
            listForNamespace.add(cap);
        }
        return result;
    }

    @Override
    public Map<String, List<RequirementWrapper>> loadRequirements() throws Exception {
        HashMap<String, List<RequirementWrapper>> result = new HashMap<String, List<RequirementWrapper>>();
        ArrayList reqs = new ArrayList(this.resource.getRequirements(null));
        Resource resource = this.resource;
        if (resource instanceof SupportingResource) {
            SupportingResource sr = (SupportingResource)resource;
            for (Resource r : sr.getSupportingResources()) {
                reqs.addAll(r.getRequirements(null));
            }
        }
        for (Requirement req : reqs) {
            String ns = req.getNamespace();
            LinkedList<RequirementWrapper> listForNamespace = (LinkedList<RequirementWrapper>)result.get(ns);
            if (listForNamespace == null) {
                listForNamespace = new LinkedList<RequirementWrapper>();
                result.put(ns, listForNamespace);
            }
            RequirementWrapper wrapper = new RequirementWrapper(req);
            listForNamespace.add(wrapper);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceCapReqLoader other = (ResourceCapReqLoader)obj;
        return Objects.equals(this.resource, other.resource);
    }
}

