/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathDirectory;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.IModuleAwareNameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.core.INameEnvironmentWithProgress;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.NameLookup;

class NameEnvironmentWithProgress
extends FileSystem
implements INameEnvironmentWithProgress {
    IProgressMonitor monitor;

    public NameEnvironmentWithProgress(FileSystem.Classpath[] paths, String[] initialFileNames, IProgressMonitor monitor) {
        super(paths, initialFileNames, false);
        this.setMonitor(monitor);
    }

    private void checkCanceled() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            if (NameLookup.VERBOSE) {
                JavaModelManager.trace(String.valueOf(Thread.currentThread()) + " CANCELLING LOOKUP ");
            }
            throw new AbortCompilation(true, (RuntimeException)((Object)new OperationCanceledException()));
        }
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName, char[] moduleName) {
        return this.findType(typeName, packageName, true, moduleName);
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName, boolean searchWithSecondaryTypes, char[] moduleName) {
        this.checkCanceled();
        NameEnvironmentAnswer answer = super.findType(typeName, packageName, moduleName);
        if (answer == null && searchWithSecondaryTypes) {
            NameEnvironmentAnswer suggestedAnswer = null;
            String qualifiedPackageName = new String(CharOperation.concatWith((char[][])packageName, (char)'/'));
            String qualifiedTypeName = new String(CharOperation.concatWith((char[][])packageName, (char[])typeName, (char)'/'));
            String qualifiedBinaryFileName = qualifiedTypeName + ".class";
            FileSystem.Classpath[] classpathArray = this.classpaths;
            int n = this.classpaths.length;
            int n2 = 0;
            while (n2 < n) {
                FileSystem.Classpath classpath = classpathArray[n2];
                if (classpath instanceof ClasspathDirectory) {
                    ClasspathDirectory classpathDirectory = (ClasspathDirectory)classpath;
                    IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get((char[])moduleName);
                    if (strategy.matchesWithName((Object)classpathDirectory, loc -> loc.getModule() != null, loc -> loc.servesModule(moduleName)) && (answer = classpathDirectory.findSecondaryInClass(typeName, qualifiedPackageName, qualifiedBinaryFileName)) != null) {
                        if (!answer.ignoreIfBetter()) {
                            if (answer.isBetter(suggestedAnswer)) {
                                return answer;
                            }
                        } else if (answer.isBetter(suggestedAnswer)) {
                            suggestedAnswer = answer;
                        }
                    }
                }
                ++n2;
            }
        }
        return answer;
    }

    public NameEnvironmentAnswer findType(char[][] compoundName) {
        this.checkCanceled();
        return super.findType(compoundName);
    }

    public boolean isPackage(char[][] compoundName, char[] packageName) {
        this.checkCanceled();
        return super.isPackage(compoundName, packageName);
    }

    @Override
    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

