/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.target;

import java.util.List;
import java.util.Objects;
import org.apache.maven.model.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.m2e.pde.target.MavenTargetLocation;

public final class MavenTargetDependency
extends Dependency {
    private MavenTargetLocation location;

    public MavenTargetDependency(String groupId, String artifactId, String version, String artifactType, String classifier) {
        this.setGroupId(groupId);
        this.setArtifactId(artifactId);
        this.setVersion(version);
        if (artifactType != null && !artifactType.isBlank()) {
            this.setType(artifactType);
        } else {
            this.setType("jar");
        }
        this.setClassifier(classifier);
    }

    public List<DependencyNode> getDependencyNodes() {
        if (this.location == null) {
            return null;
        }
        return this.location.getDependencyNodes(this);
    }

    public String getKey() {
        String type;
        String key = this.getGroupId() + ":" + this.getArtifactId();
        String classifier = this.getClassifier();
        if (classifier != null && !classifier.isBlank()) {
            key = key + ":" + classifier;
        }
        if ((type = this.getType()) != null && !type.isBlank()) {
            key = key + ":" + type;
        }
        key = key + ":" + this.getVersion();
        return key;
    }

    public void bind(MavenTargetLocation mavenTargetLocation) {
        if (this.location != null) {
            throw new IllegalStateException("already bound!");
        }
        this.location = mavenTargetLocation;
    }

    public MavenTargetDependency copy() {
        return new MavenTargetDependency(this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getType(), this.getClassifier());
    }

    public boolean matches(Dependency other) {
        return Objects.equals(other.getGroupId(), this.getGroupId()) && Objects.equals(other.getArtifactId(), this.getArtifactId()) && Objects.equals(other.getVersion(), this.getVersion()) && Objects.equals(other.getType(), this.getType()) && Objects.equals(other.getClassifier(), this.getClassifier());
    }
}

