/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.serialize;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class DOMSerializer {
    private boolean namespaceDeclarationAttribute;
    private boolean parentsNamespaceDeclarationDisabled;
    private boolean startingDocument = true;

    public void setNamespaceDeclarationAttribute(boolean pXmlDeclarationAttribute) {
        this.namespaceDeclarationAttribute = pXmlDeclarationAttribute;
    }

    public boolean isNamespaceDeclarationAttribute() {
        return this.namespaceDeclarationAttribute;
    }

    public void setParentsNamespaceDeclarationDisabled(boolean pParentsXmlDeclarationDisabled) {
        this.parentsNamespaceDeclarationDisabled = pParentsXmlDeclarationDisabled;
    }

    public boolean isParentsNamespaceDeclarationDisabled() {
        return this.parentsNamespaceDeclarationDisabled;
    }

    public boolean isStartingDocument() {
        return this.startingDocument;
    }

    public void setStartingDocument(boolean pStartingDocument) {
        this.startingDocument = pStartingDocument;
    }

    protected void doSerializeChilds(Node pNode, ContentHandler pHandler) throws SAXException {
        for (Node child = pNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.doSerialize(child, pHandler);
        }
    }

    private void parentsStartPrefixMappingEvents(Node pNode, ContentHandler pHandler) throws SAXException {
        if (pNode != null) {
            this.parentsStartPrefixMappingEvents(pNode.getParentNode(), pHandler);
            if (pNode.getNodeType() == 1) {
                this.startPrefixMappingEvents(pNode, pHandler);
            }
        }
    }

    private void parentsEndPrefixMappingEvents(Node pNode, ContentHandler pHandler) throws SAXException {
        if (pNode != null) {
            if (pNode.getNodeType() == 1) {
                this.endPrefixMappingEvents(pNode, pHandler);
            }
            this.parentsEndPrefixMappingEvents(pNode.getParentNode(), pHandler);
        }
    }

    private void startPrefixMappingEvents(Node pNode, ContentHandler pHandler) throws SAXException {
        NamedNodeMap nnm = pNode.getAttributes();
        if (nnm != null) {
            for (int i = 0; i < nnm.getLength(); ++i) {
                String prefix;
                Node attr = nnm.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
                if ("xmlns".equals(attr.getPrefix())) {
                    prefix = attr.getLocalName();
                } else if ("xmlns".equals(attr.getNodeName())) {
                    prefix = "";
                } else {
                    throw new IllegalStateException("Unable to parse namespace declaration: " + attr.getNodeName());
                }
                String uri = attr.getNodeValue();
                if (uri == null) {
                    uri = "";
                }
                pHandler.startPrefixMapping(prefix, uri);
            }
        }
    }

    private void endPrefixMappingEvents(Node pNode, ContentHandler pHandler) throws SAXException {
        NamedNodeMap nnm = pNode.getAttributes();
        if (nnm != null) {
            for (int i = nnm.getLength() - 1; i >= 0; --i) {
                Node attr = nnm.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
                String prefix = attr.getLocalName();
                pHandler.endPrefixMapping(prefix);
            }
        }
    }

    private void characters(ContentHandler pHandler, String pValue, boolean pCdata) throws SAXException {
        LexicalHandler lh = pCdata ? (pHandler instanceof LexicalHandler ? (LexicalHandler)((Object)pHandler) : null) : null;
        if (lh != null) {
            lh.startCDATA();
        }
        pHandler.characters(pValue.toCharArray(), 0, pValue.length());
        if (lh != null) {
            lh.endCDATA();
        }
    }

    public void serialize(Node pNode, ContentHandler pHandler) throws SAXException {
        if (!this.isNamespaceDeclarationAttribute() && !this.isParentsNamespaceDeclarationDisabled()) {
            this.parentsStartPrefixMappingEvents(pNode.getParentNode(), pHandler);
        }
        this.doSerialize(pNode, pHandler);
        if (!this.isNamespaceDeclarationAttribute() && !this.isParentsNamespaceDeclarationDisabled()) {
            this.parentsEndPrefixMappingEvents(pNode.getParentNode(), pHandler);
        }
    }

    protected void doSerialize(Node pNode, ContentHandler pHandler) throws SAXException {
        switch (pNode.getNodeType()) {
            case 9: {
                boolean startDocumentEvent = this.isStartingDocument();
                if (startDocumentEvent) {
                    pHandler.startDocument();
                }
                this.doSerializeChilds(pNode, pHandler);
                if (!startDocumentEvent) break;
                pHandler.endDocument();
                break;
            }
            case 11: {
                this.doSerializeChilds(pNode, pHandler);
                break;
            }
            case 1: {
                String nUri;
                NamedNodeMap nnm;
                AttributesImpl attr = new AttributesImpl();
                boolean isNamespaceDeclarationAttribute = this.isNamespaceDeclarationAttribute();
                if (!isNamespaceDeclarationAttribute) {
                    this.startPrefixMappingEvents(pNode, pHandler);
                }
                if ((nnm = pNode.getAttributes()) != null) {
                    for (int i = 0; i < nnm.getLength(); ++i) {
                        Node a = nnm.item(i);
                        if (!isNamespaceDeclarationAttribute && "http://www.w3.org/2000/xmlns/".equals(a.getNamespaceURI())) continue;
                        String aUri = a.getNamespaceURI();
                        String aLocalName = a.getLocalName();
                        String aNodeName = a.getNodeName();
                        if (aLocalName == null) {
                            if (aUri == null || aUri.length() == 0) {
                                aLocalName = aNodeName;
                            } else {
                                throw new IllegalStateException("aLocalName is null");
                            }
                        }
                        attr.addAttribute(aUri == null ? "" : aUri, aNodeName, aLocalName, "CDATA", a.getNodeValue());
                    }
                }
                if ((nUri = pNode.getNamespaceURI()) == null) {
                    nUri = "";
                }
                pHandler.startElement(nUri, pNode.getLocalName(), pNode.getNodeName(), attr);
                this.doSerializeChilds(pNode, pHandler);
                pHandler.endElement(nUri, pNode.getLocalName(), pNode.getNodeName());
                if (isNamespaceDeclarationAttribute) break;
                this.endPrefixMappingEvents(pNode, pHandler);
                break;
            }
            case 3: {
                this.characters(pHandler, pNode.getNodeValue(), false);
                break;
            }
            case 4: {
                this.characters(pHandler, pNode.getNodeValue(), true);
                break;
            }
            case 7: {
                pHandler.processingInstruction(pNode.getNodeName(), pNode.getNodeValue());
                break;
            }
            case 5: {
                pHandler.skippedEntity(pNode.getNodeName());
                break;
            }
            case 8: {
                if (!(pHandler instanceof LexicalHandler)) break;
                String s = pNode.getNodeValue();
                ((LexicalHandler)((Object)pHandler)).comment(s.toCharArray(), 0, s.length());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown node type: " + pNode.getNodeType());
            }
        }
    }
}

