/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.resource;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.Resources;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;

public abstract class ResourceChange
extends Change {
    public static final int VALIDATE_DEFAULT = 0;
    public static final int VALIDATE_NOT_READ_ONLY = 1;
    public static final int VALIDATE_NOT_DIRTY = 2;
    public static final int SAVE_IF_DIRTY = 4;
    private long fModificationStamp = -1L;
    private boolean fReadOnly = false;
    private int fValidationMethod = 0;

    protected abstract IResource getModifiedResource();

    @Override
    public void initializeValidationData(IProgressMonitor pm) {
        IResource resource = this.getModifiedResource();
        if (resource != null) {
            this.fModificationStamp = this.getModificationStamp(resource);
            this.fReadOnly = Resources.isReadOnly(resource);
        }
    }

    public void setValidationMethod(int validationMethod) {
        this.fValidationMethod = validationMethod;
    }

    @Override
    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (int)2);
        RefactoringStatus result = new RefactoringStatus();
        IResource resource = this.getModifiedResource();
        ResourceChange.checkExistence(result, resource);
        subMonitor.worked(1);
        if (result.hasFatalError()) {
            return result;
        }
        if (this.fValidationMethod == 0) {
            return result;
        }
        ValidationState state = new ValidationState(resource);
        state.checkModificationStamp(result, this.fModificationStamp);
        if (result.hasFatalError()) {
            return result;
        }
        state.checkSameReadOnly(result, this.fReadOnly);
        if (result.hasFatalError()) {
            return result;
        }
        if ((this.fValidationMethod & 1) != 0) {
            state.checkReadOnly(result);
            if (result.hasFatalError()) {
                return result;
            }
        }
        if ((this.fValidationMethod & 4) != 0) {
            state.saveIfDirty(result, this.fModificationStamp, (IProgressMonitor)subMonitor.newChild(1));
        }
        if ((this.fValidationMethod & 2) != 0) {
            state.checkDirty(result);
        }
        return result;
    }

    protected static void checkIfModifiable(RefactoringStatus result, IResource resource, int validationMethod) {
        ResourceChange.checkExistence(result, resource);
        if (result.hasFatalError()) {
            return;
        }
        if (validationMethod == 0) {
            return;
        }
        ValidationState state = new ValidationState(resource);
        if ((validationMethod & 1) != 0) {
            state.checkReadOnly(result);
            if (result.hasFatalError()) {
                return;
            }
        }
        if ((validationMethod & 2) != 0) {
            state.checkDirty(result);
        }
    }

    private static void checkExistence(RefactoringStatus status, IResource element) {
        if (element == null) {
            status.addFatalError(RefactoringCoreMessages.ResourceChange_error_no_input);
        } else if (!element.exists()) {
            status.addFatalError(Messages.format(RefactoringCoreMessages.ResourceChange_error_does_not_exist, BasicElementLabels.getPathLabel(element.getFullPath(), false)));
        }
    }

    @Override
    public Object getModifiedElement() {
        return this.getModifiedResource();
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - void declaration
     */
    private long getModificationStamp(IResource resource) {
        void file;
        if (!(resource instanceof IFile)) {
            return resource.getModificationStamp();
        }
        IFile iFile = (IFile)resource;
        ITextFileBuffer buffer = ResourceChange.getBuffer((IFile)file);
        if (buffer == null) {
            return file.getModificationStamp();
        }
        IDocument document = buffer.getDocument();
        if (document instanceof IDocumentExtension4) {
            return ((IDocumentExtension4)document).getModificationStamp();
        }
        return file.getModificationStamp();
    }

    private static ITextFileBuffer getBuffer(IFile file) {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        return manager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
    }

    private static class ValidationState {
        private final IResource fResource;
        private int fKind;
        private boolean fDirty;
        private boolean fReadOnly;
        private long fModificationStamp;
        private ITextFileBuffer fTextFileBuffer;
        public static final int RESOURCE = 1;
        public static final int DOCUMENT = 2;

        public ValidationState(IResource resource) {
            this.fResource = resource;
            if (resource instanceof IFile) {
                this.initializeFile((IFile)resource);
            } else {
                this.initializeResource(resource);
            }
        }

        public void saveIfDirty(RefactoringStatus status, long stampToMatch, IProgressMonitor pm) throws CoreException {
            if (this.fDirty) {
                if (this.fKind == 2 && this.fTextFileBuffer != null && stampToMatch == this.fModificationStamp) {
                    this.fTextFileBuffer.commit(pm, false);
                } else {
                    status.addFatalError(Messages.format(RefactoringCoreMessages.ResourceChange_error_unsaved, BasicElementLabels.getPathLabel(this.fResource.getFullPath(), false)));
                }
            }
        }

        public void checkDirty(RefactoringStatus status) {
            if (this.fDirty) {
                status.addFatalError(Messages.format(RefactoringCoreMessages.ResourceChange_error_unsaved, BasicElementLabels.getPathLabel(this.fResource.getFullPath(), false)));
            }
        }

        public void checkReadOnly(RefactoringStatus status) {
            if (this.fReadOnly) {
                status.addFatalError(Messages.format(RefactoringCoreMessages.ResourceChange_error_read_only, BasicElementLabels.getPathLabel(this.fResource.getFullPath(), false)));
            }
        }

        public void checkSameReadOnly(RefactoringStatus status, boolean valueToMatch) {
            if (this.fReadOnly != valueToMatch) {
                status.addFatalError(Messages.format(RefactoringCoreMessages.ResourceChange_error_read_only_state_changed, BasicElementLabels.getPathLabel(this.fResource.getFullPath(), false)));
            }
        }

        public void checkModificationStamp(RefactoringStatus status, long stampToMatch) {
            if (this.fKind == 2) {
                if (stampToMatch != -1L && this.fModificationStamp != stampToMatch) {
                    status.addFatalError(Messages.format(RefactoringCoreMessages.ResourceChange_error_has_been_modified, BasicElementLabels.getPathLabel(this.fResource.getFullPath(), false)));
                }
            } else if (stampToMatch != -1L && this.fModificationStamp != stampToMatch) {
                status.addFatalError(Messages.format(RefactoringCoreMessages.ResourceChange_error_has_been_modified, BasicElementLabels.getPathLabel(this.fResource.getFullPath(), false)));
            }
        }

        private void initializeFile(IFile file) {
            this.fTextFileBuffer = ResourceChange.getBuffer(file);
            if (this.fTextFileBuffer == null) {
                this.initializeResource((IResource)file);
            } else {
                IDocument document = this.fTextFileBuffer.getDocument();
                this.fDirty = this.fTextFileBuffer.isDirty();
                this.fReadOnly = Resources.isReadOnly((IResource)file);
                if (document instanceof IDocumentExtension4) {
                    this.fKind = 2;
                    this.fModificationStamp = ((IDocumentExtension4)document).getModificationStamp();
                } else {
                    this.fKind = 1;
                    this.fModificationStamp = file.getModificationStamp();
                }
            }
        }

        private void initializeResource(IResource resource) {
            this.fKind = 1;
            this.fDirty = false;
            this.fReadOnly = Resources.isReadOnly(resource);
            this.fModificationStamp = resource.getModificationStamp();
        }
    }
}

