/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.target.editor;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.feature.FeatureData;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractFeatureSpecPage
extends WizardPage {
    protected Text fFeatureNameText;
    protected Text fFeatureVersionText;
    protected Text fLibraryText;
    protected String fInitialId;
    protected String fInitialName;

    public AbstractFeatureSpecPage() {
        super("specPage");
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.setControl((Control)comp);
        this.createContents(comp);
        this.initialize();
        this.attachListeners();
        Dialog.applyDialogFont((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, this.getHelpId());
        this.setPageComplete(this.validatePage());
    }

    protected abstract void createContents(Composite var1);

    protected abstract void initialize();

    protected abstract void attachListeners(ModifyListener var1);

    protected abstract String getHelpId();

    protected abstract void saveSettings(IDialogSettings var1);

    protected void createCommonInput(Composite common) {
        Label label = new Label(common, 0);
        label.setText(PDEUIMessages.NewFeatureWizard_SpecPage_name);
        this.fFeatureNameText = new Text(common, 2048);
        this.fFeatureNameText.setLayoutData((Object)new GridData(768));
        label = new Label(common, 0);
        label.setText(PDEUIMessages.NewFeatureWizard_SpecPage_version);
        this.fFeatureVersionText = new Text(common, 2048);
        this.fFeatureVersionText.setLayoutData((Object)new GridData(768));
    }

    protected void createInstallHandlerText(Composite parent) {
        Label libraryLabel = new Label(parent, 0);
        libraryLabel.setText(PDEUIMessages.NewFeatureWizard_SpecPage_library);
        this.fLibraryText = new Text(parent, 2052);
        this.fLibraryText.setLayoutData((Object)new GridData(768));
    }

    protected boolean validatePage() {
        if (!this.setValidationMessage(this.verifyIdRules())) {
            return false;
        }
        if (!this.setValidationMessage(this.verifyVersion())) {
            return false;
        }
        if (!this.setValidationMessage(this.validateContent())) {
            return false;
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
        return true;
    }

    private boolean setValidationMessage(String message) {
        if (message == null) {
            return true;
        }
        this.setPageComplete(false);
        this.setErrorMessage(message);
        return false;
    }

    protected abstract String validateContent();

    public String getInitialName() {
        return this.fInitialName;
    }

    public void setInitialName(String initialName) {
        this.fInitialName = initialName;
    }

    public void setInitialId(String initialId) {
        this.fInitialId = initialId;
    }

    public String getInitialId() {
        return this.fInitialId;
    }

    protected String verifyVersion() {
        String value = this.fFeatureVersionText.getText();
        if (VersionUtil.validateVersion((String)value).getSeverity() != 0) {
            return PDEUIMessages.NewFeatureWizard_SpecPage_versionFormat;
        }
        return null;
    }

    protected abstract String getFeatureId();

    protected String verifyIdRules() {
        String id = this.getFeatureId();
        if (id == null || id.length() == 0) {
            return PDEUIMessages.NewFeatureWizard_SpecPage_missing;
        }
        if (!IdUtil.isValidCompositeID((String)id)) {
            return PDEUIMessages.NewFeatureWizard_SpecPage_invalidId;
        }
        return null;
    }

    protected String getInstallHandlerLibrary() {
        Object library = this.fLibraryText.getText();
        if (library == null || ((String)library).length() == 0) {
            return null;
        }
        if (!(((String)library).endsWith(".jar") || ((String)library).endsWith("/") || ((String)library).equals("."))) {
            library = (String)library + "/";
        }
        return library;
    }

    private void attachListeners() {
        ModifyListener listener = e -> this.setPageComplete(this.validatePage());
        this.attachListeners(listener);
        this.fFeatureNameText.addModifyListener(listener);
        this.fFeatureVersionText.addModifyListener(listener);
        this.fLibraryText.addModifyListener(listener);
    }

    public abstract FeatureData getFeatureData();
}

