/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.ui.internal.propertypage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.common.componentcore.ui.ModuleCoreUIPlugin;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.IVirtualComponentLabelProvider;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.WizardFragment;
import org.eclipse.wst.common.componentcore.ui.propertypage.IDependencyPageProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;

public class DependencyPageExtensionManager {
    private static final String DEFAULT_WEIGHT = "100";
    private static DependencyPageExtensionManager manager = null;
    private HashMap<String, IDependencyPageProvider> providers = null;
    private HashMap<String, String> providerWeight;

    public static DependencyPageExtensionManager getManager() {
        if (manager == null) {
            manager = new DependencyPageExtensionManager();
        }
        return manager;
    }

    public IDependencyPageProvider getProvider(IFacetedProject project) {
        if (this.providers == null) {
            this.loadProviders();
        }
        IDependencyPageProvider foundProvider = null;
        int highestWeight = 0;
        for (String id : this.providers.keySet()) {
            IDependencyPageProvider temp = this.providers.get(id);
            if (!temp.canHandle(project)) continue;
            int weight = Integer.valueOf(this.providerWeight.get(id));
            if (foundProvider == null) {
                foundProvider = temp;
                highestWeight = weight;
                continue;
            }
            if (highestWeight >= weight) continue;
            foundProvider = temp;
            highestWeight = weight;
        }
        return foundProvider;
    }

    private void loadProviders() {
        HashMap<String, IDependencyPageProvider> temp = new HashMap<String, IDependencyPageProvider>();
        HashMap<String, String> tempProviderWeight = new HashMap<String, String>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.common.modulecore.ui", "moduleDependencyPropertyPage");
        int i = 0;
        while (i < cf.length) {
            try {
                temp.put(cf[i].getAttribute("id"), (IDependencyPageProvider)cf[i].createExecutableExtension("class"));
                String weight = cf[i].getAttribute("weight");
                tempProviderWeight.put(cf[i].getAttribute("id"), weight == null ? DEFAULT_WEIGHT : weight);
            }
            catch (CoreException ce) {
                ModuleCoreUIPlugin.log((Exception)((Object)ce));
            }
            ++i;
        }
        this.providers = temp;
        this.providerWeight = tempProviderWeight;
    }

    public WizardFragment[] loadAllReferenceWizardFragments() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.common.modulecore.ui", "referenceWizardFragment");
        ArrayList<WizardFragment> list = new ArrayList<WizardFragment>();
        int i = 0;
        while (i < cf.length) {
            try {
                list.add((WizardFragment)cf[i].createExecutableExtension("class"));
            }
            catch (CoreException ce) {
                ModuleCoreUIPlugin.log((Exception)((Object)ce));
            }
            ++i;
        }
        return list.toArray(new WizardFragment[list.size()]);
    }

    public WizardFragment loadReferenceWizardFragment(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.common.modulecore.ui", "referenceWizardFragment");
        int i = 0;
        while (i < cf.length) {
            if (cf[i].getAttribute("id").equals(id)) {
                try {
                    return (WizardFragment)cf[i].createExecutableExtension("class");
                }
                catch (CoreException ce) {
                    ModuleCoreUIPlugin.log((Exception)((Object)ce));
                }
            }
            ++i;
        }
        return null;
    }

    public List<ReferenceExtension> getExposedReferenceExtensions() {
        ArrayList<ReferenceExtension> list = new ArrayList<ReferenceExtension>();
        HashSet<String> hidden = new HashSet<String>();
        for (ReferenceExtension ext : this.getAllReferenceExtensions()) {
            if (!ext.isHidden()) continue;
            hidden.add(ext.getId());
        }
        for (ReferenceExtension ext : this.getAllReferenceExtensions()) {
            if (ext.isHidden() || hidden.contains(ext.getId())) continue;
            list.add(ext);
        }
        return list;
    }

    public List<ReferenceExtension> getAllReferenceExtensions() {
        ArrayList<ReferenceExtension> list = new ArrayList<ReferenceExtension>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor("org.eclipse.wst.common.modulecore.ui", "referenceWizardFragment");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cf = iConfigurationElementArray[n2];
            list.add(new ReferenceExtension(cf));
            ++n2;
        }
        return list;
    }

    public ReferenceExtension findReferenceExtension(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.common.modulecore.ui", "referenceWizardFragment");
        new ArrayList();
        int i = 0;
        while (i < cf.length) {
            if (cf[i].getAttribute("id").equals(id)) {
                return new ReferenceExtension(cf[i]);
            }
            ++i;
        }
        return null;
    }

    public static IVirtualComponentLabelProvider[] loadDelegates() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.common.modulecore.ui", "virtualComponentLabelProvider");
        List<IConfigurationElement> list = Arrays.asList(cf);
        Comparator<IConfigurationElement> c = new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                int o2int;
                int o1int;
                String o1String = o1.getAttribute("weight");
                String o2String = o2.getAttribute("weight");
                try {
                    o1int = Integer.parseInt(o1String);
                }
                catch (NumberFormatException numberFormatException) {
                    o1int = 0;
                }
                try {
                    o2int = Integer.parseInt(o2String);
                }
                catch (NumberFormatException numberFormatException) {
                    o2int = 0;
                }
                return o1int - o2int;
            }
        };
        Collections.sort(list, c);
        ArrayList<IVirtualComponentLabelProvider> retList = new ArrayList<IVirtualComponentLabelProvider>();
        Iterator<IConfigurationElement> i = list.iterator();
        while (i.hasNext()) {
            try {
                IConfigurationElement el = i.next();
                el.getAttribute("class");
                retList.add((IVirtualComponentLabelProvider)el.createExecutableExtension("class"));
            }
            catch (CoreException ce) {
                ModuleCoreUIPlugin.log((Exception)((Object)ce));
            }
        }
        return retList.toArray(new IVirtualComponentLabelProvider[retList.size()]);
    }

    public class ReferenceExtension {
        private IConfigurationElement element;
        private String id;
        private String name;
        private String imageLoc;
        private Image image;
        private boolean hidden;
        private Expression enablementExpression;

        public ReferenceExtension(IConfigurationElement element) {
            this.element = element;
            this.id = element.getAttribute("id");
            this.name = element.getAttribute("name");
            this.imageLoc = element.getAttribute("icon");
            this.hidden = Boolean.parseBoolean(element.getAttribute("hidden"));
            IConfigurationElement[] iConfigurationElementArray = element.getChildren("enablement");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray[n2];
                try {
                    this.enablementExpression = ExpressionConverter.getDefault().perform(child);
                }
                catch (CoreException e) {
                    ModuleCoreUIPlugin.log((Exception)((Object)e));
                }
                ++n2;
            }
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public boolean isApplicable(IProject project) {
            if (this.enablementExpression != null) {
                EvaluationContext evalContext = new EvaluationContext(null, (Object)project);
                evalContext.setAllowPluginActivation(true);
                try {
                    EvaluationResult evalResult = this.enablementExpression.evaluate((IEvaluationContext)evalContext);
                    if (evalResult == EvaluationResult.FALSE) {
                        return false;
                    }
                }
                catch (CoreException e) {
                    ModuleCoreUIPlugin.log((Exception)((Object)e));
                }
            }
            return true;
        }

        public Image getImage() {
            if (this.image == null && this.imageLoc != null && this.element.getContributor().getName() != null) {
                ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.element.getContributor().getName(), (String)this.imageLoc);
                this.image = desc.createImage();
            }
            return this.image;
        }

        public void disposeImage() {
            if (this.image != null) {
                this.image.dispose();
                this.image = null;
            }
        }
    }
}

