/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposalCore;

public class CorrectMainTypeNameProposalCore
extends ASTRewriteCorrectionProposalCore {
    private final String fOldName;
    private final String fNewName;
    private final IInvocationContext fContext;

    public CorrectMainTypeNameProposalCore(String name, ICompilationUnit cu, ASTRewrite rewrite, IInvocationContext context, String oldTypeName, String newTypeName, int relevance) {
        super(name, cu, rewrite, relevance);
        this.fContext = context;
        this.fOldName = oldTypeName;
        this.fNewName = newTypeName;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit astRoot = this.fContext.getASTRoot();
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        AbstractTypeDeclaration decl = this.findTypeDeclaration(astRoot.types(), this.fOldName);
        if (decl != null) {
            SimpleName[] simpleNameArray = LinkedNodeFinder.findByNode((ASTNode)astRoot, decl.getName());
            int n = simpleNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                SimpleName sameNode = simpleNameArray[n2];
                rewrite.replace((ASTNode)sameNode, (ASTNode)ast.newSimpleName(this.fNewName), null);
                ++n2;
            }
        }
        return rewrite;
    }

    private AbstractTypeDeclaration findTypeDeclaration(List<AbstractTypeDeclaration> types, String name) {
        for (AbstractTypeDeclaration decl : types) {
            if (!name.equals(decl.getName().getIdentifier())) continue;
            return decl;
        }
        return null;
    }
}

