/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.preference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.extensions.IEditorDescriptor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.extensions.IEditorPageDescriptor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.SOEUIPlugin;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.preference.EditorComparator;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.preference.Messages;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.SchemaObjectEditorUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SchemaObjectEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    IPreferenceStore _store = SOEUIPlugin.getDefault().getPreferenceStore();
    Composite _parent;
    Combo _dbType;
    Combo _editorName;
    org.eclipse.swt.widgets.List _displayedPages;
    org.eclipse.swt.widgets.List _hiddenPages;
    Button _rightOne;
    Button _rightAll;
    Button _leftOne;
    Button _leftAll;
    Button _upMove;
    Button _downMove;
    Button _alwaysShowPreview;
    Button _promptIfNoExactEditorFound;
    Button _checkWhenActivated;
    Button _openFileAfterSaveas;
    boolean _dirty;
    static final int BUTTON_WIDTH = 120;

    public SchemaObjectEditorPreferencePage() {
    }

    public SchemaObjectEditorPreferencePage(String title) {
        super(title);
    }

    public SchemaObjectEditorPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        int index;
        this._parent = parent;
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        Composite container = new Composite(parent, 0);
        layout = new GridLayout();
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        Group editorsComp = new Group(container, 0);
        gd = new GridData(768);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.makeColumnsEqualWidth = true;
        editorsComp.setLayout((Layout)layout);
        editorsComp.setText(Messages.SchemaObjectEditorPreferencePage_available_editors);
        editorsComp.setLayoutData((Object)gd);
        Composite dbdefsComp = new Composite((Composite)editorsComp, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        dbdefsComp.setLayout((Layout)layout);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        dbdefsComp.setLayoutData((Object)gd);
        Label dbTypeLabel = new Label(dbdefsComp, 0);
        dbTypeLabel.setText(Messages.SchemaObjectEditorPreferencePage_databaseType);
        this._dbType = new Combo(dbdefsComp, 8);
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this._dbType.setLayoutData((Object)gd);
        Composite edComp = new Composite((Composite)editorsComp, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        edComp.setLayout((Layout)layout);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        edComp.setLayoutData((Object)gd);
        Label editorTypeLabel = new Label(edComp, 0);
        editorTypeLabel.setText(Messages.SchemaObjectEditorPreferencePage_editors);
        this._editorName = new Combo(edComp, 8);
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this._editorName.setLayoutData((Object)gd);
        Group pagesComp = new Group(container, 0);
        gd = new GridData(1808);
        layout = new GridLayout();
        layout.numColumns = 3;
        pagesComp.setLayout((Layout)layout);
        pagesComp.setLayoutData((Object)gd);
        pagesComp.setText(Messages.SchemaObjectEditorPreferencePage_pagesSetting);
        Composite selectedComposite = new Composite((Composite)pagesComp, 0);
        gd = new GridData(1808);
        selectedComposite.setLayoutData((Object)gd);
        layout = new GridLayout();
        selectedComposite.setLayout((Layout)layout);
        Label selectedPages = new Label(selectedComposite, 0);
        selectedPages.setText(Messages.SchemaObjectEditorPreferencePage_selected_pages);
        gd = new GridData();
        gd.horizontalAlignment = 32;
        selectedPages.setLayoutData((Object)gd);
        this._displayedPages = new org.eclipse.swt.widgets.List(selectedComposite, 2050);
        gd = new GridData(1808);
        this._displayedPages.setLayoutData((Object)gd);
        Composite buttonsComp = new Composite((Composite)pagesComp, 0);
        gd = new GridData(1040);
        buttonsComp.setLayoutData((Object)gd);
        layout = new GridLayout();
        buttonsComp.setLayout((Layout)layout);
        GC gc = new GC((Drawable)buttonsComp);
        int maxAddRemoveButtonsWidth = this.computeMaxAddRemoveButtonsWidth(gc);
        gc.dispose();
        new Label(buttonsComp, 0);
        this._rightOne = new Button(buttonsComp, 16384);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.widthHint = maxAddRemoveButtonsWidth;
        this._rightOne.setLayoutData((Object)gd);
        this._rightOne.setText(Messages.SchemaObjectEditorPreferencePage_remove);
        this._rightOne.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String[] selectedItems = SchemaObjectEditorPreferencePage.this._displayedPages.getSelection();
                boolean isSucceeded = false;
                int movedNum = 0;
                int i = 0;
                while (i < selectedItems.length) {
                    String name = selectedItems[i];
                    Object data = SchemaObjectEditorPreferencePage.this._displayedPages.getData(name);
                    IEditorPageDescriptor page = (IEditorPageDescriptor)data;
                    if (!page.isRequired()) {
                        SchemaObjectEditorPreferencePage.this._hiddenPages.add(name);
                        SchemaObjectEditorPreferencePage.this._hiddenPages.setData(name, data);
                        SchemaObjectEditorPreferencePage.this._displayedPages.remove(name);
                        isSucceeded = true;
                        ++movedNum;
                    }
                    ++i;
                }
                SchemaObjectEditorPreferencePage.this.setOrClearErrorMsg();
                if (!isSucceeded) {
                    String[] buttons = new String[]{IDialogConstants.OK_LABEL};
                    MessageDialog d = new MessageDialog(SchemaObjectEditorPreferencePage.this._parent.getShell(), Messages.SchemaObjectEditorPreferencePage_error, null, Messages.SchemaObjectEditorPreferencePage_can_not_remove, 1, buttons, 0);
                    d.open();
                } else {
                    SchemaObjectEditorPreferencePage.this._dirty = true;
                    int[] indecies = new int[movedNum];
                    int i2 = 0;
                    while (i2 < movedNum) {
                        indecies[i2] = SchemaObjectEditorPreferencePage.this._hiddenPages.getItemCount() - 1 - i2;
                        ++i2;
                    }
                    SchemaObjectEditorPreferencePage.this._hiddenPages.setSelection(indecies);
                }
                SchemaObjectEditorPreferencePage.this.setButtonStatus();
            }
        });
        this._rightAll = new Button(buttonsComp, 16384);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.widthHint = maxAddRemoveButtonsWidth;
        this._rightAll.setLayoutData((Object)gd);
        this._rightAll.setText(Messages.SchemaObjectEditorPreferencePage_remove_all);
        this._rightAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String[] selectedItems = SchemaObjectEditorPreferencePage.this._displayedPages.getItems();
                boolean isSucceeded = false;
                int i = 0;
                while (i < selectedItems.length) {
                    String name = selectedItems[i];
                    Object data = SchemaObjectEditorPreferencePage.this._displayedPages.getData(name);
                    IEditorPageDescriptor page = (IEditorPageDescriptor)data;
                    if (!page.isRequired()) {
                        SchemaObjectEditorPreferencePage.this._hiddenPages.add(name);
                        SchemaObjectEditorPreferencePage.this._hiddenPages.setData(name, data);
                        SchemaObjectEditorPreferencePage.this._displayedPages.remove(name);
                        isSucceeded = true;
                    }
                    ++i;
                }
                SchemaObjectEditorPreferencePage.this.setOrClearErrorMsg();
                SchemaObjectEditorPreferencePage.this.setButtonStatus();
                if (!isSucceeded) {
                    String[] buttons = new String[]{IDialogConstants.OK_LABEL};
                    MessageDialog d = new MessageDialog(SchemaObjectEditorPreferencePage.this._parent.getShell(), Messages.SchemaObjectEditorPreferencePage_erroe, null, Messages.SchemaObjectEditorPreferencePage_can_not_remove, 1, buttons, 0);
                    d.open();
                } else {
                    SchemaObjectEditorPreferencePage.this._dirty = true;
                }
            }
        });
        this._leftOne = new Button(buttonsComp, 16384);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.widthHint = maxAddRemoveButtonsWidth;
        this._leftOne.setLayoutData((Object)gd);
        this._leftOne.setText(Messages.SchemaObjectEditorPreferencePage_add);
        this._leftOne.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String[] selectedItems = SchemaObjectEditorPreferencePage.this._hiddenPages.getSelection();
                int movedNum = 0;
                int i = 0;
                while (i < selectedItems.length) {
                    boolean isPageMandatoryLastOne;
                    String name = selectedItems[i];
                    Object data = SchemaObjectEditorPreferencePage.this._hiddenPages.getData(name);
                    IEditorDescriptor editor = (IEditorDescriptor)SchemaObjectEditorPreferencePage.this._editorName.getData(SchemaObjectEditorPreferencePage.this._editorName.getText());
                    IEditorPageDescriptor page = (IEditorPageDescriptor)data;
                    boolean isPageMandatoryFirstOne = editor.getMandatoryFirstPage() != null && editor.getMandatoryFirstPage().getPageId().equals(page.getPageId());
                    boolean bl = isPageMandatoryLastOne = editor.getMandatoryLastPage() != null && editor.getMandatoryLastPage().getPageId().equals(page.getPageId());
                    if (isPageMandatoryFirstOne) {
                        SchemaObjectEditorPreferencePage.this._displayedPages.add(name, 0);
                        SchemaObjectEditorPreferencePage.this._displayedPages.setData(name, data);
                    } else if (isPageMandatoryLastOne) {
                        SchemaObjectEditorPreferencePage.this._displayedPages.add(name, SchemaObjectEditorPreferencePage.this._displayedPages.getItemCount());
                        SchemaObjectEditorPreferencePage.this._displayedPages.setData(name, data);
                    } else if (SchemaObjectEditorPreferencePage.this._displayedPages.getItemCount() > 0) {
                        boolean isLastPageMandatory;
                        String displayedLastOne = SchemaObjectEditorPreferencePage.this._displayedPages.getItem(SchemaObjectEditorPreferencePage.this._displayedPages.getItemCount() - 1);
                        IEditorPageDescriptor displayedLast = (IEditorPageDescriptor)SchemaObjectEditorPreferencePage.this._displayedPages.getData(displayedLastOne);
                        boolean bl2 = isLastPageMandatory = editor.getMandatoryLastPage() != null && editor.getMandatoryLastPage().getPageId().equals(displayedLast.getPageId());
                        if (isLastPageMandatory) {
                            SchemaObjectEditorPreferencePage.this._displayedPages.add(name, SchemaObjectEditorPreferencePage.this._displayedPages.getItemCount() - 1);
                            SchemaObjectEditorPreferencePage.this._displayedPages.setData(name, data);
                        } else {
                            SchemaObjectEditorPreferencePage.this._displayedPages.add(name);
                            SchemaObjectEditorPreferencePage.this._displayedPages.setData(name, data);
                        }
                    } else {
                        SchemaObjectEditorPreferencePage.this._displayedPages.add(name);
                        SchemaObjectEditorPreferencePage.this._displayedPages.setData(name, data);
                    }
                    SchemaObjectEditorPreferencePage.this._hiddenPages.remove(name);
                    ++movedNum;
                    ++i;
                }
                SchemaObjectEditorPreferencePage.this.setOrClearErrorMsg();
                if (movedNum > 0) {
                    SchemaObjectEditorPreferencePage.this._dirty = true;
                }
                int[] indecies = new int[movedNum];
                int i2 = 0;
                while (i2 < movedNum) {
                    indecies[i2] = SchemaObjectEditorPreferencePage.this._displayedPages.getItemCount() - 1 - i2;
                    ++i2;
                }
                SchemaObjectEditorPreferencePage.this._displayedPages.setSelection(indecies);
                SchemaObjectEditorPreferencePage.this.setButtonStatus();
            }
        });
        this._leftAll = new Button(buttonsComp, 16384);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.widthHint = maxAddRemoveButtonsWidth;
        this._leftAll.setLayoutData((Object)gd);
        this._leftAll.setText(Messages.SchemaObjectEditorPreferencePage_add_all);
        this._leftAll.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String[] selectedItems = SchemaObjectEditorPreferencePage.this._hiddenPages.getItems();
                int i = 0;
                while (i < selectedItems.length) {
                    boolean isPageMandatoryLastOne;
                    SchemaObjectEditorPreferencePage.this._dirty = true;
                    String name = selectedItems[i];
                    Object data = SchemaObjectEditorPreferencePage.this._hiddenPages.getData(name);
                    IEditorDescriptor editor = (IEditorDescriptor)SchemaObjectEditorPreferencePage.this._editorName.getData(SchemaObjectEditorPreferencePage.this._editorName.getText());
                    IEditorPageDescriptor page = (IEditorPageDescriptor)data;
                    boolean isPageMandatoryFirstOne = editor.getMandatoryFirstPage() != null && editor.getMandatoryFirstPage().getPageId().equals(page.getPageId());
                    boolean bl = isPageMandatoryLastOne = editor.getMandatoryLastPage() != null && editor.getMandatoryLastPage().getPageId().equals(page.getPageId());
                    if (isPageMandatoryFirstOne) {
                        SchemaObjectEditorPreferencePage.this._displayedPages.add(name, 0);
                        SchemaObjectEditorPreferencePage.this._displayedPages.setData(name, data);
                    } else if (isPageMandatoryLastOne) {
                        SchemaObjectEditorPreferencePage.this._displayedPages.add(name, SchemaObjectEditorPreferencePage.this._displayedPages.getItemCount());
                        SchemaObjectEditorPreferencePage.this._displayedPages.setData(name, data);
                    } else if (SchemaObjectEditorPreferencePage.this._displayedPages.getItemCount() > 0) {
                        boolean isLastPageMandatory;
                        String displayedLastOne = SchemaObjectEditorPreferencePage.this._displayedPages.getItem(SchemaObjectEditorPreferencePage.this._displayedPages.getItemCount() - 1);
                        IEditorPageDescriptor displayedLast = (IEditorPageDescriptor)SchemaObjectEditorPreferencePage.this._displayedPages.getData(displayedLastOne);
                        boolean bl2 = isLastPageMandatory = editor.getMandatoryLastPage() != null && editor.getMandatoryLastPage().getPageId().equals(displayedLast.getPageId());
                        if (isLastPageMandatory) {
                            SchemaObjectEditorPreferencePage.this._displayedPages.add(name, SchemaObjectEditorPreferencePage.this._displayedPages.getItemCount() - 1);
                            SchemaObjectEditorPreferencePage.this._displayedPages.setData(name, data);
                        } else {
                            SchemaObjectEditorPreferencePage.this._displayedPages.add(name);
                            SchemaObjectEditorPreferencePage.this._displayedPages.setData(name, data);
                        }
                    } else {
                        SchemaObjectEditorPreferencePage.this._displayedPages.add(name);
                        SchemaObjectEditorPreferencePage.this._displayedPages.setData(name, data);
                    }
                    SchemaObjectEditorPreferencePage.this._hiddenPages.remove(name);
                    ++i;
                }
                SchemaObjectEditorPreferencePage.this.setOrClearErrorMsg();
                SchemaObjectEditorPreferencePage.this.setButtonStatus();
            }
        });
        this._upMove = new Button(buttonsComp, 16384);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.widthHint = maxAddRemoveButtonsWidth;
        this._upMove.setLayoutData((Object)gd);
        this._upMove.setText(Messages.SchemaObjectEditorPreferencePage_move_up);
        this._upMove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SchemaObjectEditorPreferencePage.this.moveItem(SchemaObjectEditorPreferencePage.this._displayedPages, true);
            }
        });
        this._downMove = new Button(buttonsComp, 16384);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.widthHint = maxAddRemoveButtonsWidth;
        this._downMove.setLayoutData((Object)gd);
        this._downMove.setText(Messages.SchemaObjectEditorPreferencePage_move_down);
        this._downMove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SchemaObjectEditorPreferencePage.this.moveItem(SchemaObjectEditorPreferencePage.this._displayedPages, false);
            }
        });
        Composite availableComp = new Composite((Composite)pagesComp, 0);
        gd = new GridData(1808);
        availableComp.setLayoutData((Object)gd);
        layout = new GridLayout();
        availableComp.setLayout((Layout)layout);
        Label availablePages = new Label(availableComp, 0);
        availablePages.setText(Messages.SchemaObjectEditorPreferencePage_available_pages);
        gd = new GridData();
        gd.horizontalAlignment = 32;
        availablePages.setLayoutData((Object)gd);
        this._hiddenPages = new org.eclipse.swt.widgets.List(availableComp, 2050);
        gd = new GridData(1808);
        this._hiddenPages.setLayoutData((Object)gd);
        final Map editorsMap = SchemaObjectEditorUtils.getEditorsCatalogedByDBDefinition();
        ArrayList<String> keys = new ArrayList<String>();
        for (String dbdefi : editorsMap.keySet()) {
            keys.add(dbdefi);
        }
        Collections.sort(keys);
        for (String dbdefi : keys) {
            this._dbType.add(dbdefi);
        }
        this._dbType.setFocus();
        this._dbType.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String dbdefi = SchemaObjectEditorPreferencePage.this._dbType.getText();
                if (dbdefi != null && dbdefi.trim().length() != 0) {
                    SchemaObjectEditorPreferencePage.this._editorName.removeAll();
                    List editors = (List)editorsMap.get(dbdefi);
                    if (editors != null) {
                        Collections.sort(editors, new EditorComparator());
                        for (IEditorDescriptor editor : editors) {
                            SchemaObjectEditorPreferencePage.this._editorName.add(editor.getEditorName());
                            SchemaObjectEditorPreferencePage.this._editorName.setData(editor.getEditorName(), (Object)editor);
                        }
                    }
                    if (SchemaObjectEditorPreferencePage.this._editorName.getItemCount() > 0) {
                        SchemaObjectEditorPreferencePage.this._editorName.select(0);
                        SchemaObjectEditorPreferencePage.this._editorName.notifyListeners(13, new Event());
                    }
                }
            }
        });
        this._editorName.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String name = SchemaObjectEditorPreferencePage.this._editorName.getText();
                if (SchemaObjectEditorPreferencePage.this._dirty && SchemaObjectEditorPreferencePage.this.isValid()) {
                    String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
                    MessageDialog d = new MessageDialog(SchemaObjectEditorPreferencePage.this._parent.getShell(), Messages.SchemaObjectEditorPreferencePage_question, null, Messages.SchemaObjectEditorPreferencePage_save_modification, 3, buttons, 0);
                    int result = d.open();
                    switch (result) {
                        case 0: {
                            SchemaObjectEditorPreferencePage.this.savePreferences();
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                }
                SchemaObjectEditorPreferencePage.this._dirty = false;
                if (name != null && name.trim().length() != 0) {
                    SchemaObjectEditorPreferencePage.this._displayedPages.removeAll();
                    SchemaObjectEditorPreferencePage.this._hiddenPages.removeAll();
                    IEditorDescriptor editor = (IEditorDescriptor)SchemaObjectEditorPreferencePage.this._editorName.getData(name);
                    if (editor != null) {
                        IEditorPageDescriptor[] pages = editor.getPageDescriptors();
                        int i = 0;
                        while (i < pages.length) {
                            if (!SchemaObjectEditorPreferencePage.this._store.getBoolean("SchemaObjectEditor.visiability" + pages[i].getEditorId() + pages[i].getPageId())) {
                                SchemaObjectEditorPreferencePage.this._hiddenPages.add(pages[i].getPageName());
                                SchemaObjectEditorPreferencePage.this._hiddenPages.setData(pages[i].getPageName(), (Object)pages[i]);
                            }
                            ++i;
                        }
                        IEditorPageDescriptor[] sortedPages = editor.getSortedPages();
                        int j = 0;
                        while (j < sortedPages.length) {
                            if (sortedPages[j].isSelectedToShow()) {
                                SchemaObjectEditorPreferencePage.this._displayedPages.add(sortedPages[j].getPageName());
                                SchemaObjectEditorPreferencePage.this._displayedPages.setData(sortedPages[j].getPageName(), (Object)sortedPages[j]);
                            }
                            ++j;
                        }
                    }
                    SchemaObjectEditorPreferencePage.this.setOrClearErrorMsg();
                    SchemaObjectEditorPreferencePage.this.setButtonStatus();
                }
            }
        });
        String preDBdef = this._store.getString("SchemaObjectEditorPreferencePage.previous.configured.dbdefinition");
        String preEditor = this._store.getString("SchemaObjectEditorPreferencePage.previous.configured.editor");
        if (preDBdef != null && (index = this._dbType.indexOf(preDBdef)) != -1) {
            this._dbType.select(index);
            this._dbType.notifyListeners(13, new Event());
        }
        if (preEditor != null && (index = this._editorName.indexOf(preEditor)) != -1) {
            this._editorName.select(index);
            this._editorName.notifyListeners(13, new Event());
        }
        this._displayedPages.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SchemaObjectEditorPreferencePage.this.setButtonStatus();
            }
        });
        this._hiddenPages.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SchemaObjectEditorPreferencePage.this.setButtonStatus();
            }
        });
        this.setButtonStatus();
        this._alwaysShowPreview = new Button(container, 32);
        this._alwaysShowPreview.setText(Messages.SchemaObjectEditorPreferencePage_always_show_preview);
        this._alwaysShowPreview.setSelection(this._store.getBoolean("SchemaObjectEditorPreferencePage.show.preview.dialog"));
        this._promptIfNoExactEditorFound = new Button(container, 32);
        this._promptIfNoExactEditorFound.setText(Messages.SchemaObjectEditorPreferencePage_use_latest_version_to_open);
        this._promptIfNoExactEditorFound.setToolTipText(Messages.SchemaObjectEditorPreferencePage_latest_version_open_tooltip);
        this._promptIfNoExactEditorFound.setSelection(this._store.getBoolean("SchemaObjectEditorPreferencePage.use.latest.version"));
        this._checkWhenActivated = new Button(container, 32);
        this._checkWhenActivated.setText(Messages.SchemaObjectEditorPreferencePage_check_existence_when_activated);
        this._checkWhenActivated.setSelection(this._store.getBoolean("SchemaObjectEditorPreferencePage.check.existence"));
        this._checkWhenActivated.setToolTipText(Messages.SchemaObjectEditorPreferencePage_check_existence_when_activated_tooltip);
        this._openFileAfterSaveas = new Button(container, 32);
        this._openFileAfterSaveas.setText(Messages.SchemaObjectEditorPreferencePage_open_file_after_saveas);
        this._openFileAfterSaveas.setSelection(this._store.getBoolean("SchemaObjectEditorPreferencePage.open.file.after.saveas"));
        this._openFileAfterSaveas.setToolTipText(Messages.SchemaObjectEditorPreferencePage_open_file_after_saveas_tooltip);
        return container;
    }

    private void setButtonStatus() {
        if (this._displayedPages.getSelectionCount() > 0) {
            this._rightOne.setEnabled(true);
            if (this._displayedPages.getSelectionCount() == 1 && this._displayedPages.getSelectionIndex() != 0) {
                this._upMove.setEnabled(true);
            } else {
                this._upMove.setEnabled(false);
            }
            if (this._displayedPages.getSelectionCount() == 1 && this._displayedPages.getSelectionIndex() != this._displayedPages.getItemCount() - 1) {
                this._downMove.setEnabled(true);
            } else {
                this._downMove.setEnabled(false);
            }
        } else {
            this._rightOne.setEnabled(false);
            this._upMove.setEnabled(false);
            this._downMove.setEnabled(false);
        }
        if (this._displayedPages.getItemCount() > 0) {
            this._rightAll.setEnabled(true);
        } else {
            this._rightAll.setEnabled(false);
        }
        if (this._hiddenPages.getSelectionCount() > 0) {
            this._leftOne.setEnabled(true);
        } else {
            this._leftOne.setEnabled(false);
        }
        if (this._hiddenPages.getItemCount() > 0) {
            this._leftAll.setEnabled(true);
        } else {
            this._leftAll.setEnabled(false);
        }
    }

    public void init(IWorkbench workbench) {
    }

    private void setOrClearErrorMsg() {
        if (this._displayedPages.getItemCount() == 0) {
            this.setMessage(Messages.SchemaObjectEditorPreferencePage_no_page, 3);
            this.setValid(false);
            this.updateApplyButton();
        } else {
            this.setMessage(null);
            this.setValid(true);
            this.updateApplyButton();
        }
    }

    protected void performApply() {
        this.savePreferences();
        super.performApply();
    }

    protected void performDefaults() {
        boolean alwaysShowPreview = this._store.getDefaultBoolean("SchemaObjectEditorPreferencePage.show.preview.dialog");
        this._alwaysShowPreview.setSelection(alwaysShowPreview);
        boolean promptIfNoExactEditorFound = this._store.getDefaultBoolean("SchemaObjectEditorPreferencePage.use.latest.version");
        this._promptIfNoExactEditorFound.setSelection(promptIfNoExactEditorFound);
        boolean checkWhenActivated = this._store.getDefaultBoolean("SchemaObjectEditorPreferencePage.check.existence");
        this._checkWhenActivated.setSelection(checkWhenActivated);
        boolean openFileAfterSaveas = this._store.getDefaultBoolean("SchemaObjectEditorPreferencePage.open.file.after.saveas");
        this._openFileAfterSaveas.setSelection(openFileAfterSaveas);
        this.loadDefault();
        super.performDefaults();
    }

    public boolean performOk() {
        this.savePreferences();
        this.savePreConfiguredItem();
        return super.performOk();
    }

    private void loadDefault() {
        Object obj;
        String editorName;
        String dbdef = this._dbType.getText();
        if (dbdef != null && dbdef.trim().length() != 0 && (editorName = this._editorName.getText()) != null && editorName.trim().length() != 0 && (obj = this._editorName.getData(editorName)) != null) {
            IEditorDescriptor editor = (IEditorDescriptor)obj;
            this._displayedPages.removeAll();
            this._hiddenPages.removeAll();
            IEditorPageDescriptor[] pages = editor.getDefaultSortedPages();
            int i = 0;
            while (i < pages.length) {
                if (pages[i].isRequired() || pages[i].isVisibleByDefault()) {
                    this._displayedPages.add(pages[i].getPageName());
                    this._displayedPages.setData(pages[i].getPageName(), (Object)pages[i]);
                } else {
                    this._hiddenPages.add(pages[i].getPageName());
                    this._hiddenPages.setData(pages[i].getPageName(), (Object)pages[i]);
                }
                ++i;
            }
        }
        this.setOrClearErrorMsg();
        this.setButtonStatus();
        this._dirty = false;
    }

    private void savePreferences() {
        boolean alwaysShowPreview = this._alwaysShowPreview.getSelection();
        boolean promptIfNoExactEditorFound = this._promptIfNoExactEditorFound.getSelection();
        boolean checkWhenActivated = this._checkWhenActivated.getSelection();
        boolean openFileAfterSaveas = this._openFileAfterSaveas.getSelection();
        this._store.setValue("SchemaObjectEditorPreferencePage.show.preview.dialog", alwaysShowPreview);
        this._store.setValue("SchemaObjectEditorPreferencePage.use.latest.version", promptIfNoExactEditorFound);
        this._store.setValue("SchemaObjectEditorPreferencePage.check.existence", checkWhenActivated);
        this._store.setValue("SchemaObjectEditorPreferencePage.open.file.after.saveas", openFileAfterSaveas);
        String[] displayItems = this._displayedPages.getItems();
        int num = 1;
        int i = 0;
        while (i < displayItems.length) {
            String item = displayItems[i];
            IEditorPageDescriptor page = (IEditorPageDescriptor)this._displayedPages.getData(item);
            if (page != null) {
                this._store.setValue("SchemaObjectEditor.visiability" + page.getEditorId() + page.getPageId(), true);
                this._store.setValue("SchemaObjectEditor.pageOrder" + page.getEditorId() + page.getPageId(), num++);
            }
            ++i;
        }
        String[] hiddenItems = this._hiddenPages.getItems();
        int i2 = 0;
        while (i2 < hiddenItems.length) {
            String item = hiddenItems[i2];
            IEditorPageDescriptor page = (IEditorPageDescriptor)this._hiddenPages.getData(item);
            if (page != null) {
                this._store.setValue("SchemaObjectEditor.visiability" + page.getEditorId() + page.getPageId(), false);
            }
            ++i2;
        }
        this._dirty = false;
    }

    private void moveItem(org.eclipse.swt.widgets.List list, boolean upDirection) {
        if (!(list.getItemCount() == 0 || list.getSelectionCount() == 0 || list.getSelectionCount() > 1 || list.getSelectionIndex() == 0 && upDirection || list.getSelectionIndex() == list.getItemCount() - 1 && !upDirection)) {
            boolean isLastPageMandatory;
            int selectionIndex = list.getSelectionIndex();
            String selectionItem = list.getItem(selectionIndex);
            IEditorDescriptor editor = (IEditorDescriptor)this._editorName.getData(this._editorName.getText());
            String firstItem = list.getItem(0);
            String lastItem = list.getItem(list.getItemCount() - 1);
            IEditorPageDescriptor firstPage = (IEditorPageDescriptor)this._displayedPages.getData(firstItem);
            IEditorPageDescriptor lastPage = (IEditorPageDescriptor)this._displayedPages.getData(lastItem);
            boolean isFirstPageMandatory = editor.getMandatoryFirstPage() != null && editor.getMandatoryFirstPage().getPageId().equals(firstPage.getPageId());
            boolean bl = isLastPageMandatory = editor.getMandatoryLastPage() != null && editor.getMandatoryLastPage().getPageId().equals(lastPage.getPageId());
            if (!upDirection && selectionIndex == 0 && isFirstPageMandatory) {
                String[] buttons = new String[]{IDialogConstants.OK_LABEL};
                MessageDialog d = new MessageDialog(this._parent.getShell(), "Error", null, Messages.SchemaObjectEditorPreferencePage_must_be_first, 1, buttons, 0);
                d.open();
                return;
            }
            if (upDirection && selectionIndex == list.getItemCount() - 1 && isLastPageMandatory) {
                String[] buttons = new String[]{IDialogConstants.OK_LABEL};
                MessageDialog d = new MessageDialog(this._parent.getShell(), "Error", null, Messages.SchemaObjectEditorPreferencePage_must_be_last, 1, buttons, 0);
                d.open();
                return;
            }
            if (upDirection && selectionIndex == 1 && isFirstPageMandatory) {
                String[] buttons = new String[]{IDialogConstants.OK_LABEL};
                MessageDialog d = new MessageDialog(this._parent.getShell(), "Error", null, Messages.SchemaObjectEditorPreferencePage_can_not_up, 1, buttons, 0);
                d.open();
                return;
            }
            if (!upDirection && selectionIndex == list.getItemCount() - 2 && isLastPageMandatory) {
                String[] buttons = new String[]{IDialogConstants.OK_LABEL};
                MessageDialog d = new MessageDialog(this._parent.getShell(), "Error", null, Messages.SchemaObjectEditorPreferencePage_can_not_down, 1, buttons, 0);
                d.open();
                return;
            }
            this._dirty = true;
            if (upDirection) {
                list.add(selectionItem, selectionIndex - 1);
                list.remove(selectionIndex + 1);
                list.select(selectionIndex - 1);
            } else {
                list.add(selectionItem, selectionIndex + 2);
                list.remove(selectionIndex);
                list.select(selectionIndex + 1);
            }
            this.setButtonStatus();
        }
    }

    public boolean performCancel() {
        this.savePreConfiguredItem();
        return super.performCancel();
    }

    private void savePreConfiguredItem() {
        String dbdef = this._dbType.getText();
        String editor = this._editorName.getText();
        if (dbdef != null && dbdef.trim().length() != 0) {
            this._store.setValue("SchemaObjectEditorPreferencePage.previous.configured.dbdefinition", dbdef);
        }
        if (editor != null && editor.trim().length() != 0) {
            this._store.setValue("SchemaObjectEditorPreferencePage.previous.configured.editor", editor);
        }
    }

    private int computeMaxAddRemoveButtonsWidth(GC gc) {
        int maxWidth = 0;
        maxWidth = this.getGreaterWidth(gc, Messages.SchemaObjectEditorPreferencePage_add, maxWidth);
        maxWidth = this.getGreaterWidth(gc, Messages.SchemaObjectEditorPreferencePage_add_all, maxWidth);
        maxWidth = this.getGreaterWidth(gc, Messages.SchemaObjectEditorPreferencePage_remove, maxWidth);
        maxWidth = this.getGreaterWidth(gc, Messages.SchemaObjectEditorPreferencePage_remove_all, maxWidth);
        maxWidth = this.getGreaterWidth(gc, Messages.SchemaObjectEditorPreferencePage_move_up, maxWidth);
        maxWidth = this.getGreaterWidth(gc, Messages.SchemaObjectEditorPreferencePage_move_down, maxWidth);
        return maxWidth;
    }

    private int getGreaterWidth(GC gc, String str, int compareWidth) {
        int greaterWidth = compareWidth;
        Point strExtentPoint = gc.stringExtent(str);
        int strWidth = strExtentPoint.x;
        if (strWidth > compareWidth) {
            greaterWidth = strWidth;
        }
        return greaterWidth;
    }
}

