/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.catalog.IDatabaseObject;
import org.eclipse.datatools.enablement.ibm.catalog.util.CatalogStatistics;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDistinctUserDefinedType;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogFederatedParameter;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogFederatedServer;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogProcedure;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogSchema;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWCatalogMessages;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.impl.FederatedProcedureImpl;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.DataAccess;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Dependency;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogFederatedProcedure
extends FederatedProcedureImpl
implements ICatalogObject,
IDatabaseObject {
    private LUWCatalogFederatedServer server = null;
    private boolean loaded = false;
    private boolean dependencyLoaded = false;
    private boolean parameterLoaded = false;
    private int routineID = 0;
    private boolean externalAction = false;
    private boolean remoteFunction = false;
    private boolean statisticsLoaded = false;
    private boolean impactsLoaded = false;
    private Collection impacts = new ArrayList();
    private Collection statistics = new ArrayList();

    public void refresh() {
        this.loaded = false;
        if (this.parameterLoaded) {
            this.parameters.clear();
            this.parameterLoaded = false;
        }
        if (this.dependencyLoaded) {
            this.dependencies.clear();
            this.dependencyLoaded = false;
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public void refresh(int refreshType) {
        if (!false) {
            this.impacts.clear();
            this.impactsLoaded = false;
        }
        if ((1 & refreshType) == 1) {
            this.statistics.clear();
            this.statisticsLoaded = false;
        }
    }

    public ICatalogObject[] getImpacted() {
        if (!this.impactsLoaded) {
            this.impacts = this.getImpactedObjects();
            this.impactsLoaded = true;
        }
        ICatalogObject[] objs = new ICatalogObject[this.impacts.size()];
        this.impacts.toArray(objs);
        return objs;
    }

    private Collection getImpactedObjects() {
        ArrayList impacts = new ArrayList();
        Connection connection = this.getConnection();
        impacts.addAll(LUWCatalogProcedure.getImpactedTriggers(connection, (Routine)this));
        impacts.addAll(LUWCatalogProcedure.getImpactedTables(connection, (Routine)this));
        impacts.addAll(LUWCatalogProcedure.getImpactedConstraints(connection, (Routine)this));
        impacts.addAll(LUWCatalogProcedure.getImpactedRoutines(connection, (Routine)this));
        impacts.addAll(LUWCatalogProcedure.getImpactedPackages(connection, (Routine)this));
        return impacts;
    }

    public Collection getStatistics() {
        if (!this.statisticsLoaded) {
            this.statistics = LUWCatalogFederatedProcedure.getStatistics(this.getConnection(), (Routine)this);
            this.statisticsLoaded = true;
        }
        return this.statistics;
    }

    public static Collection getStatistics(Connection connection, Routine routine) {
        ArrayList<CatalogStatistics> statistics = new ArrayList<CatalogStatistics>();
        try {
            String query = "SELECT IOS_PER_INVOC,INSTS_PER_INVOC,IOS_PER_ARGBYTE,INSTS_PER_ARGBYTE,PERCENT_ARGBYTES,INITIAL_IOS,INITIAL_INSTS,CARDINALITY,SELECTIVITY FROM SYSSTAT.ROUTINES WHERE ROUTINESCHEMA='" + LUWUtil.getIdentifier(routine.getSchema().getName()) + "'" + " AND ROUTINENAME ='" + LUWUtil.getIdentifier(routine.getName()) + "'" + " AND SPECIFICNAME ='" + LUWUtil.getIdentifier(routine.getSpecificName()) + "'" + " FOR FETCH ONLY";
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                float selectivity;
                BigInteger card;
                float initial_insts;
                float initial_ios;
                int percent_Argbyte;
                float insts_per_Argbyte;
                float ios_per_Argbyte;
                float insts_per_Invoc;
                CatalogStatistics stats = null;
                float ios_per_Invoc = r.getFloat("IOS_PER_INVOC");
                if (ios_per_Invoc != -1.0f) {
                    stats = new CatalogStatistics("IOS_PER_INVOC", LUWCatalogMessages.STAT_IOS_PER_INVOC, LUWCatalogMessages.STAT_IOS_PER_INVOC_DES, ios_per_Invoc, "SYSSTAT.ROUTINES");
                    statistics.add(stats);
                }
                if ((insts_per_Invoc = r.getFloat("INSTS_PER_INVOC")) != -1.0f) {
                    stats = new CatalogStatistics("INSTS_PER_INVOC", LUWCatalogMessages.STAT_INSTS_PER_INVOC, LUWCatalogMessages.STAT_INSTS_PER_INVOC_DES, insts_per_Invoc, "SYSSTAT.ROUTINES");
                    statistics.add(stats);
                }
                if ((ios_per_Argbyte = r.getFloat("IOS_PER_ARGBYTE")) != -1.0f) {
                    stats = new CatalogStatistics("IOS_PER_ARGBYTE", LUWCatalogMessages.STAT_IOS_PER_ARGBYTE, LUWCatalogMessages.STAT_IOS_PER_ARGBYTE_DES, ios_per_Argbyte, "SYSSTAT.ROUTINES");
                    statistics.add(stats);
                }
                if ((insts_per_Argbyte = r.getFloat("INSTS_PER_ARGBYTE")) != -1.0f) {
                    stats = new CatalogStatistics("INSTS_PER_ARGBYTE", LUWCatalogMessages.STAT_INSTS_PER_ARGBYTE, LUWCatalogMessages.STAT_INSTS_PER_ARGBYTE_DES, insts_per_Argbyte, "SYSSTAT.ROUTINES");
                    statistics.add(stats);
                }
                if ((percent_Argbyte = r.getInt("PERCENT_ARGBYTES")) != -1) {
                    stats = new CatalogStatistics("PERCENT_ARGBYTES", LUWCatalogMessages.STAT_PERCENT_ARGBYTE, LUWCatalogMessages.STAT_PERCENT_ARGBYTE_DES, percent_Argbyte, "SYSSTAT.ROUTINES");
                    statistics.add(stats);
                }
                if ((initial_ios = r.getFloat("INITIAL_IOS")) != -1.0f) {
                    stats = new CatalogStatistics("INITIAL_IOS", LUWCatalogMessages.STAT_INITIAL_IOS, LUWCatalogMessages.STAT_INITIAL_IOS_DES, initial_ios, "SYSSTAT.ROUTINES");
                    statistics.add(stats);
                }
                if ((initial_insts = r.getFloat("INITIAL_INSTS")) != -1.0f) {
                    stats = new CatalogStatistics("INITIAL_INSTS", LUWCatalogMessages.STAT_INITIAL_INSTS, LUWCatalogMessages.STAT_INITIAL_INSTS_DES, initial_insts, "SYSSTAT.ROUTINES");
                    statistics.add(stats);
                }
                if ((card = r.getBigDecimal("CARDINALITY").toBigInteger()).intValue() != -1) {
                    stats = new CatalogStatistics("CARDINALITY", LUWCatalogMessages.STAT_ROUTINE_CARDINALITY, LUWCatalogMessages.STAT_ROUTINE_CARDINALITY_DES, card, "SYSSTAT.ROUTINES");
                    statistics.add(stats);
                }
                if ((selectivity = r.getFloat("SELECTIVITY")) == -1.0f) continue;
                stats = new CatalogStatistics("SELECTIVITY", LUWCatalogMessages.STAT_SELECTIVITY, LUWCatalogMessages.STAT_SELECTIVITY_DES, selectivity, "SYSSTAT.ROUTINES");
                statistics.add(stats);
            }
            r.close();
            s.close();
        }
        catch (SQLException sQLException) {}
        return statistics;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        if (!this.loaded) {
            this.load();
        }
        return this.getSchema().getDatabase();
    }

    public boolean isDeterministic() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.isDeterministic();
        }
        if (!this.loaded) {
            this.load();
        }
        return super.isDeterministic();
    }

    public EList getDependencies() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getDependencies();
        }
        if (!this.dependencyLoaded) {
            this.loadDependencies();
        }
        return this.dependencies;
    }

    public EList getParameters() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getParameters();
        }
        if (!this.parameterLoaded) {
            this.loadParameters();
        }
        return this.parameters;
    }

    public DataAccess getSqlDataAccess() {
        if (!this.loaded) {
            this.load();
        }
        return this.sqlDataAccess;
    }

    @Override
    public String getRemoteServer() {
        if (!this.loaded) {
            this.load();
        }
        return this.remoteServer;
    }

    private synchronized void load() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection connection = this.getConnection();
        DatabaseDefinition definition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        String version = definition.getVersion();
        float ver = 8.0f;
        try {
            ver = Float.parseFloat(version.substring(1));
            if (ver < 9.0f) {
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery("SELECT OPTION, SETTING FROM SYSIBM.SYSROUTINEOPTIONS WHERE ROUTINEID=" + this.routineID);
            while (r.next()) {
                String option = r.getString("OPTION");
                String setting = r.getString("SETTING");
                if (option.equals("REMOTE_UNIQUE_ID")) {
                    this.setRemoteUniqueId(setting);
                    continue;
                }
                if (option.equals("REMOTE_SERVER")) {
                    this.setRemoteServer(setting);
                    continue;
                }
                if (option.equals("SERVER")) {
                    this.setFederatedServerByName(setting);
                    continue;
                }
                if (option.equals("REMOTE_SCHEMA")) {
                    this.setRemoteSchema(setting);
                    continue;
                }
                if (option.equals("REMOTE_PACKAGE")) {
                    this.setRemotePackage(setting);
                    continue;
                }
                if (option.equals("REMOTE_PROCEDURE")) {
                    this.setRemoteProcedureName(setting);
                    continue;
                }
                if (option.equals("REMOTE_NUMPARM")) {
                    this.setNumberOfParameters(Integer.decode(setting));
                    continue;
                }
                if (option.equals("RESULT_SETS_TO_CLIENT")) {
                    this.setResultSetsToClient(setting);
                    continue;
                }
                if (option.equals("REMOTE_REFCURSORS")) {
                    this.setNumberOfRefCursors(Integer.decode(setting));
                    continue;
                }
                if (option.equals("ALL_RESULT_SETS_TO_CALLER")) {
                    this.setAllResultSetsToCaller(setting);
                    continue;
                }
                if (!option.equals("IS_REMOTE_FUNCTION")) continue;
                this.setOracleRemoteFunction(setting);
            }
            r.close();
            s.close();
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }

    private synchronized void loadDependencies() {
        if (this.dependencyLoaded) {
            return;
        }
        this.dependencyLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            EList dependencyList = super.getDependencies();
            LUWCatalogProcedure.loadDependencies(this.getConnection(), dependencyList, (Routine)this);
            if (this.getFederatedServer() != null) {
                Database database = this.getSchema().getDatabase();
                DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
                DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
                Dependency dep = (Dependency)factory.create(SQLSchemaPackage.eINSTANCE.getDependency());
                dep.setTargetEnd((EObject)this.getFederatedServer());
                dependencyList.add((Object)dep);
            }
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }

    private synchronized void loadParameters() {
        if (this.parameterLoaded) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogFederatedProcedure.loadParameters(this.getConnection(), super.getParameters(), this);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.parameterLoaded = true;
        this.eSetDeliver(deliver);
    }

    public static void loadParameters(Connection connection, EList parameterList, LUWCatalogFederatedProcedure fedSP) throws SQLException {
        Database database = fedSP.getSchema().getDatabase();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        String query = "SELECT PARMNAME,ROWTYPE,LOCATOR,TYPESCHEMA,TYPENAME,LENGTH,SCALE,CODEPAGE,REMARKS,TARGET_TYPESCHEMA,TARGET_TYPENAME,ORDINAL FROM SYSIBM.SYSROUTINEPARMS WHERE ROUTINE_ID=" + LUWCatalogFederatedProcedure.getRoutineID(fedSP) + " ORDER BY ORDINAL";
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery(query);
        try {
            while (r.next()) {
                String typeSchemaName;
                PredefinedDataTypeDefinition typeDefinition;
                LUWCatalogFederatedParameter parameter = new LUWCatalogFederatedParameter();
                String name = r.getString("PARMNAME");
                parameter.setName(name);
                String rowtype = r.getString("ROWTYPE").trim();
                if (rowtype.equals("B")) {
                    parameter.setMode(ParameterMode.INOUT_LITERAL);
                } else if (rowtype.equals("O")) {
                    parameter.setMode(ParameterMode.OUT_LITERAL);
                } else if (rowtype.equals("P")) {
                    parameter.setMode(ParameterMode.IN_LITERAL);
                }
                String locator = r.getString("LOCATOR");
                if (locator.equals("Y")) {
                    parameter.setLocator(true);
                } else {
                    parameter.setLocator(false);
                }
                String typeName = r.getString("TYPENAME");
                if (typeName.equalsIgnoreCase("FLOAT")) {
                    int length = r.getInt("LENGTH");
                    typeName = length == 4 ? "REAL" : "DOUBLE";
                }
                if ((typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(typeName)) != null) {
                    EStructuralFeature feature;
                    int length;
                    int codePage;
                    if (typeDefinition.getPrimitiveType().getValue() == 0) {
                        codePage = r.getInt(8);
                        if (codePage == 0) {
                            typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition("CHAR () FOR BIT DATA");
                        }
                    } else if (typeDefinition.getPrimitiveType().getValue() == 1 && (codePage = r.getInt(8)) == 0) {
                        typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition("VARCHAR () FOR BIT DATA");
                    }
                    PredefinedDataType type = databaseDefinition.getPredefinedDataType(typeDefinition);
                    if (typeDefinition.isLengthSupported()) {
                        length = r.getInt("LENGTH");
                        feature = type.eClass().getEStructuralFeature("length");
                        type.eSet(feature, (Object)length);
                    } else if (typeDefinition.isPrecisionSupported()) {
                        int length2 = r.getInt("LENGTH");
                        feature = type.eClass().getEStructuralFeature("precision");
                        type.eSet(feature, (Object)length2);
                    }
                    if (typeDefinition.isScaleSupported()) {
                        length = r.getInt("SCALE");
                        feature = type.eClass().getEStructuralFeature("scale");
                        type.eSet(feature, (Object)length);
                    }
                    parameter.setContainedType((SQLDataType)type);
                } else if (typeName.equals("REFERENCE")) {
                    typeSchemaName = r.getString("TARGET_TYPESCHEMA").trim();
                    String udtName = r.getString("TARGET_TYPENAME");
                    parameter.setReferencedType(LUWCatalogFederatedProcedure.getUserDefinedType(fedSP, typeSchemaName, udtName));
                } else {
                    typeSchemaName = r.getString("TYPESCHEMA").trim();
                    parameter.setReferencedType(LUWCatalogFederatedProcedure.getUserDefinedType(fedSP, typeSchemaName, typeName));
                }
                parameter.setDescription(r.getString("REMARKS"));
                parameter.setFederatedProcedure(fedSP);
                parameterList.add((Object)parameter);
                int ordinal = r.getInt("ORDINAL");
                LUWCatalogFederatedParameter.loadParameterOptions(connection, parameter, LUWCatalogFederatedProcedure.getRoutineID(fedSP), ordinal);
            }
        }
        catch (Exception exception) {}
        r.close();
        s.close();
    }

    public static Schema getSchema(LUWCatalogFederatedProcedure fedSP, String schemaName) {
        Schema s2 = fedSP.getSchema();
        if (s2.getName().trim().equals(schemaName.trim())) {
            return s2;
        }
        Database d = s2.getDatabase();
        for (Schema s2 : d.getSchemas()) {
            if (!s2.getName().trim().equals(schemaName.trim())) continue;
            return s2;
        }
        LUWCatalogSchema schema = new LUWCatalogSchema();
        schema.setName(schemaName);
        schema.setDatabase(d);
        return schema;
    }

    public static Table getTable(LUWCatalogFederatedProcedure fedSP, String schemaName, String tableName) {
        LUWCatalogTable table2;
        Schema schema = LUWCatalogFederatedProcedure.getSchema(fedSP, schemaName);
        for (LUWCatalogTable table2 : schema.getTables()) {
            if (!table2.getName().equals(tableName)) continue;
            return table2;
        }
        table2 = new LUWCatalogTable();
        table2.setName(tableName);
        table2.setSchema(schema);
        return table2;
    }

    public static int getRoutineID(LUWCatalogFederatedProcedure fedSP) {
        if (!fedSP.loaded) {
            fedSP.load();
        }
        return fedSP.routineID;
    }

    public static Routine getRountine(LUWCatalogFederatedProcedure fedSP, String schemaName, String routineName) {
        LUWCatalogFederatedProcedure r2;
        Schema schema = LUWCatalogFederatedProcedure.getSchema(fedSP, schemaName);
        for (LUWCatalogFederatedProcedure r2 : schema.getRoutines()) {
            if (!r2.getName().equals(routineName)) continue;
            return r2;
        }
        r2 = new LUWCatalogFederatedProcedure();
        r2.setName(routineName);
        r2.setSchema(schema);
        return r2;
    }

    public static UserDefinedType getUserDefinedType(LUWCatalogFederatedProcedure fedSP, String schemaName, String userDefinedTypeName) {
        LUWCatalogDistinctUserDefinedType userDefinedType2;
        Schema schema = LUWCatalogFederatedProcedure.getSchema(fedSP, schemaName);
        for (LUWCatalogDistinctUserDefinedType userDefinedType2 : schema.getUserDefinedTypes()) {
            if (!userDefinedType2.getName().equals(userDefinedTypeName)) continue;
            return userDefinedType2;
        }
        userDefinedType2 = new LUWCatalogDistinctUserDefinedType();
        userDefinedType2.setName(userDefinedTypeName);
        userDefinedType2.setSchema(schema);
        return userDefinedType2;
    }

    public void setRoutineID(int id) {
        this.routineID = id;
    }

    public DataAccess getSQLDataAccess() {
        if (!this.loaded) {
            this.load();
        }
        return this.sqlDataAccess;
    }

    public void setSQLDataAccess(DataAccess da) {
        this.sqlDataAccess = da;
    }

    public boolean isExternalAction() {
        if (!this.loaded) {
            this.load();
        }
        return this.externalAction;
    }

    public void setExternalAction(String ea) {
        if (ea.trim().equals("E")) {
            this.externalAction = true;
        }
    }

    private void setAllResultSetsToCaller(String setting) {
        if (setting.trim().equals("Y")) {
            this.setAllResultSetsToCaller(true);
        } else {
            this.setAllResultSetsToCaller(false);
        }
    }

    public LUWCatalogFederatedServer getFederatedServer() {
        if (!this.loaded) {
            this.load();
        }
        return this.server;
    }

    private void setFederatedServerByName(String setting) {
        Database db = this.getSchema().getDatabase();
        if (db instanceof LUWCatalogDatabase) {
            EList servers = ((LUWCatalogDatabase)db).getServers();
            for (SQLObject obj : servers) {
                if (!(obj instanceof LUWCatalogFederatedServer) || !obj.getName().trim().equals(setting.trim())) continue;
                this.server = (LUWCatalogFederatedServer)obj;
                this.setRemoteServer(this.server.getName());
                break;
            }
        }
    }

    private void setOracleRemoteFunction(String setting) {
        if (setting.equals("Y")) {
            this.remoteFunction = true;
        }
    }

    public boolean isOracleRemoteFunction() {
        return this.remoteFunction;
    }
}

