/*
 * Decompiled with CFR 0.152.
 */
package lpg.lpgjavaruntime;

public class IntSegmentedTuple {
    private int top;
    private int size;
    private int log_blksize = 3;
    private int base_size = 4;
    private int[][] base;

    private void allocateMoreSpace() {
        int k = this.size >> this.log_blksize;
        if (k == this.base_size) {
            this.base_size *= 2;
            int[][] nArrayArray = new int[this.base_size][];
            this.base = nArrayArray;
            System.arraycopy(this.base, 0, nArrayArray, 0, k);
        }
        this.base[k] = new int[1 << this.log_blksize];
        this.size += 1 << this.log_blksize;
    }

    public void resize() {
        this.resize(0);
    }

    public void resize(int n) {
        if (n > this.size) {
            do {
                this.allocateMoreSpace();
            } while (n > this.size);
        }
        this.top = n;
    }

    public void reset() {
        this.reset(0);
    }

    public void reset(int n) {
        this.top = n;
    }

    public int size() {
        return this.top;
    }

    public boolean outOfRange(int i) {
        return i < 0 || i >= this.top;
    }

    public int get(int i) {
        return this.base[i >> this.log_blksize][i % (1 << this.log_blksize)];
    }

    public void set(int i, int element) {
        this.base[i >> this.log_blksize][i % (1 << this.log_blksize)] = element;
    }

    public int NextIndex() {
        int i;
        if ((i = this.top++) == this.size) {
            this.allocateMoreSpace();
        }
        return i;
    }

    public void add(int element) {
        int i = this.NextIndex();
        this.base[i >> this.log_blksize][i % (1 << this.log_blksize)] = element;
    }

    public int binarySearch(int element) {
        int low = 0;
        int high = this.top;
        while (high > low) {
            int mid = (high + low) / 2;
            int mid_element = this.get(mid);
            if (element == mid_element) {
                return mid;
            }
            if (element < mid_element) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return -low;
    }

    public IntSegmentedTuple() {
        this.base = new int[this.base_size][];
    }

    public IntSegmentedTuple(int log_blksize_) {
        this.log_blksize = log_blksize_;
        this.base = new int[this.base_size][];
    }

    public IntSegmentedTuple(int log_blksize_, int base_size_) {
        this.log_blksize = log_blksize_;
        this.base_size = base_size_ <= 0 ? 4 : base_size_;
        this.base = new int[this.base_size][];
    }
}

