/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.extensions.IExternalSearchProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class CSearchProviderManager {
    private final String SEARCH_PROVIDERS = "org.eclipse.cdt.ui.externalSearchProviders";
    private final Object ELEMENT_PROVIDER = "provider";
    private final String ATTRIBUTE_CLASS = "class";
    private List<IExternalSearchProvider> externalSearchProviders;
    public static CSearchProviderManager INSTANCE = new CSearchProviderManager();

    private CSearchProviderManager() {
    }

    public List<IExternalSearchProvider> getExternalSearchProviders() {
        if (this.externalSearchProviders == null) {
            this.externalSearchProviders = new ArrayList<IExternalSearchProvider>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint indexProviderPoint = registry.getExtensionPoint("org.eclipse.cdt.ui.externalSearchProviders");
            IExtension[] iExtensionArray = indexProviderPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                try {
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if (this.ELEMENT_PROVIDER.equals(element.getName())) {
                            Object provider = element.createExecutableExtension("class");
                            if (provider instanceof IExternalSearchProvider) {
                                this.externalSearchProviders.add((IExternalSearchProvider)provider);
                            } else {
                                CUIPlugin.logError(NLS.bind((String)CSearchMessages.CSearchProviderManager_InvalidSearchProvider, (Object)extension.getContributor().getName()));
                            }
                        }
                        ++n4;
                    }
                }
                catch (CoreException e) {
                    CUIPlugin.log(e);
                }
                ++n2;
            }
        }
        return this.externalSearchProviders;
    }
}

