/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.Properties;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcHttpClientConfig;
import org.apache.xmlrpc.client.XmlRpcStreamTransport;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.util.HttpUtil;
import org.xml.sax.SAXException;

public abstract class XmlRpcHttpTransport
extends XmlRpcStreamTransport {
    public static final String USER_AGENT;
    private String userAgent;
    static /* synthetic */ Class class$org$apache$xmlrpc$client$XmlRpcHttpTransport;

    protected XmlRpcHttpTransport(XmlRpcClient pClient, String pUserAgent) {
        super(pClient);
        this.userAgent = pUserAgent;
    }

    protected String getUserAgent() {
        return this.userAgent;
    }

    protected abstract void setRequestHeader(String var1, String var2);

    protected void setCredentials(XmlRpcHttpClientConfig pConfig) throws XmlRpcClientException {
        String auth;
        try {
            auth = HttpUtil.encodeBasicAuthentication((String)pConfig.getBasicUserName(), (String)pConfig.getBasicPassword(), (String)pConfig.getBasicEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new XmlRpcClientException("Unsupported encoding: " + pConfig.getBasicEncoding(), e);
        }
        if (auth != null) {
            this.setRequestHeader("Authorization", "Basic " + auth);
        }
    }

    protected void setContentLength(int pLength) {
        this.setRequestHeader("Content-Length", Integer.toString(pLength));
    }

    protected void setCompressionHeaders(XmlRpcHttpClientConfig pConfig) {
        if (pConfig.isGzipCompressing()) {
            this.setRequestHeader("Content-Encoding", "gzip");
        }
        if (pConfig.isGzipRequesting()) {
            this.setRequestHeader("Accept-Encoding", "gzip");
        }
    }

    protected void initHttpHeaders(XmlRpcRequest pRequest) throws XmlRpcClientException {
        XmlRpcHttpClientConfig config = (XmlRpcHttpClientConfig)pRequest.getConfig();
        this.setRequestHeader("Content-Type", "text/xml");
        if (config.getUserAgent() != null) {
            this.setRequestHeader("User-Agent", config.getUserAgent());
        } else {
            this.setRequestHeader("User-Agent", this.getUserAgent());
        }
        this.setCredentials(config);
        this.setCompressionHeaders(config);
    }

    public Object sendRequest(XmlRpcRequest pRequest) throws XmlRpcException {
        this.initHttpHeaders(pRequest);
        return super.sendRequest(pRequest);
    }

    protected boolean isUsingByteArrayOutput(XmlRpcHttpClientConfig pConfig) {
        return !pConfig.isEnabledForExtensions() || !pConfig.isContentLengthOptional();
    }

    protected XmlRpcStreamTransport.ReqWriter newReqWriter(XmlRpcRequest pRequest) throws XmlRpcException, IOException, SAXException {
        XmlRpcHttpClientConfig config = (XmlRpcHttpClientConfig)pRequest.getConfig();
        if (this.isUsingByteArrayOutput(config)) {
            ByteArrayReqWriter reqWriter = new ByteArrayReqWriter(pRequest);
            this.setContentLength(reqWriter.getContentLength());
            if (this.isCompressingRequest((XmlRpcStreamRequestConfig)config)) {
                return new XmlRpcStreamTransport.GzipReqWriter(this, reqWriter);
            }
            return reqWriter;
        }
        return super.newReqWriter(pRequest);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String p = "XmlRpcClient.properties";
        URL url = (class$org$apache$xmlrpc$client$XmlRpcHttpTransport == null ? (class$org$apache$xmlrpc$client$XmlRpcHttpTransport = XmlRpcHttpTransport.class$("org.apache.xmlrpc.client.XmlRpcHttpTransport")) : class$org$apache$xmlrpc$client$XmlRpcHttpTransport).getResource("XmlRpcClient.properties");
        if (url == null) {
            throw new IllegalStateException("Failed to locate resource: XmlRpcClient.properties");
        }
        InputStream stream = null;
        try {
            stream = url.openStream();
            Properties props = new Properties();
            props.load(stream);
            USER_AGENT = props.getProperty("user.agent");
            if (USER_AGENT == null || USER_AGENT.trim().length() == 0) {
                throw new IllegalStateException("The property user.agent is not set.");
            }
            stream.close();
            stream = null;
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e, "Failed to load resource " + url + ": " + e.getMessage());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    protected class ByteArrayReqWriter
    implements XmlRpcStreamTransport.ReqWriter {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        ByteArrayReqWriter(XmlRpcRequest pRequest) throws XmlRpcException, IOException, SAXException {
            new XmlRpcStreamTransport.ReqWriterImpl(XmlRpcHttpTransport.this, pRequest).write(this.baos);
        }

        protected int getContentLength() {
            return this.baos.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(OutputStream pStream) throws IOException {
            try {
                this.baos.writeTo(pStream);
                pStream.close();
                pStream = null;
            }
            finally {
                if (pStream != null) {
                    try {
                        pStream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }
}

