/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal.token;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.asciidoc.internal.AsciiDocContentState;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElementProcessor;

public class InlineAttributeReplacementToken
extends PatternBasedElement {
    protected String getPattern(int groupOffset) {
        return "(?<!\\\\)\\{(.*?)\\}";
    }

    protected int getPatternGroupCount() {
        return 1;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new InlineAttributeTokenReplacementProcessor();
    }

    private static class InlineAttributeTokenReplacementProcessor
    extends PatternBasedElementProcessor {
        private static final Pattern SET_PATTERN = Pattern.compile("set:(.*?):(.*)");
        private static final Pattern UNSET_PATTERN = Pattern.compile("set:(.*?)!");

        private InlineAttributeTokenReplacementProcessor() {
        }

        public void emit() {
            String key = this.group(1);
            Matcher setMatcher = SET_PATTERN.matcher(key);
            Matcher unsetMatcher = UNSET_PATTERN.matcher(key);
            AsciiDocContentState asciiDocState = (AsciiDocContentState)this.getState();
            if (setMatcher.matches()) {
                String newKey = setMatcher.group(1);
                String newValue = setMatcher.group(2);
                asciiDocState.putAttribute(newKey, newValue);
            } else if (unsetMatcher.matches()) {
                String newKey = unsetMatcher.group(1);
                asciiDocState.removeAttribute(newKey);
            } else if (asciiDocState.isAttributeDefined(key)) {
                this.markupLanguage.emitMarkupLine(this.getParser(), this.state, asciiDocState.getAttribute(key), 0);
            } else {
                this.builder.characters(this.group(0));
            }
        }
    }
}

