/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jst.j2ee.common.EnvEntry;
import org.eclipse.jst.j2ee.common.JNDIEnvRefsGroup;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.common.internal.impl.EJBLocalRefImpl;
import org.eclipse.jst.j2ee.common.internal.impl.EjbRefImpl;
import org.eclipse.jst.j2ee.common.internal.impl.ResourceRefImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.core.internal.plugin.J2EECorePlugin;
import org.eclipse.jst.j2ee.model.internal.validation.J2EEValidator;
import org.eclipse.jst.j2ee.model.internal.validation.WARMessageConstants;
import org.eclipse.jst.j2ee.model.internal.validation.WARValidationResourceHandler;
import org.eclipse.jst.j2ee.webapplication.AuthConstraint;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.j2ee.webapplication.ErrorCodeErrorPage;
import org.eclipse.jst.j2ee.webapplication.ErrorPage;
import org.eclipse.jst.j2ee.webapplication.ExceptionTypeErrorPage;
import org.eclipse.jst.j2ee.webapplication.Filter;
import org.eclipse.jst.j2ee.webapplication.FilterMapping;
import org.eclipse.jst.j2ee.webapplication.FormLoginConfig;
import org.eclipse.jst.j2ee.webapplication.HTTPMethodType;
import org.eclipse.jst.j2ee.webapplication.InitParam;
import org.eclipse.jst.j2ee.webapplication.JSPType;
import org.eclipse.jst.j2ee.webapplication.LoginConfig;
import org.eclipse.jst.j2ee.webapplication.MimeMapping;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.SessionConfig;
import org.eclipse.jst.j2ee.webapplication.TagLibRef;
import org.eclipse.jst.j2ee.webapplication.TransportGuaranteeType;
import org.eclipse.jst.j2ee.webapplication.UserDataConstraint;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;
import org.eclipse.jst.j2ee.webapplication.WelcomeFile;
import org.eclipse.jst.j2ee.webapplication.WelcomeFileList;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class WarValidator
extends J2EEValidator
implements WARMessageConstants {
    protected WARFile warFile;
    protected WebApp webDD;
    private Hashtable httpMethods = null;

    public Hashtable getAndValidateSecurityRoles(EList roles) {
        Hashtable<String, String> secRoles = new Hashtable<String, String>();
        if (roles.isEmpty()) {
            return secRoles;
        }
        Iterator sRoles = roles.iterator();
        while (sRoles.hasNext()) {
            String[] parms;
            SecurityRole role;
            String name;
            if (this._reporter.isCancelled()) {
                String msg = ResourceHandler.getExternalizedMessage((String)"VBF_STATUS_VALIDATOR_TERMINATED");
                this.status = WTPCommonPlugin.createCancelStatus((String)msg);
            }
            if ((name = (role = (SecurityRole)sRoles.next()).getRoleName()) != null) {
                name = name.trim();
            }
            if (name == null || name.equals("")) {
                parms = new String[]{WARValidationResourceHandler.of_Type_Security_Role_Name_6};
                this.addError("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, role);
                continue;
            }
            if (secRoles.get(name) != null) {
                parms = new String[]{name};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", parms, role);
                continue;
            }
            secRoles.put(name, "Yea");
        }
        return secRoles;
    }

    @Override
    public String getBaseName() {
        return "org.eclipse.jst.j2ee.model.internal.validation.warvalidation";
    }

    @Override
    public String getName() {
        return WARValidationResourceHandler.Web_Archive_Validator_8;
    }

    @Override
    public String getName(Locale locale) {
        return this.getMessage(null, "webArchiveValidator.name", locale);
    }

    protected boolean isHttpMethod(String method) {
        String compare;
        if (this.httpMethods == null) {
            String[] mList = new String[]{"GET", "PUT", "HEAD", "TRACE", "POST", "DELETE", "OPTIONS", "ACK", "ACL", "BASELINE-CONTROL", "BIND", "BYE", "CANCEL", "CHECKIN", "CHECKOUT", "COPY", "ERRORRESPONSE", "INFO", "INVITE", "LABEL", "LOCK", "MERGE", "MESSAGE", "MKACTIVITY", "MKCOL", "MKWORKSPACE", "MOVE", "NOTIFY", "PRACK", "PROPFIND", "PROPPATCH", "PROVISIONALRESPONSE", "PUBLISH", "REBIND", "REDIRECTRESPONSE", "REGISTER", "REPORT", "REQUEST", "RESPONSE", "SEARCH", "SUCCESSRESPONSE", "UNBIND", "UNCHECKOUT", "UNLOCK", "UPDATE", "VERSION-CONTROL"};
            this.httpMethods = new Hashtable();
            int i = 0;
            while (i < mList.length) {
                this.httpMethods.put(mList[i], "bla");
                ++i;
            }
        }
        return this.httpMethods.get(compare = method.trim()) != null;
    }

    public void validate() throws ValidationException {
        this.validateMimeMapping();
        this.validateContextParameters();
        this.validateTagLibs();
        this.validateServletMappings(this.webDD.getServletMappings());
        this.validateWelcomeFileList(this.webDD.getFileList());
        this.validateErrorPages(this.webDD.getErrorPages());
        this.validateSecurityAndServlets();
        this.validateFilters(this.webDD.getFilters());
        this.validateFilterMappings(this.webDD.getFilterMappings());
        this.validateRefs();
        this.validateLoginConfig(this.webDD.getLoginConfig());
        this.validateEnvironmentEntries(this.webDD.getEnvironmentProperties());
        this.validateOther();
        this.validate14();
    }

    private void validate14() {
        int versionId = this.webDD.getVersionID();
        if (versionId == 24) {
            this.validateUrlPattern();
        }
    }

    private void validateUrlPattern() {
        EList servletMappings = this.webDD.getServletMappings();
        int i = 0;
        while (i < servletMappings.size()) {
            ServletMapping mapping = (ServletMapping)servletMappings.get(i);
            String urlPattern = mapping.getUrlPattern();
            int newLineChar = urlPattern.indexOf(13);
            if (newLineChar != -1) {
                String[] parms = new String[]{urlPattern, mapping.getServlet().getDisplayName()};
                this.addError("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_URL_PATTERN_END_WITH_CARRAIGE_RETURN", parms, mapping);
            }
            ++i;
        }
    }

    @Override
    public void validate(IValidationContext inHelper, IReporter inReporter) throws ValidationException {
        this.validateInJob(inHelper, inReporter);
    }

    @Override
    public IStatus validateInJob(IValidationContext inHelper, IReporter inReporter) throws ValidationException {
        this.status = super.validateInJob(inHelper, inReporter);
        this._reporter.removeAllMessages((IValidator)this, null);
        if (!this._reporter.isCancelled()) {
            this.warFile = (WARFile)this._helper.loadModel("WAR_VALIDATION");
            try {
                if (this.warFile == null) {
                    Message errorMsg = new Message(this.getBaseName(), 1, "ERROR_INVALID_WAR_FILE");
                    this.status = WTPCommonPlugin.createErrorStatus((String)errorMsg.getText(this.getClass().getClassLoader()));
                    throw new ValidationException((IMessage)errorMsg);
                }
                this.webDD = this.warFile.getDeploymentDescriptor();
                this.validate();
            }
            catch (ValidationException ex) {
                throw ex;
            }
            catch (Exception e) {
                String[] parms = new String[]{e.toString()};
                Message errorMsg = new Message(this.getBaseName(), 1, "ERROR_WAR_VALIDATION_FAILED", parms);
                this.status = WTPCommonPlugin.createErrorStatus((String)errorMsg.getText(this.getClass().getClassLoader()));
                throw new ValidationException((IMessage)errorMsg, (Throwable)e);
            }
        } else {
            String msg = ResourceHandler.getExternalizedMessage((String)"VBF_STATUS_VALIDATOR_TERMINATED");
            this.status = WTPCommonPlugin.createCancelStatus((String)msg);
        }
        return this.status;
    }

    public void validate(Object aWarFile) throws ValidationException {
        try {
            this.warFile = (WARFile)aWarFile;
            this.webDD = this.warFile.getDeploymentDescriptor();
            this.validate();
        }
        catch (Exception e) {
            J2EECorePlugin.logError(e);
            String[] parms = new String[]{e.toString()};
            Message errorMsg = new Message(this.getBaseName(), 1, "ERROR_WAR_VALIDATION_FAILED", parms);
            throw new ValidationException((IMessage)errorMsg);
        }
    }

    public void validateAuthConstraint(AuthConstraint authConstraint, Hashtable secRoles) {
        EList roleList = authConstraint.getRoles();
        if (roleList != null && !roleList.isEmpty()) {
            Iterator authRoles = roleList.iterator();
            Hashtable<String, String> remember = new Hashtable<String, String>();
            while (authRoles.hasNext()) {
                String[] parms;
                String role = (String)authRoles.next();
                if (role == null || role.trim().equals("")) {
                    parms = new String[]{WARValidationResourceHandler.of_Type_Role_Name_19};
                    this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, authConstraint);
                    continue;
                }
                if (remember.get(role.trim()) != null) {
                    parms = new String[]{role};
                    this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", parms, authConstraint);
                    continue;
                }
                remember.put(role.trim(), "Yea");
                this.validateAuthSecRole("", role, secRoles, authConstraint);
            }
        }
    }

    public void validateContextParameters() {
        Hashtable<String, String> remember = new Hashtable<String, String>();
        Iterator cparams = this.webDD.getContexts().iterator();
        while (cparams.hasNext()) {
            String[] parms;
            ContextParam context;
            String name;
            if (this._reporter.isCancelled()) {
                String msg = ResourceHandler.getExternalizedMessage((String)"VBF_STATUS_VALIDATOR_TERMINATED");
                this.status = WTPCommonPlugin.createCancelStatus((String)msg);
            }
            if ((name = (context = (ContextParam)cparams.next()).getParamName()) != null) {
                name = name.trim();
            }
            if (name == null || name.equals("")) {
                parms = new String[]{WARValidationResourceHandler.of_Type_Parameter_Name_25};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, context);
                continue;
            }
            if (remember.get(name) != null) {
                parms = new String[]{String.valueOf(WARValidationResourceHandler.of_Type_Parameter_Name_25) + ": " + name};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", parms, context);
                continue;
            }
            remember.put(name, "Yea");
        }
        for (Servlet nextServlet : this.webDD.getServlets()) {
            Iterator params = nextServlet.getParams().iterator();
            remember.clear();
            while (params.hasNext()) {
                String[] parms;
                InitParam initParam = (InitParam)params.next();
                String name = initParam.getParamName();
                if (name != null) {
                    name = name.trim();
                }
                if (name == null || name.equals("")) {
                    parms = new String[]{WARValidationResourceHandler.of_Type_Parameter_Name_32};
                    this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, initParam);
                    continue;
                }
                if (remember.get(name) != null) {
                    parms = new String[]{String.valueOf(WARValidationResourceHandler.of_Type_Parameter_Name_25) + ": " + name};
                    this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", parms, initParam);
                    continue;
                }
                remember.put(name, "Yea");
            }
        }
        for (Filter nextFilter : this.webDD.getFilters()) {
            Iterator params = nextFilter.getInitParams().iterator();
            remember.clear();
            while (params.hasNext()) {
                String[] parms;
                InitParam initParam = (InitParam)params.next();
                String name = initParam.getParamName();
                if (name != null) {
                    name = name.trim();
                }
                if (name == null || name.equals("")) {
                    parms = new String[]{WARValidationResourceHandler.of_Type_Parameter_Name_39};
                    this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, initParam);
                    continue;
                }
                if (remember.get(name) != null) {
                    parms = new String[]{String.valueOf(WARValidationResourceHandler.of_Type_Parameter_Name_25) + ": " + name};
                    this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", parms, initParam);
                    continue;
                }
                remember.put(name, "Yea");
            }
        }
    }

    public void validateEJBRefs(EjbRefImpl eref) {
        EARFile earFile = this.warFile.getEARFile();
        JNDIEnvRefsGroup eb = null;
        if (earFile != null) {
            eb = earFile.getEnterpiseBeanFromRef(eref, this.warFile.getURI());
        }
        if (eb != null) {
            EList ejbRefs = eb.getEjbRefs();
            int numRefs = ejbRefs.size();
            HashSet<String> refSet = new HashSet<String>(numRefs);
            int refNo = 0;
            while (refNo < numRefs) {
                String nextName = ((EjbRefImpl)ejbRefs.get(refNo)).getName();
                String[] parms = new String[]{eb.getName()};
                if (!refSet.add(nextName)) {
                    this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "ERROR_EAR_DUPLICATE_ROLES", parms, ejbRefs.get(refNo));
                }
                ++refNo;
            }
        }
    }

    public void validateEJBRefs(List ejbRefs) {
        int numRefs = ejbRefs.size();
        Hashtable<String, String> remember = new Hashtable<String, String>();
        int refNo = 0;
        while (refNo < numRefs) {
            block4: {
                String name;
                EjbRefImpl eref;
                block5: {
                    block2: {
                        String[] parms;
                        block3: {
                            String type;
                            eref = (EjbRefImpl)ejbRefs.get(refNo);
                            if (eref.isSetType() && (type = eref.getType().getName()) == null) {
                                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_EJB_REF_TYPE", null, eref);
                            }
                            if (eref.getName() == null) break block2;
                            name = eref.getName();
                            if (!(name = name.trim()).equals("")) break block3;
                            parms = new String[]{WARValidationResourceHandler.of_Type_ejb_ref_name_44};
                            this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, eref);
                            break block4;
                        }
                        if (remember.get(name) == null) break block5;
                        parms = new String[]{name};
                        this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_EJB_REF", parms, eref);
                        break block4;
                    }
                    String[] parms = new String[]{WARValidationResourceHandler.of_Type_ejb_ref_name_44};
                    this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, eref);
                    break block4;
                }
                remember.put(name, "Yea");
                this.validateEJBRefs(eref);
                this.validateEJBRefManadatoryElements(eref, this.webDD.getDisplayName());
            }
            ++refNo;
        }
    }

    public void validateEJBLocalRefs(List ejbRefs) {
        int numRefs = ejbRefs.size();
        Hashtable<String, String> remember = new Hashtable<String, String>();
        int refNo = 0;
        while (refNo < numRefs) {
            String type;
            EJBLocalRefImpl eref = (EJBLocalRefImpl)ejbRefs.get(refNo);
            if (eref.isSetType() && (type = eref.getType().getName()) == null) {
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_EJB_REF_TYPE", null, eref);
            }
            if (eref.getName() != null) {
                String[] parms;
                String name = eref.getName();
                if ((name = name.trim()).equals("")) {
                    parms = new String[]{WARValidationResourceHandler.of_Type_ejb_ref_name_44};
                    this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, eref);
                } else if (remember.get(name) != null) {
                    parms = new String[]{name};
                    this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_EJB_REF", parms, eref);
                } else {
                    remember.put(name, "Yea");
                }
            } else {
                String[] parms = new String[]{WARValidationResourceHandler.of_Type_ejb_ref_name_44};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, eref);
            }
            ++refNo;
        }
    }

    public void validateErrorPages(EList errorPageList) {
        if (errorPageList == null || errorPageList.isEmpty()) {
            return;
        }
        Iterator errorPages = errorPageList.iterator();
        while (errorPages.hasNext()) {
            String[] parms;
            ErrorPage nextPage;
            String location;
            if (this._reporter.isCancelled()) {
                String msg = ResourceHandler.getExternalizedMessage((String)"VBF_STATUS_VALIDATOR_TERMINATED");
                this.status = WTPCommonPlugin.createCancelStatus((String)msg);
            }
            if ((location = (nextPage = (ErrorPage)errorPages.next()).getLocation()) == null || location.equals("")) {
                parms = new String[]{WARValidationResourceHandler.of_Type_Error_Location_47};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, nextPage);
            }
            if (location != null && !location.startsWith("/")) {
                parms = new String[]{WARValidationResourceHandler.of_Type_Error_Location_49};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_ERROR_PAGE", parms, nextPage);
            }
            if (nextPage.isErrorCode()) {
                ErrorCodeErrorPage ecep = (ErrorCodeErrorPage)nextPage;
                String errorCode = ecep.getErrorCode();
                boolean valid = false;
                if (errorCode.length() == 3) {
                    try {
                        Integer tempInt = new Integer(errorCode);
                        int code = tempInt;
                        if (code >= 100 && code < 600) {
                            valid = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (valid) continue;
                String[] parms2 = new String[]{errorCode};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_ERROR_CODE", parms2, ecep);
                continue;
            }
            if (!nextPage.isExceptionType()) continue;
            ExceptionTypeErrorPage etep = (ExceptionTypeErrorPage)nextPage;
            JavaClass javaType = etep.getExceptionType();
            String exceptionType = "java.lang.Throwable";
            String specifiedClassName = etep.getExceptionTypeName();
            if (javaType != null) {
                ResourceSet lookupSet = javaType.eResource().getResourceSet();
                if (lookupSet == null || javaType.inheritsFrom(JavaRefFactory.eINSTANCE.reflectType(exceptionType, lookupSet).getWrapper())) continue;
                String[] parms3 = new String[]{specifiedClassName};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_EXCEPTION_TYPE", parms3, etep);
                continue;
            }
            String[] parms4 = new String[]{""};
            this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_EXCEPTION_TYPE", parms4, etep);
        }
    }

    public void validateLoginConfig(LoginConfig loginConfig) {
        if (loginConfig != null) {
            FormLoginConfig cfg;
            String auth = loginConfig.getAuthMethod().getName();
            if (auth == null) {
                String[] parms = new String[]{};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_AUTH_METHOD", parms, loginConfig);
            } else if (!auth.equals("FORM") && (cfg = loginConfig.getFormLoginConfig()) != null) {
                String[] parms = new String[]{auth};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_IGNORE_FORM_LOGIN", parms, loginConfig);
            }
        }
    }

    public void validateEnvironmentEntries(EList envEntries) {
        if (envEntries.isEmpty()) {
            return;
        }
        Iterator entries = envEntries.iterator();
        Hashtable<String, String> remember = new Hashtable<String, String>();
        while (entries.hasNext()) {
            String name;
            EnvEntry entry = (EnvEntry)entries.next();
            if (entry.getType().getName() == null) {
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_ENV_ENTRY", null, entry);
            }
            if ((name = entry.getName()) == null) continue;
            if (remember.get(name) != null) {
                String[] parms = new String[]{String.valueOf(WARValidationResourceHandler.of_Type_Env_Entry_Name___88) + ": " + name};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", parms, entry);
                continue;
            }
            remember.put(name, "Yea");
        }
    }

    public void validateMimeMapping() {
        if (this.webDD.getMimeMappings().isEmpty()) {
            return;
        }
        Iterator mimes = this.webDD.getMimeMappings().iterator();
        Hashtable<String, String> remember = new Hashtable<String, String>();
        while (mimes.hasNext()) {
            String[] parms;
            if (this._reporter.isCancelled()) {
                String msg = ResourceHandler.getExternalizedMessage((String)"VBF_STATUS_VALIDATOR_TERMINATED");
                this.status = WTPCommonPlugin.createCancelStatus((String)msg);
            }
            MimeMapping mimeMap = (MimeMapping)mimes.next();
            String ext = mimeMap.getExtension();
            String mtype = mimeMap.getMimeType();
            if (ext != null) {
                ext = ext.trim();
            }
            if (mtype != null) {
                mtype = mtype.trim();
            }
            if (ext == null || ext.equals("") || mtype == null || mtype.equals("")) {
                parms = new String[]{ext == null || ext.trim().equals("") ? WARValidationResourceHandler.of_Type_Mime_Extension_54 : WARValidationResourceHandler.of_Type_Mime_Type_55};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, mimeMap);
                continue;
            }
            if (remember.get(ext) != null) {
                parms = new String[]{String.valueOf(WARValidationResourceHandler.of_Type_Mime_Extension___56) + ": " + ext};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", parms, mimeMap);
                continue;
            }
            remember.put(ext, "Yea");
        }
    }

    public void validateOther() {
        int timeout;
        SessionConfig sessionCfg = this.webDD.getSessionConfig();
        if (sessionCfg != null && (timeout = sessionCfg.getSessionTimeout()) == 0) {
            this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_SESSION_TIMEOUT", null, sessionCfg);
        }
    }

    public void validateRefs() {
        EList resourceRefs;
        EList ejblocalRefs;
        EList ejbRefs = this.webDD.getEjbRefs();
        if (!ejbRefs.isEmpty()) {
            this.validateEJBRefs((List)ejbRefs);
        }
        if (!(ejblocalRefs = this.webDD.getEjbLocalRefs()).isEmpty()) {
            this.validateEJBLocalRefs((List)ejblocalRefs);
        }
        if (!(resourceRefs = this.webDD.getResourceRefs()).isEmpty()) {
            int numRefs = resourceRefs.size();
            HashSet<String> refSet = new HashSet<String>(numRefs);
            boolean isVersion22 = this.warFile.getDeploymentDescriptor().getVersionID() <= 22;
            int refNo = 0;
            while (refNo < numRefs) {
                String[] parms;
                ResourceRefImpl ref;
                String auth;
                if (this._reporter.isCancelled()) {
                    String msg = ResourceHandler.getExternalizedMessage((String)"VBF_STATUS_VALIDATOR_TERMINATED");
                    this.status = WTPCommonPlugin.createCancelStatus((String)msg);
                }
                if ((auth = (ref = (ResourceRefImpl)resourceRefs.get(refNo)).getAuth().getName()) == null || !ref.isSetAuth()) {
                    parms = new String[]{ref.getName()};
                    String msgId = isVersion22 ? "MESSAGE_WAR_VALIDATION_RES_AUTH_REQUIRED_22" : "MESSAGE_WAR_VALIDATION_RES_AUTH_REQUIRED_23";
                    this.addError("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", msgId, parms, ref);
                } else if (isVersion22 && auth.equals("Application")) {
                    parms = new String[]{ref.getName()};
                    this.addError("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_RES_AUTH_INVALID_22", parms, ref);
                } else if (!isVersion22 && auth.equals("SERVLET")) {
                    parms = new String[]{ref.getName()};
                    this.addError("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_RES_AUTH_INVALID_23", parms, ref);
                }
                String sharingScope = ref.getResSharingScope().getName();
                if (!(isVersion22 || sharingScope != null && ref.isSetResSharingScope())) {
                    String[] parms2 = new String[]{};
                    this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_RES_SHARING_SCOPE", parms2, ref);
                }
                String refName = ref.getName();
                String[] parms3 = new String[]{refName};
                if (!refSet.add(refName)) {
                    this.addError("org.eclipse.jst.j2ee.core.internal.plugin.erefvalidation", "ERROR_EAR_DUPLICATE_RESREF", parms3, ref);
                }
                ++refNo;
            }
        }
    }

    protected void validateAuthSecRole(String link, String role, Hashtable definedRoles, EObject targetObject) {
        String rName = role;
        String lName = link;
        if (rName != null) {
            rName = rName.trim();
        }
        if (lName != null) {
            lName = lName.trim();
        }
        if (rName != null && !rName.equals("*") && !rName.equals("") && definedRoles.get(rName) == null && definedRoles.get(lName) == null) {
            String[] parms = new String[]{rName};
            this.addError("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_SEC_ROLE_NAME", parms, targetObject);
        }
    }

    protected void validateSecRole(String link, String role, Hashtable definedRoles, EObject targetObject) {
        String[] parms;
        String rName = role;
        String lName = link;
        if (rName != null) {
            rName = rName.trim();
        }
        if (lName != null) {
            lName = lName.trim();
        }
        if (rName == null || rName.equals("")) {
            parms = new String[]{rName};
            this.addError("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_SEC_ROLE_NAME", parms, targetObject);
        }
        if (!(rName != null && rName.equals("*") || lName == null || definedRoles.get(lName) != null)) {
            parms = new String[]{lName};
            this.addError("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_SEC_ROLE", parms, targetObject);
        }
    }

    public void validateSecurityAndServlets() {
        EARFile module;
        EList webRoles = this.webDD.getSecurityRoles();
        Hashtable secRoles = this.getAndValidateSecurityRoles(webRoles);
        this.validateServlets(this.webDD.getServlets(), secRoles);
        this.validateSecurityConstraints(this.webDD.getConstraints(), secRoles);
        if (!webRoles.isEmpty() && (module = this.warFile.getEARFile()) != null) {
            EList earRoleList = module.getDeploymentDescriptor().getSecurityRoles();
            this.validateWEBRolesWithEARRoles(earRoleList, webRoles);
        }
    }

    public void validateSecurityConstraints(EList constraints, Hashtable secRoles) {
        if (constraints.isEmpty()) {
            return;
        }
        Iterator constList = constraints.iterator();
        while (constList.hasNext()) {
            TransportGuaranteeType transport;
            UserDataConstraint dataConstraint;
            SecurityConstraint constraint;
            EList webResourceList;
            if (this._reporter.isCancelled()) {
                String msg = ResourceHandler.getExternalizedMessage((String)"VBF_STATUS_VALIDATOR_TERMINATED");
                this.status = WTPCommonPlugin.createCancelStatus((String)msg);
            }
            if ((webResourceList = (constraint = (SecurityConstraint)constList.next()).getWebResourceCollections()) == null || webResourceList.isEmpty()) {
                String[] parms = new String[]{WARValidationResourceHandler.of_Type_Web_Resource_Collection_64};
                this.addError("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, constraint);
                continue;
            }
            this.validateWebResourceCollections(webResourceList);
            AuthConstraint authConstraint = constraint.getAuthConstraint();
            if (authConstraint != null) {
                this.validateAuthConstraint(authConstraint, secRoles);
            }
            if ((dataConstraint = constraint.getUserDataConstraint()) == null || dataConstraint.getTransportGuarantee() == null || (transport = dataConstraint.getTransportGuarantee()) != null && dataConstraint.isSetTransportGuarantee()) continue;
            this.addError("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_TRANSPORT", new String[0], dataConstraint);
        }
    }

    public void validateFilters(EList filterList) {
        if (filterList.isEmpty()) {
            return;
        }
        Iterator filters = filterList.iterator();
        Hashtable<String, String> remember = new Hashtable<String, String>();
        while (filters.hasNext()) {
            String[] parms;
            Filter nextFilter;
            String name;
            if (this._reporter.isCancelled()) {
                String msg = ResourceHandler.getExternalizedMessage((String)"VBF_STATUS_VALIDATOR_TERMINATED");
                this.status = WTPCommonPlugin.createCancelStatus((String)msg);
            }
            if ((name = (nextFilter = (Filter)filters.next()).getName()) != null) {
                name = name.trim();
            }
            if (name == null || name.equals("")) {
                parms = new String[]{WARValidationResourceHandler.of_Type_Filter_Name_66};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, nextFilter);
                continue;
            }
            if (remember.get(name) != null) {
                parms = new String[]{name};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_FILTER", parms, nextFilter);
                continue;
            }
            remember.put(name, "Yea");
        }
    }

    public void validateFilterMappings(EList filterMappingsList) {
        if (filterMappingsList.isEmpty()) {
            return;
        }
        for (FilterMapping nextMapping : filterMappingsList) {
            String[] parms;
            if (nextMapping.getUrlPattern() != null) {
                String url = nextMapping.getUrlPattern();
                parms = new String[]{url};
                if (url == null) {
                    this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_URL", parms, nextMapping);
                    continue;
                }
                if (nextMapping.getFilter() == null || nextMapping.getFilter().equals("")) {
                    this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_BROKEN_FILTER_MAPPING", parms, nextMapping);
                    continue;
                }
                try {
                    if (!url.equals("")) continue;
                    throw new Exception(WARValidationResourceHandler.Invalid_URL_70);
                }
                catch (Exception exception) {
                    parms = new String[]{nextMapping.getUrlPattern()};
                    this.addError("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_URL", parms, nextMapping);
                }
                continue;
            }
            if (nextMapping.getServletName() == null) continue;
            String servletName = nextMapping.getServletName();
            parms = new String[]{servletName};
            if (nextMapping.getServlet() == null) {
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_BROKEN_SERVLET_MAPPING", parms, nextMapping);
                continue;
            }
            if (nextMapping.getFilter() != null && !nextMapping.getFilter().equals("")) continue;
            this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_BROKEN_FILTER_MAPPING", parms, nextMapping);
        }
    }

    public void validateServletMappings(EList servletMappingsList) {
        if (servletMappingsList.isEmpty()) {
            return;
        }
        Iterator servletMappings = servletMappingsList.iterator();
        Hashtable<String, String> remember = new Hashtable<String, String>();
        while (servletMappings.hasNext()) {
            String[] parms;
            ServletMapping nextMapping;
            String url;
            if (this._reporter.isCancelled()) {
                String msg = ResourceHandler.getExternalizedMessage((String)"VBF_STATUS_VALIDATOR_TERMINATED");
                this.status = WTPCommonPlugin.createCancelStatus((String)msg);
            }
            if ((url = (nextMapping = (ServletMapping)servletMappings.next()).getUrlPattern()) != null) {
                if (remember.get(url = url.trim()) != null) {
                    parms = new String[]{nextMapping.getUrlPattern()};
                    this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_MAPPING", parms, nextMapping);
                    continue;
                }
                remember.put(nextMapping.getUrlPattern(), "Yea");
            }
            if (url == null || nextMapping.getServlet() == null || nextMapping.getServlet().equals("")) {
                parms = new String[]{url};
                if (url == null) {
                    this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_URL", parms, nextMapping);
                    continue;
                }
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_BROKEN_SERVLET_MAPPING", parms, nextMapping);
                continue;
            }
            try {
                if (!url.equals("")) continue;
                throw new Exception(WARValidationResourceHandler.Invalid_URL_75);
            }
            catch (Exception exception) {
                parms = new String[]{nextMapping.getUrlPattern()};
                this.addError("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_URL", parms, nextMapping);
            }
        }
    }

    public void validateServlets(EList servletList, Hashtable secRoles) {
        if (servletList.isEmpty()) {
            return;
        }
        Iterator servlets = servletList.iterator();
        Hashtable<String, String> remember = new Hashtable<String, String>();
        while (servlets.hasNext()) {
            JSPType jspType;
            String jspFileName;
            String[] parms;
            Servlet nextServlet;
            String name;
            if (this._reporter.isCancelled()) {
                String msg = ResourceHandler.getExternalizedMessage((String)"VBF_STATUS_VALIDATOR_TERMINATED");
                this.status = WTPCommonPlugin.createCancelStatus((String)msg);
            }
            if ((name = (nextServlet = (Servlet)servlets.next()).getServletName()) != null) {
                name = name.trim();
            }
            if (name == null || name.equals("")) {
                parms = new String[]{WARValidationResourceHandler.of_Type_Servlet_Name_77};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, nextServlet);
                continue;
            }
            if (remember.get(name) != null) {
                parms = new String[]{name};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_SERVLET", parms, nextServlet);
                continue;
            }
            remember.put(name, "Yea");
            EList rolesList = nextServlet.getSecurityRoleRefs();
            if (!rolesList.isEmpty()) {
                for (SecurityRoleRef role : rolesList) {
                    this.validateSecRole(role.getLink(), role.getName(), secRoles, role);
                }
            }
            if (nextServlet.getWebType() == null || !nextServlet.getWebType().isJspType() || (jspFileName = (jspType = (JSPType)nextServlet.getWebType()).getJspFile()) != null && jspFileName.length() > 0) continue;
            String[] parms2 = new String[]{jspFileName, name};
            this.addError("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_JSPFILE_REF", parms2, nextServlet);
        }
    }

    public void validateTagLibs() {
        if (this.webDD.getTagLibs().isEmpty()) {
            return;
        }
        Iterator tags = this.webDD.getTagLibs().iterator();
        Hashtable<String, String> remember = new Hashtable<String, String>();
        while (tags.hasNext()) {
            String[] parms;
            TagLibRef taglib;
            String uri;
            if (this._reporter.isCancelled()) {
                String msg = ResourceHandler.getExternalizedMessage((String)"VBF_STATUS_VALIDATOR_TERMINATED");
                this.status = WTPCommonPlugin.createCancelStatus((String)msg);
            }
            if ((uri = (taglib = (TagLibRef)tags.next()).getTaglibURI()) != null) {
                uri = uri.trim();
            }
            if (uri == null || uri.equals("")) {
                parms = new String[]{WARValidationResourceHandler.of_Type_Taglib_80};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, taglib);
                continue;
            }
            if (remember.get(uri) != null) {
                parms = new String[]{String.valueOf(WARValidationResourceHandler.of_Type_TagLib___81) + ": " + uri};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", parms, taglib);
                continue;
            }
            remember.put(uri, "Yea");
        }
    }

    public void validateWebResourceCollections(EList webResourceList) {
        for (WebResourceCollection resource : webResourceList) {
            EList httpList;
            String name = resource.getWebResourceName();
            if (name != null) {
                name = name.trim();
            }
            if (name == null || name.equals("")) {
                String[] parms = new String[]{WARValidationResourceHandler.of_Type_Web_Resource_Name_84};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_EMPTY_ENTRY", parms, resource);
            }
            if ((httpList = resource.getHTTPs()).isEmpty()) continue;
            for (HTTPMethodType httpMethod : httpList) {
                String method = httpMethod.getHttpMethod();
                if (method != null && this.isHttpMethod(method)) continue;
                String[] parms = new String[]{method};
                this.addError("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_HTTP_CMD", parms, httpMethod);
            }
        }
    }

    public void validateWelcomeFileList(WelcomeFileList fileList) {
        if (fileList == null) {
            return;
        }
        Iterator files = fileList.getFile().iterator();
        Hashtable<String, String> remember = new Hashtable<String, String>();
        while (files.hasNext()) {
            String[] parms;
            WelcomeFile nextFile;
            String fileName;
            if (this._reporter.isCancelled()) {
                String msg = ResourceHandler.getExternalizedMessage((String)"VBF_STATUS_VALIDATOR_TERMINATED");
                this.status = WTPCommonPlugin.createCancelStatus((String)msg);
            }
            if ((fileName = (nextFile = (WelcomeFile)files.next()).getWelcomeFile()) == null || fileName.length() == 0) {
                parms = new String[]{};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_NO_WELCOME_FILE", parms, nextFile);
            } else if (fileName.startsWith("/") || fileName.endsWith("/")) {
                parms = new String[]{};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_INVALID_WELCOME_FILE", parms, nextFile);
            }
            if (fileName != null) {
                fileName = fileName.trim();
            }
            if (remember.get(fileName) != null) {
                parms = new String[]{String.valueOf(WARValidationResourceHandler.of_Type_Welcome_File_Name__87) + ": " + fileName};
                this.addWarning("org.eclipse.jst.j2ee.model.internal.validation.warvalidation", "MESSAGE_WAR_VALIDATION_DUPLICATE_ENTRY", parms, nextFile);
                continue;
            }
            remember.put(fileName, "Yea");
        }
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        this._helper = helper;
        return null;
    }

    @Override
    public void cleanup(IReporter reporter) {
        this.warFile = null;
        this.webDD = null;
        this.httpMethods = null;
        super.cleanup(reporter);
    }
}

