/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.javaee.internal.adapter;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.core.internal.plugin.J2EECorePlugin;

public abstract class JavaEEArtifactAdapterFactory
implements IAdapterFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IJavaElement.class) {
            IJavaProject javaProject = this.getJavaProject(adaptableObject);
            String className = this.getFullyQualifiedClassName(adaptableObject);
            return this.getJavaElement(javaProject, className);
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IJavaElement.class};
    }

    protected abstract String getFullyQualifiedClassName(Object var1);

    private IJavaProject getJavaProject(Object adaptableObject) {
        IResource resource = this.getResource(adaptableObject);
        if (resource != null) {
            IProject project = resource.getProject();
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    private IResource getResource(Object adaptableObject) {
        if (adaptableObject instanceof IAdaptable) {
            return (IResource)((IAdaptable)adaptableObject).getAdapter(IResource.class);
        }
        return (IResource)Platform.getAdapterManager().getAdapter(adaptableObject, IResource.class);
    }

    private IJavaElement getJavaElement(IJavaProject javaProject, String className) {
        if (className != null && javaProject != null && javaProject.exists()) {
            try {
                return javaProject.findType(className);
            }
            catch (JavaModelException e) {
                J2EECorePlugin.logError((CoreException)((Object)e));
            }
        }
        return null;
    }
}

