/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMNode;
import org.eclipse.wst.css.core.internal.metamodel.util.CSSMetaModelUtil;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclaration;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.ui.internal.contentassist.CSSCACandidate;
import org.eclipse.wst.css.ui.internal.contentassist.CSSContentAssistContext;
import org.eclipse.wst.css.ui.internal.contentassist.CSSProposalGenerator;
import org.eclipse.wst.css.ui.internal.image.CSSImageType;
import org.w3c.dom.css.CSSFontFaceRule;

class CSSProposalGeneratorForDeclarationName
extends CSSProposalGenerator {
    CSSProposalGeneratorForDeclarationName(CSSContentAssistContext context) {
        super(context);
    }

    @Override
    protected Iterator getCandidates() {
        ArrayList<CSSCACandidate> candidates = new ArrayList<CSSCACandidate>();
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        Object preDelim = "";
        int i = 0;
        while (i < preferences.getInt("preDelim")) {
            preDelim = (String)preDelim + " ";
            ++i;
        }
        Object postDelim = "";
        int i2 = 0;
        while (i2 < preferences.getInt("postDelim")) {
            postDelim = (String)postDelim + " ";
            ++i2;
        }
        ICSSNode targetNode = this.fContext.getTargetNode();
        boolean bFontRule = false;
        ICSSNode node = targetNode;
        while (node != null) {
            if (node instanceof CSSFontFaceRule) {
                bFontRule = true;
                break;
            }
            node = node.getParentNode();
        }
        ArrayList<CSSMMNode> names = new ArrayList<CSSMMNode>();
        CSSMetaModelUtil util = new CSSMetaModelUtil(this.fContext.getMetaModel());
        Iterator iNames = util.collectNodesByType(bFontRule ? "CSSMM.Descriptor" : "CSSMM.Property");
        while (iNames.hasNext()) {
            CSSMMNode node2 = (CSSMMNode)iNames.next();
            names.add(node2);
        }
        this.sortNames(names);
        boolean bAddColon = true;
        if ((targetNode instanceof ICSSStyleRule || targetNode instanceof ICSSStyleDeclItem || targetNode instanceof ICSSStyleDeclaration) && this.fContext.targetHas("DECLARATION_SEPARATOR")) {
            bAddColon = false;
        }
        for (CSSMMNode node3 : names) {
            String text = node3.getName();
            String string = text = preferences.getInt("propNameCase") == 2 ? text.toUpperCase() : text.toLowerCase();
            if (!this.isMatch(text)) continue;
            int cursorPos = 0;
            StringBuffer buf = new StringBuffer();
            buf.append(text);
            buf.append((String)preDelim);
            cursorPos = buf.length();
            if (bAddColon) {
                buf.append(':');
                buf.append((String)postDelim);
                cursorPos += 1 + ((String)postDelim).length();
            }
            CSSCACandidate item = new CSSCACandidate();
            item.setReplacementString(buf.toString());
            item.setCursorPosition(cursorPos);
            item.setDisplayString(text);
            item.setMMNode(node3);
            item.setImageType(this.getCategoryImageType(node3));
            candidates.add(item);
        }
        return candidates.iterator();
    }

    void sortNames(List names) {
        Collections.sort(names, new Comparator(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public int compare(Object o1, Object o2) {
                CSSMMNode node1 = (CSSMMNode)o1;
                CSSMMNode node2 = (CSSMMNode)o2;
                if (node1 == null) {
                    return 1;
                }
                if (node2 == null) {
                    return -1;
                }
                int diff = 0;
                String category1 = node1.getAttribute("category");
                String category2 = node2.getAttribute("category");
                if (category1 == null) {
                    if (category2 != null) return 1;
                    diff = 0;
                } else {
                    if (category2 == null) {
                        return -1;
                    }
                    diff = category1.compareTo(category2);
                }
                if (diff != 0) return diff;
                String name = node1.getName();
                if (name != null) return name.compareTo(node2.getName());
                return 1;
            }
        });
    }

    CSSImageType getCategoryImageType(CSSMMNode node) {
        String category;
        CSSImageType imageType = null;
        if (node != null && (category = node.getAttribute("category")) != null) {
            imageType = CSSImageType.getImageType(category);
        }
        return imageType == null ? CSSImageType.CATEGORY_DEFAULT : imageType;
    }
}

