/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.dtd.participants;

import java.util.HashMap;
import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DTDDeclNode;
import org.eclipse.lemminx.extensions.dtd.utils.DTDUtils;
import org.eclipse.lemminx.services.extensions.codelens.ICodeLensParticipant;
import org.eclipse.lemminx.services.extensions.codelens.ICodeLensRequest;
import org.eclipse.lemminx.services.extensions.codelens.ReferenceCommand;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class DTDCodeLensParticipant
implements ICodeLensParticipant {
    @Override
    public void doCodeLens(ICodeLensRequest request, List<CodeLens> lenses, CancelChecker cancelChecker) {
        DOMDocument xmlDocument = request.getDocument();
        if (!DOMUtils.isDTD(xmlDocument.getDocumentURI()) && !xmlDocument.hasDTD()) {
            return;
        }
        boolean supportedByClient = request.isSupportedByClient("references");
        HashMap cache = new HashMap();
        DTDUtils.searchDTDOriginElementDecls(xmlDocument.getDoctype(), (origin, target) -> {
            DTDDeclNode targetElement = target.getOwnerNode();
            if (targetElement.isDTDElementDecl()) {
                CodeLens codeLens = (CodeLens)cache.get(targetElement);
                if (codeLens == null) {
                    Range range = XMLPositionUtility.createRange(target);
                    codeLens = new CodeLens(range);
                    codeLens.setCommand(new ReferenceCommand(xmlDocument.getDocumentURI(), range.getStart(), supportedByClient));
                    cache.put(targetElement, codeLens);
                    lenses.add(codeLens);
                } else {
                    ((ReferenceCommand)codeLens.getCommand()).increment();
                }
            }
        }, cancelChecker);
    }
}

