/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.signing.ssh;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;
import org.eclipse.jgit.internal.signing.ssh.AllowedSigners;
import org.eclipse.jgit.internal.signing.ssh.OpenSshBinaryKrl;
import org.eclipse.jgit.util.IO;

class OpenSshKrl
extends ModifiableFileWatcher {
    private State state = new State(Set.of(), null);

    public OpenSshKrl(Path path) {
        super(path);
    }

    public boolean isRevoked(PublicKey key) throws IOException {
        State current = this.refresh();
        return this.isRevoked(current, key);
    }

    private boolean isRevoked(State current, PublicKey key) {
        if (key instanceof OpenSshCertificate) {
            OpenSshCertificate cert = (OpenSshCertificate)key;
            OpenSshBinaryKrl krl = current.krl();
            if (krl != null && krl.isRevoked((PublicKey)cert)) {
                return true;
            }
            return this.isRevoked(current, cert.getCaPubKey()) || this.isRevoked(current, cert.getCertPubKey());
        }
        OpenSshBinaryKrl krl = current.krl();
        if (krl != null) {
            return krl.isRevoked(key);
        }
        return current.keys().contains(PublicKeyEntry.toString((PublicKey)key));
    }

    private synchronized State refresh() throws IOException {
        if (this.checkReloadRequired()) {
            this.updateReloadAttributes();
            try {
                this.state = OpenSshKrl.reload(this.getPath());
            }
            catch (NoSuchFileException e) {
                this.resetReloadAttributes();
                this.state = new State(Set.of(), null);
            }
        }
        return this.state;
    }

    private static State reload(Path path) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            byte[] magic = new byte[OpenSshBinaryKrl.MAGIC.length];
            in.mark(magic.length);
            IO.readFully((InputStream)in, (byte[])magic);
            if (Arrays.equals(magic, OpenSshBinaryKrl.MAGIC)) {
                return new State(null, OpenSshBinaryKrl.load(in, true));
            }
            in.reset();
            return OpenSshKrl.loadTextKrl(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static State loadTextKrl(InputStream in) throws IOException {
        HashSet<String> keys = new HashSet<String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line;
            while ((line = r.readLine()) != null) {
                if ((line = line.strip()).isEmpty() || line.charAt(0) == '#') continue;
                keys.add(AllowedSigners.parsePublicKey(line, 0));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new State(keys, null);
    }

    private record State(Set<String> keys, OpenSshBinaryKrl krl) {
    }
}

