/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfigurationConstants;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class JUnitLaunchRequirements {
    private static final StateObjectFactory FACTORY = BundleHelper.getPlatformAdmin().getFactory();
    private static final String PDE_JUNIT_RUNTIME = "org.eclipse.pde.junit.runtime";
    private static final String JUNIT4_JDT_RUNTIME_PLUGIN = "org.eclipse.jdt.junit4.runtime";
    private static final String JUNIT5_JDT_RUNTIME_PLUGIN = "org.eclipse.jdt.junit5.runtime";
    private static final String JUNIT6_JDT_RUNTIME_PLUGIN = "org.eclipse.jdt.junit6.runtime";

    public static void addRequiredJunitRuntimePlugins(ILaunchConfiguration configuration, Map<String, List<IPluginModelBase>> collectedModels, Map<IPluginModelBase, String> startLevelMap) throws CoreException {
        Collection<IPluginModelBase> runtimeBundles = JUnitLaunchRequirements.getEclipseJunitRuntimePlugins(configuration, collectedModels, startLevelMap);
        List<BundleDescription> roots = JUnitLaunchRequirements.modelsAsDescriptions(runtimeBundles).toList();
        List<BundleDescription> bundles = Stream.concat(DependencyManager.findRequirementsClosure(roots, (DependencyManager.Options[])new DependencyManager.Options[0]).stream(), collectedModels.values().stream().flatMap(pl -> JUnitLaunchRequirements.modelsAsDescriptions(pl))).distinct().toList();
        Collection<BundleDescription> runtimeRequirements = JUnitLaunchRequirements.filterRequirementsByState(bundles, runtimeBundles, configuration);
        JUnitLaunchRequirements.addAbsentRequirements(runtimeRequirements, collectedModels, startLevelMap);
    }

    private static Collection<BundleDescription> filterRequirementsByState(Collection<BundleDescription> bundles, Collection<IPluginModelBase> rootBundles, ILaunchConfiguration configuration) throws CoreException {
        final IdentityHashMap<BundleDescription, BundleDescription> descriptionnMap = new IdentityHashMap<BundleDescription, BundleDescription>();
        Set rootSet = JUnitLaunchRequirements.modelsAsDescriptions(rootBundles).collect(Collectors.toSet());
        State state = FACTORY.createState(true);
        final State targetState = PDECore.getDefault().getModelManager().getState().getState();
        ArrayList<BundleDescription> resolveRoots = new ArrayList<BundleDescription>();
        long id = 1L;
        for (BundleDescription bundle : bundles) {
            BundleDescription copy = FACTORY.createBundleDescription(id++, bundle);
            descriptionnMap.put(copy, bundle);
            state.addBundle(copy);
            if (!rootSet.contains(bundle)) continue;
            resolveRoots.add(copy);
        }
        state.setPlatformProperties(targetState.getPlatformProperties());
        state.setResolverHookFactory(new ResolverHookFactory(){

            public ResolverHook begin(Collection<BundleRevision> triggers) {
                return new ResolverHook(){

                    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
                    }

                    public void filterResolvable(Collection<BundleRevision> candidates) {
                    }

                    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
                        boolean optional = JUnitLaunchRequirements.isOptional((Requirement)requirement);
                        if (candidates.size() == 1 && !optional) {
                            return;
                        }
                        List<BundleCapability> list = candidates.stream().filter(cp -> this.isFromDifferentState((BundleCapability)cp)).toList();
                        if (list.isEmpty()) {
                            return;
                        }
                        int i = list.size() - 1;
                        while (i >= 0 && (optional || candidates.size() > 1)) {
                            BundleCapability capability = list.get(i);
                            candidates.remove(capability);
                            --i;
                        }
                    }

                    private boolean isFromDifferentState(BundleCapability capability) {
                        BundleRevision resource = capability.getResource();
                        BundleDescription original = (BundleDescription)descriptionnMap.get(resource);
                        if (original != null) {
                            return original.getContainingState() != targetState;
                        }
                        return false;
                    }

                    public void end() {
                    }
                };
            }
        });
        state.resolve(false);
        for (BundleDescription rootBundle : resolveRoots) {
            Object[] errors = state.getResolverErrors(rootBundle);
            if (errors.length <= 0) continue;
            throw new CoreException(Status.error((String)String.format("%s can not be resolved: %s", rootBundle, Arrays.toString(errors))));
        }
        Set closure = DependencyManager.findRequirementsClosure(resolveRoots, (DependencyManager.Options[])new DependencyManager.Options[0]);
        return closure.stream().map(bd -> (BundleDescription)descriptionnMap.get(bd)).filter(Objects::nonNull).toList();
    }

    public static Collection<String> getRequiredJunitRuntimeEclipsePlugins(ILaunchConfiguration configuration) {
        ITestKind testKind = JUnitLaunchConfigurationConstants.getTestRunnerKind((ILaunchConfiguration)configuration);
        if (testKind.isNull()) {
            return List.of();
        }
        switch (testKind.getId()) {
            case "org.eclipse.jdt.junit.loader.junit3": {
                return List.of(PDE_JUNIT_RUNTIME);
            }
            case "org.eclipse.jdt.junit.loader.junit4": {
                return List.of(PDE_JUNIT_RUNTIME, JUNIT4_JDT_RUNTIME_PLUGIN);
            }
            case "org.eclipse.jdt.junit.loader.junit5": {
                return List.of(PDE_JUNIT_RUNTIME, JUNIT5_JDT_RUNTIME_PLUGIN);
            }
            case "org.eclipse.jdt.junit.loader.junit6": {
                return List.of(PDE_JUNIT_RUNTIME, JUNIT6_JDT_RUNTIME_PLUGIN);
            }
        }
        throw new IllegalArgumentException("Unsupported junit test kind: " + testKind.getId());
    }

    private static Collection<IPluginModelBase> getEclipseJunitRuntimePlugins(ILaunchConfiguration configuration, Map<String, List<IPluginModelBase>> collectedModels, Map<IPluginModelBase, String> startLevelMap) throws CoreException {
        LinkedHashSet<IPluginModelBase> descriptions = new LinkedHashSet<IPluginModelBase>();
        for (String id : JUnitLaunchRequirements.getRequiredJunitRuntimeEclipsePlugins(configuration)) {
            JUnitLaunchRequirements.addIfAbsent(id, collectedModels, startLevelMap).ifPresent(descriptions::add);
        }
        return descriptions;
    }

    private static Optional<IPluginModelBase> addIfAbsent(String id, Map<String, List<IPluginModelBase>> collectedModels, Map<IPluginModelBase, String> startLevelMap) throws CoreException {
        List models = collectedModels.computeIfAbsent(id, k -> new ArrayList());
        if (models.stream().noneMatch(m -> m.getBundleDescription().isResolved())) {
            IPluginModelBase model = JUnitLaunchRequirements.findRequiredPluginInTargetOrHost(PluginRegistry.findModel((String)id), plugins -> plugins.max(PDECore.VERSION), id);
            models.add(model);
            BundleLauncherHelper.addDefaultStartingBundle(startLevelMap, model);
            return Optional.of(model);
        }
        return models.stream().filter(m -> m.getBundleDescription().isResolved()).findFirst();
    }

    private static void addAbsentRequirements(Collection<BundleDescription> requirements, Map<String, List<IPluginModelBase>> collectedModels, Map<IPluginModelBase, String> startLevelMap) throws CoreException {
        for (BundleRevision bundleRevision : requirements) {
            String id = bundleRevision.getSymbolicName();
            List models = collectedModels.computeIfAbsent(id, k -> new ArrayList());
            if (!models.stream().map(IPluginModelBase::getBundleDescription).noneMatch(b -> b.isResolved() && b.getVersion().equals((Object)bundle.getVersion()))) continue;
            IPluginModelBase model = JUnitLaunchRequirements.findRequiredPluginInTargetOrHost(PluginRegistry.findModel((Resource)bundleRevision), plgs -> plgs.filter(p -> p.getBundleDescription() == bundle).findFirst(), id);
            models.add(model);
            BundleLauncherHelper.addDefaultStartingBundle(startLevelMap, model);
        }
    }

    private static IPluginModelBase findRequiredPluginInTargetOrHost(IPluginModelBase model, Function<Stream<IPluginModelBase>, Optional<IPluginModelBase>> pluginSelector, String id) throws CoreException {
        if (model == null || !model.getBundleDescription().isResolved()) {
            model = pluginSelector.apply(PDECore.getDefault().findPluginsInHost(id)).orElseThrow(() -> new CoreException(Status.error((String)NLS.bind((String)PDEMessages.JUnitLaunchConfiguration_error_missingPlugin, (Object)id))));
        }
        return model;
    }

    private static Stream<BundleDescription> modelsAsDescriptions(Collection<IPluginModelBase> runtimeBundles) {
        return runtimeBundles.stream().map(p -> p.getBundleDescription()).filter(Objects::nonNull);
    }

    private static boolean isOptional(Requirement req) {
        String resolution = (String)req.getDirectives().get("resolution");
        return "optional".equalsIgnoreCase(resolution);
    }
}

