/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.jsfappconfig;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsf.core.jsfappconfig.AbstractJSFAppConfigProvider;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ArtifactEditJSFAppConfigProvider
extends AbstractJSFAppConfigProvider {
    protected IFile appConfigFile = null;
    protected FacesConfigArtifactEdit facesConfigArtifactEdit = null;
    protected FacesConfigType facesConfig = null;

    public ArtifactEditJSFAppConfigProvider(IFile appConfigFile) {
        this.appConfigFile = appConfigFile;
    }

    @Override
    public FacesConfigType getFacesConfigModel() {
        if (this.facesConfig == null && this.appConfigFile != null) {
            IProject project = this.appConfigFile.getProject();
            IPath appConfigFilePath = JSFAppConfigUtils.getWebContentFolderRelativePath(this.appConfigFile);
            if (appConfigFilePath != null) {
                this.facesConfigArtifactEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)project, (String)appConfigFilePath.toString());
                if (this.facesConfigArtifactEdit != null) {
                    this.facesConfig = this.facesConfigArtifactEdit.getFacesConfig();
                    if (this.facesConfig != null) {
                        this.jsfAppConfigLocater.getJSFAppConfigManager().addFacesConfigChangeAdapter(this.facesConfig);
                    }
                }
            }
        }
        return this.facesConfig;
    }

    @Override
    public void releaseFacesConfigModel() {
        if (this.jsfAppConfigLocater != null) {
            this.jsfAppConfigLocater.getJSFAppConfigManager().removeFacesConfigChangeAdapter(this.facesConfig);
        }
        if (this.facesConfigArtifactEdit != null) {
            this.facesConfigArtifactEdit.dispose();
            this.facesConfigArtifactEdit = null;
        }
        this.facesConfig = null;
    }

    public boolean equals(Object otherObject) {
        boolean equals = false;
        if (otherObject instanceof ArtifactEditJSFAppConfigProvider) {
            IFile otherAppConfigFile = ((ArtifactEditJSFAppConfigProvider)otherObject).appConfigFile;
            equals = this.appConfigFile != null ? this.appConfigFile.equals((Object)otherAppConfigFile) : otherAppConfigFile == null;
        }
        return equals;
    }

    public int hashCode() {
        return this.appConfigFile != null ? this.appConfigFile.hashCode() : 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ArtifactEditJSFAppConfigProvider[");
        if (this.appConfigFile != null) {
            sb.append(this.appConfigFile.toString());
        } else {
            sb.append("null");
        }
        sb.append("]");
        return sb.toString();
    }

    protected void finalize() {
        this.releaseFacesConfigModel();
    }
}

