/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.ArrayDeque;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.SpanningTreeVisitor;

class RankAssignmentSolver
extends SpanningTreeVisitor {
    DirectedGraph graph;
    EdgeList spanningTree;
    boolean searchDirection;

    RankAssignmentSolver() {
    }

    int depthFirstCutValue(Edge edge, int count) {
        Node n = this.getTreeTail(edge);
        this.setTreeMin(n, count);
        int cutvalue = 0;
        int multiplier = edge.target == n ? 1 : -1;
        for (Edge e : n.outgoing) {
            if (e.tree && e != edge) {
                count = this.depthFirstCutValue(e, count);
                cutvalue += (e.cut - e.weight) * multiplier;
                continue;
            }
            cutvalue -= e.weight * multiplier;
        }
        for (Edge e : n.incoming) {
            if (e.tree && e != edge) {
                count = this.depthFirstCutValue(e, count);
                cutvalue -= (e.cut - e.weight) * multiplier;
                continue;
            }
            cutvalue += e.weight * multiplier;
        }
        edge.cut = cutvalue;
        if (cutvalue < 0) {
            this.spanningTree.add(edge);
        }
        this.setTreeMax(n, count);
        return count + 1;
    }

    Edge enter(Node branch) {
        Edge result = null;
        int minSlack = Integer.MAX_VALUE;
        boolean incoming = this.getParentEdge((Node)branch).target != branch;
        int i = 0;
        while (i < this.graph.nodes.size()) {
            Node n = this.searchDirection ? (Node)this.graph.nodes.get(i) : (Node)this.graph.nodes.get(this.graph.nodes.size() - 1 - i);
            if (this.subtreeContains(branch, n)) {
                EdgeList edges = incoming ? n.incoming : n.outgoing;
                for (Edge e : edges) {
                    if (this.subtreeContains(branch, e.opposite(n)) || e.tree || e.getSlack() >= minSlack) continue;
                    result = e;
                    minSlack = e.getSlack();
                }
            }
            ++i;
        }
        return result;
    }

    int getTreeMax(Node n) {
        return n.workingInts[1];
    }

    int getTreeMin(Node n) {
        return n.workingInts[0];
    }

    void initCutValues() {
        Node root = (Node)this.graph.nodes.get(0);
        this.spanningTree = new EdgeList();
        this.setTreeMin(root, 1);
        this.setTreeMax(root, 1);
        for (Edge e : root.outgoing) {
            if (!this.getSpanningTreeChildren(root).contains(e)) continue;
            this.setTreeMax(root, this.depthFirstCutValue(e, this.getTreeMax(root)));
        }
        for (Edge e : root.incoming) {
            if (!this.getSpanningTreeChildren(root).contains(e)) continue;
            this.setTreeMax(root, this.depthFirstCutValue(e, this.getTreeMax(root)));
        }
    }

    Edge leave() {
        Edge result = null;
        int minCut = 0;
        int weight = -1;
        for (Edge e : this.spanningTree) {
            if (e.cut < minCut) {
                result = e;
                minCut = result.cut;
                weight = result.weight;
                continue;
            }
            if (e.cut != minCut || e.weight <= weight) continue;
            result = e;
            weight = result.weight;
        }
        return result;
    }

    void networkSimplexLoop() {
        Edge leave;
        int count = 0;
        while ((leave = this.leave()) != null && count < 900) {
            ++count;
            Node leaveTail = this.getTreeTail(leave);
            Node leaveHead = this.getTreeHead(leave);
            Edge enter = this.enter(leaveTail);
            if (enter == null) break;
            this.getSpanningTreeChildren(leaveHead).remove(leave);
            this.setParentEdge(leaveTail, null);
            leave.tree = false;
            this.spanningTree.remove(leave);
            Node enterTail = enter.source;
            if (!this.subtreeContains(leaveTail, enterTail)) {
                enterTail = enter.target;
            }
            Node enterHead = enter.opposite(enterTail);
            this.updateSubgraph(enterTail);
            this.getSpanningTreeChildren(enterHead).add(enter);
            this.setParentEdge(enterTail, enter);
            enter.tree = true;
            this.repairCutValues(enter);
            Node commonAncestor = enterHead;
            while (!this.subtreeContains(commonAncestor, leaveHead)) {
                this.repairCutValues(this.getParentEdge(commonAncestor));
                commonAncestor = this.getTreeParent(commonAncestor);
            }
            while (leaveHead != commonAncestor) {
                this.repairCutValues(this.getParentEdge(leaveHead));
                leaveHead = this.getTreeParent(leaveHead);
            }
            this.updateMinMax(commonAncestor, this.getTreeMin(commonAncestor));
            this.tightenEdge(enter);
        }
    }

    void repairCutValues(Edge edge) {
        this.spanningTree.remove(edge);
        Node n = this.getTreeTail(edge);
        int cutvalue = 0;
        int multiplier = edge.target == n ? 1 : -1;
        for (Edge e : n.outgoing) {
            if (e.tree && e != edge) {
                cutvalue += (e.cut - e.weight) * multiplier;
                continue;
            }
            cutvalue -= e.weight * multiplier;
        }
        for (Edge e : n.incoming) {
            if (e.tree && e != edge) {
                cutvalue -= (e.cut - e.weight) * multiplier;
                continue;
            }
            cutvalue += e.weight * multiplier;
        }
        edge.cut = cutvalue;
        if (cutvalue < 0) {
            this.spanningTree.add(edge);
        }
    }

    void setTreeMax(Node n, int value) {
        n.workingInts[1] = value;
    }

    void setTreeMin(Node n, int value) {
        n.workingInts[0] = value;
    }

    boolean subtreeContains(Node parent, Node child) {
        return parent.workingInts[0] <= child.workingInts[1] && child.workingInts[1] <= parent.workingInts[1];
    }

    void tightenEdge(Edge edge) {
        Node tail = this.getTreeTail(edge);
        int delta = edge.getSlack();
        if (tail == edge.target) {
            delta = -delta;
        }
        for (Node n : this.graph.nodes) {
            if (!this.subtreeContains(tail, n)) continue;
            n.rank += delta;
        }
    }

    int updateMinMax(Node root, int count) {
        this.setTreeMin(root, count);
        for (Edge e : this.getSpanningTreeChildren(root)) {
            count = this.updateMinMax(this.getTreeTail(e), count);
        }
        this.setTreeMax(root, count);
        return count + 1;
    }

    void updateSubgraph(Node root) {
        Edge flip = this.getParentEdge(root);
        if (flip != null) {
            Node rootParent = this.getTreeParent(root);
            this.getSpanningTreeChildren(rootParent).remove(flip);
            this.updateSubgraph(rootParent);
            this.setParentEdge(root, null);
            this.setParentEdge(rootParent, flip);
            this.repairCutValues(flip);
            this.getSpanningTreeChildren(root).add(flip);
        }
    }

    @Override
    public void visit(DirectedGraph graph) {
        this.graph = graph;
        this.initCutValues();
        this.networkSimplexLoop();
        if (graph.forestRoot == null) {
            graph.nodes.normalizeRanks();
        } else {
            this.normalizeForest();
        }
    }

    private void normalizeForest() {
        NodeList tree = new NodeList();
        this.graph.nodes.resetFlags();
        this.graph.forestRoot.flag = true;
        EdgeList rootEdges = this.graph.forestRoot.outgoing;
        ArrayDeque<Node> stack = new ArrayDeque<Node>();
        for (Edge e : rootEdges) {
            Node node = e.target;
            node.flag = true;
            stack.push(node);
            while (!stack.isEmpty()) {
                node = (Node)stack.pop();
                tree.add(node);
                node.iteratorNeighbors().forEachRemaining(neighbor -> {
                    if (!neighbor.flag) {
                        neighbor.flag = true;
                        stack.push((Node)neighbor);
                    }
                });
            }
            tree.normalizeRanks();
            tree.clear();
        }
    }
}

