/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.wizards;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.wizards.ApiBaselineWizardPage;
import org.eclipse.pde.api.tools.ui.internal.wizards.DirectoryBasedApiBaselineWizardPage;
import org.eclipse.pde.api.tools.ui.internal.wizards.SelectApiBaselineTypeWizardPage;
import org.eclipse.pde.api.tools.ui.internal.wizards.TargetBasedApiBaselineWizardPage;
import org.eclipse.pde.api.tools.ui.internal.wizards.WizardMessages;

public class ApiBaselineWizard
extends Wizard {
    private IApiBaseline profile = null;
    private boolean content = false;

    public ApiBaselineWizard(IApiBaseline profile) {
        this.profile = profile;
        if (profile == null) {
            this.setWindowTitle(WizardMessages.ApiProfileWizard_0);
        } else {
            this.setWindowTitle(WizardMessages.ApiProfileWizard_1);
        }
        this.setNeedsProgressMonitor(true);
    }

    public IApiBaseline getProfile() {
        return this.profile;
    }

    public boolean contentChanged() {
        return this.content;
    }

    public void addPages() {
        if (this.profile != null) {
            this.profile.getApiComponents();
            if (TargetBasedApiBaselineWizardPage.isApplicable(this.profile)) {
                this.addPage((IWizardPage)new TargetBasedApiBaselineWizardPage(this.profile));
            } else {
                this.addPage((IWizardPage)new DirectoryBasedApiBaselineWizardPage(this.profile));
            }
        } else {
            this.setForcePreviousAndNextButtons(true);
            this.addPage((IWizardPage)new SelectApiBaselineTypeWizardPage());
        }
    }

    public boolean canFinish() {
        return super.canFinish() && this.getApiBaselineWizardPage() != null;
    }

    private ApiBaselineWizardPage getApiBaselineWizardPage() {
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page instanceof ApiBaselineWizardPage) {
            return (ApiBaselineWizardPage)page;
        }
        return null;
    }

    public boolean performFinish() {
        try {
            ApiBaselineWizardPage page = this.getApiBaselineWizardPage();
            if (page != null) {
                this.profile = page.finish();
                this.content = page.contentChanged();
                return this.profile != null;
            }
            return true;
        }
        catch (IOException | CoreException e) {
            ApiUIPlugin.log(e);
            return false;
        }
    }

    public boolean performCancel() {
        ApiBaselineWizardPage page = this.getApiBaselineWizardPage();
        if (page != null) {
            page.cancel();
        }
        return super.performCancel();
    }
}

