/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.search.DocAndFloatFeatureBuffer;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntsRef;

public final class DocAndScoreAccBuffer {
    private static final double[] EMPTY_DOUBLES = new double[0];
    public int[] docs = IntsRef.EMPTY_INTS;
    public double[] scores = EMPTY_DOUBLES;
    public int size;

    public void growNoCopy(int minSize) {
        if (this.docs.length < minSize) {
            this.docs = ArrayUtil.growNoCopy(this.docs, minSize);
            this.scores = new double[this.docs.length];
        }
    }

    public void grow(int minSize) {
        if (this.docs.length < minSize) {
            this.docs = ArrayUtil.grow(this.docs, minSize);
            this.scores = ArrayUtil.growExact(this.scores, this.docs.length);
        }
    }

    public void copyFrom(DocAndFloatFeatureBuffer buffer) {
        this.growNoCopy(buffer.size);
        System.arraycopy(buffer.docs, 0, this.docs, 0, buffer.size);
        for (int i = 0; i < buffer.size; ++i) {
            this.scores[i] = buffer.features[i];
        }
        this.size = buffer.size;
    }
}

