/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.wizards.JavadocConversionRefactoring;
import org.eclipse.pde.api.tools.ui.internal.wizards.StringFilter;
import org.eclipse.pde.api.tools.ui.internal.wizards.WizardMessages;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.WorkbenchJob;

public class JavadocConversionPage
extends UserInputWizardPage {
    private static final String SETTINGS_SECTION = "JavadocTagConversionWizardPage";
    private static final String SETTINGS_REMOVE_TAGS = "remove_tags";
    Button removetags = null;
    CheckboxTableViewer tableviewer = null;
    HashSet<Object> checkedset = new HashSet();
    UpdateJob updatejob = new UpdateJob();
    StringFilter filter = new StringFilter();
    private Text checkcount = null;

    public JavadocConversionPage() {
        super(WizardMessages.JavadocConversionWizard_0);
        this.setTitle(WizardMessages.JavadocConversionWizard_0);
        this.setDescription(WizardMessages.JavadocConversionPage_convert_tags_to_annotations_description);
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, IApiToolsHelpContextIds.JAVADOC_CONVERSION_WIZARD_PAGE);
        SWTFactory.createWrapLabel(comp, WizardMessages.JavadocConversionPage_select_pjs_to_convert, 1, 100);
        SWTFactory.createVerticalSpacer(comp, 1);
        SWTFactory.createWrapLabel(comp, WizardMessages.ApiToolingSetupWizardPage_6, 1, 50);
        Text text = SWTFactory.createText(comp, 2048, 1);
        text.addModifyListener(e -> {
            this.updatejob.setFilter(text.getText().trim());
            this.updatejob.cancel();
            this.updatejob.schedule();
        });
        text.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            if (e.keyCode == 0x1000002 && this.tableviewer != null) {
                this.tableviewer.getTable().setFocus();
            }
        }));
        SWTFactory.createWrapLabel(comp, WizardMessages.UpdateJavadocTagsWizardPage_8, 1, 50);
        Table table = new Table(comp, 67618);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        table.setLayoutData((Object)gd);
        this.tableviewer = new CheckboxTableViewer(table);
        this.tableviewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.tableviewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        IProject[] input = Util.getApiProjectsMinSourceLevel((String)"1.5");
        if (input == null) {
            this.setMessage(WizardMessages.JavadocConversionPage_0, 2);
        } else {
            this.tableviewer.setInput((Object)input);
        }
        this.tableviewer.setComparator(new ViewerComparator());
        this.tableviewer.addFilter((ViewerFilter)this.filter);
        this.tableviewer.addCheckStateListener(event -> {
            if (event.getChecked()) {
                this.checkedset.add(event.getElement());
            } else {
                this.checkedset.remove(event.getElement());
            }
            this.setPageComplete(this.pageValid());
        });
        Composite bcomp = SWTFactory.createComposite(comp, 3, 1, 771, 0, 0);
        Button button = SWTFactory.createPushButton(bcomp, WizardMessages.UpdateJavadocTagsWizardPage_10, null);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.tableviewer.setAllChecked(true);
            this.checkedset.addAll(Arrays.asList(this.tableviewer.getCheckedElements()));
            this.setPageComplete(this.pageValid());
        }));
        button = SWTFactory.createPushButton(bcomp, WizardMessages.UpdateJavadocTagsWizardPage_11, null);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TableItem[] items;
            this.tableviewer.setAllChecked(false);
            TableItem[] tableItemArray = items = this.tableviewer.getTable().getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                this.checkedset.remove(item.getData());
                ++n2;
            }
            this.setPageComplete(this.pageValid());
        }));
        this.checkcount = SWTFactory.createText(bcomp, 0x800008, 1, 640);
        this.checkcount.setBackground(bcomp.getBackground());
        Object[] selected = this.getWorkbenchSelection();
        if (selected.length > 0) {
            this.tableviewer.setCheckedElements(selected);
            this.checkedset.addAll(Arrays.asList(selected));
        }
        this.setPageComplete(this.tableviewer.getCheckedElements().length > 0);
        SWTFactory.createVerticalSpacer(comp, 1);
        this.removetags = SWTFactory.createCheckButton(comp, WizardMessages.JavadocConversionPage_delete_tags_during_conversion, null, true, 1);
        IDialogSettings settings = ApiUIPlugin.getDefault().getDialogSettings().getSection(SETTINGS_SECTION);
        if (settings != null) {
            this.removetags.setSelection(settings.getBoolean(SETTINGS_REMOVE_TAGS));
        }
    }

    protected boolean pageValid() {
        if (this.checkedset.size() < 1) {
            this.setErrorMessage(WizardMessages.UpdateJavadocTagsWizardPage_12);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean finish() {
        IDialogSettings settings = ApiUIPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS_SECTION);
        settings.put(SETTINGS_REMOVE_TAGS, this.removetags.getSelection());
        return true;
    }

    public IWizardPage getNextPage() {
        JavadocConversionRefactoring refactoring = (JavadocConversionRefactoring)this.getRefactoring();
        HashSet<IProject> projects = new HashSet<IProject>();
        for (Object object : this.checkedset) {
            IProject current = (IProject)object;
            projects.add(current);
        }
        refactoring.setProjects(projects);
        refactoring.setRemoveTags(this.removetags.getSelection());
        IWizardPage page = super.getNextPage();
        if (page != null) {
            page.setDescription(WizardMessages.JavadocConversionPage_changes_required_for_conversion);
        }
        return page;
    }

    protected boolean performFinish() {
        JavadocConversionRefactoring refactoring = (JavadocConversionRefactoring)this.getRefactoring();
        HashSet<IProject> projects = new HashSet<IProject>();
        for (Object object : this.checkedset) {
            IProject current = (IProject)object;
            projects.add(current);
        }
        refactoring.setProjects(projects);
        refactoring.setRemoveTags(this.removetags.getSelection());
        return super.performFinish();
    }

    protected Object[] getWorkbenchSelection() {
        ISelection selection;
        ISelectionProvider provider;
        IWorkbenchPartSite site;
        IWorkbenchPart part;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) != null && (site = part.getSite()) != null && (provider = site.getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            Object[] jps = ((IStructuredSelection)provider.getSelection()).toArray();
            ArrayList<IProject> pjs = new ArrayList<IProject>();
            Object[] objectArray = jps;
            int n = jps.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable adapt;
                IProject pj;
                Object jp = objectArray[n2];
                if (jp instanceof IAdaptable && Util.isApiProject((IProject)(pj = (IProject)(adapt = (IAdaptable)jp).getAdapter(IProject.class)))) {
                    pjs.add(pj);
                }
                ++n2;
            }
            return pjs.toArray();
        }
        return new Object[0];
    }

    class UpdateJob
    extends WorkbenchJob {
        private String pattern;

        public UpdateJob() {
            super(WizardMessages.ApiToolingSetupWizardPage_filter_update_job);
            this.pattern = null;
            this.setSystem(true);
        }

        public synchronized void setFilter(String pattern) {
            this.pattern = pattern;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (JavadocConversionPage.this.tableviewer != null) {
                try {
                    JavadocConversionPage.this.tableviewer.getTable().setRedraw(false);
                    UpdateJob updateJob = this;
                    synchronized (updateJob) {
                        JavadocConversionPage.this.filter.setPattern(this.pattern + "*");
                    }
                    JavadocConversionPage.this.tableviewer.refresh(true);
                    JavadocConversionPage.this.tableviewer.setCheckedElements(JavadocConversionPage.this.checkedset.toArray());
                }
                finally {
                    JavadocConversionPage.this.tableviewer.getTable().setRedraw(true);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

