/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.ui.target.ITargetLocationHandler;

class TargetLocationHandlerAdapter
implements ITargetLocationHandler {
    TargetLocationHandlerAdapter() {
    }

    @Override
    public boolean canEdit(ITargetDefinition target, TreePath treePath) {
        Object segment = treePath.getLastSegment();
        ITargetLocationHandler handler = (ITargetLocationHandler)Adapters.adapt((Object)segment, ITargetLocationHandler.class);
        if (handler != null) {
            return handler.canEdit(target, treePath);
        }
        return false;
    }

    @Override
    public boolean canUpdate(ITargetDefinition target, TreePath treePath) {
        Object segment = treePath.getLastSegment();
        ITargetLocationHandler handler = (ITargetLocationHandler)Adapters.adapt((Object)segment, ITargetLocationHandler.class);
        if (handler != null) {
            return handler.canUpdate(target, treePath);
        }
        return false;
    }

    @Override
    public boolean canDisable(ITargetDefinition target, TreePath treePath) {
        Object segment = treePath.getLastSegment();
        ITargetLocationHandler handler = (ITargetLocationHandler)Adapters.adapt((Object)segment, ITargetLocationHandler.class);
        if (handler != null) {
            return handler.canDisable(target, treePath);
        }
        return false;
    }

    @Override
    public boolean canEnable(ITargetDefinition target, TreePath treePath) {
        Object segment = treePath.getLastSegment();
        ITargetLocationHandler handler = (ITargetLocationHandler)Adapters.adapt((Object)segment, ITargetLocationHandler.class);
        if (handler != null) {
            return handler.canEnable(target, treePath);
        }
        return false;
    }

    @Override
    public boolean canRemove(ITargetDefinition target, TreePath treePath) {
        Object segment = treePath.getLastSegment();
        if (segment instanceof ITargetLocation) {
            return true;
        }
        ITargetLocationHandler handler = (ITargetLocationHandler)Adapters.adapt((Object)segment, ITargetLocationHandler.class);
        if (handler != null) {
            return handler.canRemove(target, treePath);
        }
        return false;
    }

    @Override
    public IStatus update(ITargetDefinition target, TreePath[] treePath, IProgressMonitor monitor) {
        Map<ITargetLocationHandler, List<TreePath>> handlerMap = TargetLocationHandlerAdapter.computeHandlerMap(target, treePath, ITargetLocationHandler::canUpdate, null);
        MultiStatus status = new MultiStatus("org.eclipse.pde.core", 0, "update");
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 * handlerMap.size()));
        for (Map.Entry<ITargetLocationHandler, List<TreePath>> entry : handlerMap.entrySet()) {
            status.add(entry.getKey().update(target, (TreePath[])entry.getValue().toArray(TreePath[]::new), (IProgressMonitor)subMonitor.split(100)));
        }
        return status;
    }

    @Override
    public IStatus reload(ITargetDefinition target, ITargetLocation[] targetLocations, IProgressMonitor monitor) {
        HashMap<ITargetLocationHandler, List> handlerMap = new HashMap<ITargetLocationHandler, List>();
        MultiStatus status = new MultiStatus("org.eclipse.pde.core", 0, "reload target");
        if (targetLocations != null && targetLocations.length > 0) {
            ITargetLocation[] iTargetLocationArray = targetLocations;
            int n = targetLocations.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation targetLocation = iTargetLocationArray[n2];
                ITargetLocationHandler handler = (ITargetLocationHandler)Adapters.adapt((Object)targetLocation, ITargetLocationHandler.class);
                if (handler != null) {
                    handlerMap.computeIfAbsent(handler, h -> new ArrayList()).add(targetLocation);
                }
                ++n2;
            }
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(handlerMap.size() * 100));
        for (Map.Entry entry : handlerMap.entrySet()) {
            status.add(((ITargetLocationHandler)entry.getKey()).reload(target, (ITargetLocation[])((List)entry.getValue()).toArray(ITargetLocation[]::new), (IProgressMonitor)subMonitor.split(100)));
        }
        return status;
    }

    @Override
    public IStatus remove(ITargetDefinition target, TreePath[] treePath) {
        ITargetLocation[] containers;
        ArrayList removedLocations = new ArrayList();
        Map<ITargetLocationHandler, List<TreePath>> handlerMap = TargetLocationHandlerAdapter.computeHandlerMap(target, treePath, ITargetLocationHandler::canRemove, path -> {
            Object currentSelection = path.getLastSegment();
            if (currentSelection instanceof ITargetLocation) {
                removedLocations.add((ITargetLocation)currentSelection);
            }
        });
        boolean forceReload = false;
        MultiStatus status = new MultiStatus("org.eclipse.pde.core", 0, "remove");
        for (Map.Entry<ITargetLocationHandler, List<TreePath>> entry : handlerMap.entrySet()) {
            IStatus remove = entry.getKey().remove(target, (TreePath[])entry.getValue().toArray(TreePath[]::new));
            forceReload |= remove.isOK() && remove.getCode() == 102;
            status.add(remove);
        }
        if (removedLocations.size() > 0 && (containers = target.getTargetLocations()) != null && containers.length > 0) {
            ArrayList<ITargetLocation> updatedLocations = new ArrayList<ITargetLocation>();
            ITargetLocation[] iTargetLocationArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation location = iTargetLocationArray[n2];
                if (!removedLocations.contains(location)) {
                    updatedLocations.add(location);
                }
                ++n2;
            }
            if (updatedLocations.isEmpty()) {
                target.setTargetLocations(null);
            } else {
                target.setTargetLocations((ITargetLocation[])updatedLocations.toArray(ITargetLocation[]::new));
            }
        }
        return TargetLocationHandlerAdapter.statusWithCode(status, 102, forceReload);
    }

    @Override
    public IStatus toggle(ITargetDefinition target, TreePath[] treePath) {
        boolean forceReload = false;
        MultiStatus status = new MultiStatus("org.eclipse.pde.core", 0, "disable");
        Map<ITargetLocationHandler, List<TreePath>> handlerMap = TargetLocationHandlerAdapter.computeHandlerMap(target, treePath, (h, t, p) -> h.canEnable((ITargetDefinition)t, (TreePath)p) || h.canDisable((ITargetDefinition)t, (TreePath)p), null);
        for (Map.Entry<ITargetLocationHandler, List<TreePath>> entry : handlerMap.entrySet()) {
            TreePath[] handlerTreePaths = (TreePath[])entry.getValue().toArray(TreePath[]::new);
            ITargetLocationHandler handler = entry.getKey();
            IStatus enable = handler.toggle(target, handlerTreePaths);
            forceReload |= enable.isOK() && enable.getCode() == 102;
            status.add(enable);
        }
        return TargetLocationHandlerAdapter.statusWithCode(status, 102, forceReload);
    }

    @Override
    public IWizard getEditWizard(ITargetDefinition target, TreePath treePath) {
        Object segment = treePath.getLastSegment();
        ITargetLocationHandler handler = (ITargetLocationHandler)Adapters.adapt((Object)segment, ITargetLocationHandler.class);
        if (handler != null) {
            return handler.getEditWizard(target, treePath);
        }
        return null;
    }

    private static IStatus statusWithCode(MultiStatus status, int code, boolean useCode) {
        if (status.isOK() && useCode) {
            return new MultiStatus("org.eclipse.pde.core", code, status.getChildren(), status.getMessage(), null);
        }
        return status;
    }

    private static Map<ITargetLocationHandler, List<TreePath>> computeHandlerMap(ITargetDefinition target, TreePath[] treePath, TriFunction<ITargetLocationHandler, ITargetDefinition, TreePath, Boolean> filter, Consumer<TreePath> interceptor) {
        HashMap<ITargetLocationHandler, List<TreePath>> handlerMap = new HashMap<ITargetLocationHandler, List<TreePath>>();
        TreePath[] treePathArray = treePath;
        int n = treePath.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            Object currentSelection = path.getLastSegment();
            ITargetLocationHandler handler = (ITargetLocationHandler)Adapters.adapt((Object)currentSelection, ITargetLocationHandler.class);
            if (handler != null && filter.test(handler, target, path).booleanValue()) {
                handlerMap.computeIfAbsent(handler, h -> new ArrayList()).add(path);
            }
            if (interceptor != null) {
                interceptor.accept(path);
            }
            ++n2;
        }
        return handlerMap;
    }

    static interface TriFunction<A, B, C, R> {
        public R test(A var1, B var2, C var3);
    }
}

