/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.resource.java.QueryHintAnnotation;

public final class SourceQueryHintAnnotation
extends SourceAnnotation
implements QueryHintAnnotation {
    private DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter = this.buildNameDeclarationAdapter();
    private AnnotationElementAdapter<String> nameAdapter = this.buildNameAdapter();
    private String name;
    private TextRange nameTextRange;
    private DeclarationAnnotationElementAdapter<String> valueDeclarationAdapter = this.buildValueDeclarationAdapter();
    private AnnotationElementAdapter<String> valueAdapter = this.buildValueAdapter();
    private String value;
    private TextRange valueTextRange;

    static SourceQueryHintAnnotation buildNamedQueryQueryHint(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter namedQueryAdapter, int index) {
        return SourceQueryHintAnnotation.buildNestedSourceQueryHintAnnotation(parent, element, SourceQueryHintAnnotation.buildNamedQueryQueryHintAnnotationAdapter(namedQueryAdapter, index));
    }

    static SourceQueryHintAnnotation buildNamedNativeQueryQueryHint(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter namedNativeQueryAdapter, int index) {
        return SourceQueryHintAnnotation.buildNestedSourceQueryHintAnnotation(parent, element, SourceQueryHintAnnotation.buildNamedNativeQueryQueryHintAnnotationAdapter(namedNativeQueryAdapter, index));
    }

    public static SourceQueryHintAnnotation buildNamedStoredProcedureQuery2_1QueryHint(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter namedStoredProcedureQuery2_1Adapter, int index) {
        return SourceQueryHintAnnotation.buildNestedSourceQueryHintAnnotation(parent, element, SourceQueryHintAnnotation.buildNamedStoredProcedureQuery2_1QueryHintAnnotationAdapter(namedStoredProcedureQuery2_1Adapter, index));
    }

    public static SourceQueryHintAnnotation buildNestedSourceQueryHintAnnotation(JavaResourceModel parent, AnnotatedElement element, IndexedDeclarationAnnotationAdapter idaa) {
        return new SourceQueryHintAnnotation(parent, element, idaa);
    }

    private SourceQueryHintAnnotation(JavaResourceModel parent, AnnotatedElement element, IndexedDeclarationAnnotationAdapter idaa) {
        super(parent, element, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new ElementIndexedAnnotationAdapter(element, idaa));
    }

    public String getAnnotationName() {
        return ANNOTATION_NAME;
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.name = this.buildName(astAnnotation);
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
        this.value = this.buildValue(astAnnotation);
        this.valueTextRange = this.buildValueTextRange(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncName(this.buildName(astAnnotation));
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
        this.syncValue(this.buildValue(astAnnotation));
        this.valueTextRange = this.buildValueTextRange(astAnnotation);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (ObjectTools.notEquals((Object)this.name, (Object)name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(Annotation astAnnotation) {
        return (String)this.nameAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getNameTextRange() {
        return this.nameTextRange;
    }

    private TextRange buildNameTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astAnnotation);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"name");
    }

    private AnnotationElementAdapter<String> buildNameAdapter() {
        return this.buildStringElementAdapter(this.nameDeclarationAdapter);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (ObjectTools.notEquals((Object)this.value, (Object)value)) {
            this.value = value;
            this.valueAdapter.setValue((Object)value);
        }
    }

    private void syncValue(String astValue) {
        String old = this.value;
        this.value = astValue;
        this.firePropertyChanged("value", old, astValue);
    }

    private String buildValue(Annotation astAnnotation) {
        return (String)this.valueAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getValueTextRange() {
        return this.valueTextRange;
    }

    private TextRange buildValueTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.valueDeclarationAdapter, astAnnotation);
    }

    private DeclarationAnnotationElementAdapter<String> buildValueDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"value");
    }

    private AnnotationElementAdapter<String> buildValueAdapter() {
        return this.buildStringElementAdapter(this.valueDeclarationAdapter);
    }

    public boolean isUnset() {
        return super.isUnset() && this.name == null && this.value == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    private static IndexedDeclarationAnnotationAdapter buildNamedQueryQueryHintAnnotationAdapter(DeclarationAnnotationAdapter namedQueryAdapter, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(namedQueryAdapter, "hints", index, ANNOTATION_NAME);
    }

    private static IndexedDeclarationAnnotationAdapter buildNamedNativeQueryQueryHintAnnotationAdapter(DeclarationAnnotationAdapter namedNativeQueryAdapter, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(namedNativeQueryAdapter, "hints", index, ANNOTATION_NAME);
    }

    private static IndexedDeclarationAnnotationAdapter buildNamedStoredProcedureQuery2_1QueryHintAnnotationAdapter(DeclarationAnnotationAdapter namedStoredProcedureQuery2_1Adapter, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(namedStoredProcedureQuery2_1Adapter, "hints", index, ANNOTATION_NAME);
    }
}

