/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ListScrollBar;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.AnimationModel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class AnimatableScrollPane
extends ScrollPane {
    private AnimationModel animationModel = null;
    private boolean expanded = true;
    private static final long delay = 150L;

    private void animate() {
        this.animationModel = new AnimationModel(150L, this.expanded);
        this.animationModel.animationStarted();
        while (!this.animationModel.isFinished()) {
            this.step();
        }
        this.animationModel = null;
    }

    public void collapse() {
        if (!this.expanded) {
            return;
        }
        this.expanded = false;
        this.animate();
    }

    public void expand() {
        if (this.expanded) {
            return;
        }
        this.expanded = true;
        this.animate();
    }

    public void setExpanded(boolean value) {
        if (this.expanded == value) {
            return;
        }
        this.expanded = value;
        this.revalidate();
    }

    public final boolean isExpanded() {
        return this.expanded;
    }

    private void step() {
        this.revalidate();
        this.getUpdateManager().performUpdate();
    }

    public boolean isOpaque() {
        return false;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.animationModel == null) {
            if (this.expanded) {
                return super.getPreferredSize(wHint, hHint);
            }
            return this.getMinimumSize(wHint, hHint);
        }
        Dimension pref = super.getPreferredSize(wHint, hHint);
        Dimension min = this.getMinimumSize(wHint, hHint);
        float scale = this.animationModel.getProgress();
        return pref.equals((Object)min) ? pref : pref.getScaled((double)scale).expand(min.getScaled((double)(1.0f - scale)));
    }

    public void validate() {
        if (this.isValid()) {
            return;
        }
        this.setValid(true);
        this.layout();
        int i = 0;
        while (i < this.getChildren().size()) {
            ((IFigure)this.getChildren().get(i)).validate();
            ++i;
        }
        if (this.hBar != null && this.getHorizontalScrollBarVisibility() != 0) {
            this.getHorizontalScrollBar().validate();
        }
        if (this.vBar != null && this.getVerticalScrollBarVisibility() != 0) {
            this.getVerticalScrollBar().validate();
        }
    }

    protected void createVerticalScrollBar() {
        IMapMode mm = MapModeUtil.getMapMode((IFigure)this);
        int mm_0 = mm.DPtoLP(0);
        Insets insets = new Insets(mm_0, mm.DPtoLP(2), mm_0, mm_0);
        int mm_14 = mm.DPtoLP(14);
        Dimension size = new Dimension(mm_14, mm_14);
        this.setVerticalScrollBar(new ListScrollBar(1, insets, size, mm.DPtoLP(10), mm.DPtoLP(50)));
    }

    protected void createHorizontalScrollBar() {
        IMapMode mm = MapModeUtil.getMapMode((IFigure)this);
        int mm_0 = mm.DPtoLP(0);
        int mm_1 = mm.DPtoLP(1);
        Insets insets = new Insets(mm_0, mm_0, mm_0, mm_1);
        int mm_13 = mm.DPtoLP(12);
        Dimension size = new Dimension(mm_13, mm_13);
        this.setHorizontalScrollBar(new ListScrollBar(0, insets, size, mm.DPtoLP(10), mm.DPtoLP(50)));
    }

    public ScrollBar basicGetVerticalScrollBar() {
        return this.vBar;
    }

    public ScrollBar basicGetHorizontalScrollBar() {
        return this.hBar;
    }
}

