/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.hover;

import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.ui.internal.model.TMDocumentModel;
import org.eclipse.tm4e.ui.internal.model.TMModelManager;
import org.eclipse.tm4e.ui.internal.preferences.PreferenceHelper;
import org.eclipse.tm4e.ui.text.ITMPartitionRegion;
import org.eclipse.tm4e.ui.text.TMPartitions;
import org.eclipse.ui.editors.text.EditorsUI;

public class TMTokenTextHover
implements ITextHover,
ITextHoverExtension {
    public @Nullable IInformationControlCreator getHoverControlCreator() {
        return new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, EditorsUI.getTooltipAffordanceString());
            }
        };
    }

    public @Nullable String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (hoverRegion instanceof RegionWithTMToken) {
            RegionWithTMToken regionWithToken = (RegionWithTMToken)hoverRegion;
            String text = regionWithToken.tokenText.replace(' ', '\u00b7').replace('\t', '\u2192');
            Object partitionInfo = "";
            ITMPartitionRegion reg = regionWithToken.tmPartition;
            if (reg != null) {
                partitionInfo = "<br><b>JFace Text Partition:</b><li><b>Offset:</b>" + reg.getOffset() + "<li><b>Length:</b>" + reg.getLength() + "<li><b>Type:</b> " + reg.getType() + "<li><b>Grammar Scope:</b> " + reg.getGrammarScope();
            }
            return "<b>" + text + "</b> (" + text.length() + " chars)<br><br><b>Token Type:</b> " + regionWithToken.token.type + "<br><b>Origin Grammar Scope:</b> " + regionWithToken.token.grammarScope + "<br><b>TextMate Scopes:</b> <li>" + String.join((CharSequence)"<li>", regionWithToken.token.scopes) + "<br>" + (String)partitionInfo;
        }
        return null;
    }

    public @Nullable IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        TMToken nextToken;
        TMToken hoveredToken;
        int lineStartOffset;
        int lineIndex;
        IDocument doc;
        block10: {
            List tokens;
            block9: {
                if (!PreferenceHelper.isTMTokenHoverEnabled()) {
                    return null;
                }
                doc = textViewer.getDocument();
                if (doc == null) {
                    return null;
                }
                TMDocumentModel model = TMModelManager.INSTANCE.getConnectedModel(doc);
                if (model == null) {
                    return null;
                }
                lineIndex = doc.getLineOfOffset(offset);
                tokens = model.getLineTokens(lineIndex);
                if (tokens != null) break block9;
                return null;
            }
            try {
                lineStartOffset = doc.getLineOffset(lineIndex);
                hoveredToken = null;
                nextToken = null;
                for (TMToken token : tokens) {
                    if (token.startIndex <= offset - lineStartOffset) {
                        hoveredToken = token;
                        continue;
                    }
                    nextToken = token;
                    break;
                }
                if (hoveredToken != null) break block10;
                return null;
            }
            catch (BadLocationException e) {
                return null;
            }
        }
        int regionOffset = lineStartOffset + hoveredToken.startIndex;
        int regionLength = nextToken == null ? doc.getLineLength(lineIndex) - hoveredToken.startIndex : nextToken.startIndex - hoveredToken.startIndex;
        return new RegionWithTMToken(regionOffset, regionLength, doc.get(regionOffset, regionLength), hoveredToken, TMPartitions.getPartition(doc, offset));
    }

    private static final class RegionWithTMToken
    extends Region {
        final TMToken token;
        final String tokenText;
        final @Nullable ITMPartitionRegion tmPartition;

        RegionWithTMToken(int offset, int length, String tokenText, TMToken token, @Nullable ITMPartitionRegion tmPartitionRegion) {
            super(offset, length);
            this.tokenText = tokenText;
            this.token = token;
            this.tmPartition = tmPartitionRegion;
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + Objects.hash(this.tmPartition, this.token, this.tokenText, this.getOffset(), this.getLength());
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !super.equals(obj)) {
                return false;
            }
            if (obj instanceof RegionWithTMToken) {
                RegionWithTMToken other = (RegionWithTMToken)((Object)obj);
                return Objects.equals(this.tmPartition, other.tmPartition) && Objects.equals(this.token, other.token) && Objects.equals(this.tokenText, other.tokenText) && Objects.equals(this.getOffset(), other.getOffset()) && Objects.equals(this.getLength(), other.getLength());
            }
            return false;
        }
    }
}

