/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.format.semantic;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.internal.helper.decoration.DecorationHelperInternal;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.AbstractNodeMappingSpecOperations;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramElementSynchronizer;
import org.eclipse.sirius.diagram.business.internal.sync.DEdgeCandidate;
import org.eclipse.sirius.diagram.business.internal.sync.DNodeCandidate;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.util.DiagramSwitch;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.internal.SiriusCopierHelper;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public class MappingBasedDiagramContentDuplicationSwitch
extends DiagramSwitch<Void> {
    DSemanticDiagram targetDiagram;
    DDiagram sourceDiagram;
    EObject targetContext;
    Session targetSession;
    final Map<EObject, EObject> correspondenceMap;
    Map<EObject, List<DDiagramElement>> alreadyCreatedDiagramElementMap;
    Map<DDiagramElement, DDiagramElement> sourceDDiagramElementToTargetDDiagramElementMap;
    List<DEdge> toBeDuplicatedEdges;
    DiagramMappingsManager mappingManager;
    IInterpreter interpreter;

    public MappingBasedDiagramContentDuplicationSwitch(DSemanticDiagram targetDiagram, Map<EObject, EObject> correspondenceMap, Session targetSession) {
        this.targetDiagram = targetDiagram;
        this.targetSession = targetSession;
        this.correspondenceMap = correspondenceMap;
        this.sourceDDiagramElementToTargetDDiagramElementMap = new HashMap<DDiagramElement, DDiagramElement>();
        this.toBeDuplicatedEdges = new ArrayList<DEdge>();
        this.mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(targetSession, (DDiagram)targetDiagram);
        this.interpreter = targetSession.getInterpreter();
        this.alreadyCreatedDiagramElementMap = new HashMap<EObject, List<DDiagramElement>>();
        targetDiagram.getDiagramElements().stream().forEach(dElem -> {
            List<DDiagramElement> list = this.alreadyCreatedDiagramElementMap.get(dElem.getTarget());
            if (list == null) {
                list = new ArrayList<DDiagramElement>();
            }
            if (!list.contains(dElem)) {
                list.add((DDiagramElement)dElem);
                this.alreadyCreatedDiagramElementMap.put(dElem.getTarget(), list);
            }
        });
    }

    public Void caseDDiagram(DDiagram object) {
        EObject originalTargetContext = this.targetContext;
        this.targetContext = this.getTargetDiagram();
        this.sourceDiagram = object;
        object.getOwnedDiagramElements().stream().forEach(elem -> this.doSwitch((EObject)elem));
        this.targetContext = originalTargetContext;
        this.handleEdgesDuplication();
        return null;
    }

    public Void caseDDiagramElement(DDiagramElement object) {
        return (Void)super.caseDDiagramElement(object);
    }

    public Void caseDNodeContainer(DNodeContainer object) {
        DDiagramElement createdDDiagramElement = this.handleDDiagramElement((DDiagramElement)object);
        if (createdDDiagramElement != null) {
            EObject originalTargetContext = this.targetContext;
            this.targetContext = createdDDiagramElement;
            object.getOwnedDiagramElements().stream().forEach(elem -> this.doSwitch((EObject)elem));
            object.getOwnedBorderedNodes().stream().forEach(elem -> this.doSwitch((EObject)elem));
            this.targetContext = originalTargetContext;
        }
        return (Void)super.caseDNodeContainer(object);
    }

    public Void caseDNodeList(DNodeList object) {
        DDiagramElement createdDDiagramElement = this.handleDDiagramElement((DDiagramElement)object);
        if (createdDDiagramElement != null) {
            EObject originalTargetContext = this.targetContext;
            this.targetContext = createdDDiagramElement;
            object.getOwnedElements().stream().forEach(elem -> this.doSwitch((EObject)elem));
            object.getOwnedBorderedNodes().stream().forEach(elem -> this.doSwitch((EObject)elem));
            this.targetContext = originalTargetContext;
        }
        return (Void)super.caseDNodeList(object);
    }

    public Void caseDNode(DNode object) {
        DDiagramElement createdDDiagramElement = this.handleDDiagramElement((DDiagramElement)object);
        if (createdDDiagramElement != null) {
            EObject originalTargetContext = this.targetContext;
            this.targetContext = createdDDiagramElement;
            object.getOwnedBorderedNodes().stream().forEach(elem -> this.doSwitch((EObject)elem));
            this.targetContext = originalTargetContext;
        }
        return (Void)super.caseDNode(object);
    }

    public Void caseDNodeListElement(DNodeListElement object) {
        DDiagramElement createdDDiagramElement = this.handleDDiagramElement((DDiagramElement)object);
        if (createdDDiagramElement != null) {
            EObject originalTargetContext = this.targetContext;
            this.targetContext = createdDDiagramElement;
            object.getOwnedBorderedNodes().stream().forEach(elem -> this.doSwitch((EObject)elem));
            this.targetContext = originalTargetContext;
        }
        return (Void)super.caseDNodeListElement(object);
    }

    public Void caseDEdge(DEdge object) {
        this.handleDDiagramElement((DDiagramElement)object);
        return (Void)super.caseDEdge(object);
    }

    private DDiagramElement handleDDiagramElement(DDiagramElement sourceDElement) {
        Optional<DiagramElementMapping> bestMapping;
        EObject targetElement = this.correspondenceMap.get(sourceDElement.getTarget());
        if (targetElement != null && (bestMapping = this.getTargetSessionMapping(sourceDElement.getMapping(), targetElement)).isPresent()) {
            return this.getOrCreateTargetDiagramElement(sourceDElement, targetElement, bestMapping.get());
        }
        return null;
    }

    private Optional<DiagramElementMapping> getTargetSessionMapping(RepresentationElementMapping mapping, EObject targetElement) {
        return Optional.ofNullable(targetElement.eResource()).map(Resource::getResourceSet).map(resourceSet -> resourceSet.getEObject(EcoreUtil.getURI((EObject)mapping), false)).filter(DiagramElementMapping.class::isInstance).map(DiagramElementMapping.class::cast);
    }

    private DDiagramElement getOrCreateTargetDiagramElement(DDiagramElement sourceDElement, EObject targetElement, DiagramElementMapping bestMapping) {
        DDiagramElement result = this.isAlreadyCreated(targetElement, bestMapping);
        if (result != null) {
            this.getSourceDDiagramElementToTargetDDiagramElementMap().put(sourceDElement, result);
            this.replicateShowHideAndFiltersOnElement(sourceDElement, result);
        } else if (sourceDElement instanceof DEdge) {
            this.toBeDuplicatedEdges.add((DEdge)sourceDElement);
        } else {
            DNodeCandidate abstractDNodeCandidate = new DNodeCandidate((AbstractNodeMapping)bestMapping, targetElement, (DragAndDropTarget)this.targetContext, RefreshIdsHolder.getOrCreateHolder((EObject)this.getTargetDiagram()));
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(targetElement);
            DDiagramElementSynchronizer sync = new DDiagramElementSynchronizer(this.getTargetDiagram(), this.interpreter, accessor);
            AbstractDNode createdTargetElement = sync.createNewNode(this.mappingManager, abstractDNodeCandidate, this.isBorderedNode(sourceDElement));
            if (createdTargetElement != null) {
                AbstractNodeMappingSpecOperations.createBorderingNodes((AbstractNodeMapping)((AbstractNodeMapping)bestMapping), (EObject)targetElement, (DDiagramElement)createdTargetElement, Collections.emptyList(), (DDiagram)this.getTargetDiagram());
                this.replicateShowHideAndFiltersOnElement(sourceDElement, (DDiagramElement)createdTargetElement);
                this.getSourceDDiagramElementToTargetDDiagramElementMap().put(sourceDElement, (DDiagramElement)createdTargetElement);
                result = createdTargetElement;
            } else {
                throw new IllegalArgumentException(MessageFormat.format(Messages.MappingBasedDiagramContentDuplicationSwitch_ErrorImpossibleToCreateNodeFromNodeCandidate, abstractDNodeCandidate, sourceDElement));
            }
        }
        return result;
    }

    private void replicateShowHideAndFiltersOnElement(DDiagramElement sourceDElement, DDiagramElement targetDElement) {
        targetDElement.getGraphicalFilters().clear();
        targetDElement.getGraphicalFilters().addAll(SiriusCopierHelper.copyAllWithNoUidDuplication((Collection)sourceDElement.getGraphicalFilters()));
        targetDElement.setVisible(sourceDElement.isVisible());
    }

    private DDiagramElement isAlreadyCreated(EObject targetElement, DiagramElementMapping bestMapping) {
        DiagramElementMappingQuery query = new DiagramElementMappingQuery(bestMapping);
        List<DDiagramElement> dDiagramElements = this.alreadyCreatedDiagramElementMap.get(targetElement);
        if (dDiagramElements != null && bestMapping.isCreateElements()) {
            for (DDiagramElement dDiagramElement : dDiagramElements) {
                if (!query.isTypeOf((DMappingBased)dDiagramElement)) continue;
                return dDiagramElement;
            }
        }
        return null;
    }

    private boolean isBorderedNode(DDiagramElement object) {
        return object.eContainingFeature().equals(DiagramPackage.Literals.ABSTRACT_DNODE__OWNED_BORDERED_NODES);
    }

    private void handleEdgesDuplication() {
        ArrayList<DEdge> edgesToEdge = new ArrayList<DEdge>();
        ArrayList<DEdge> handledEdges = new ArrayList<DEdge>();
        for (DEdge edge : this.toBeDuplicatedEdges) {
            this.handleEdge(edge, edgesToEdge, handledEdges);
        }
        this.handleEdgesToEdges(edgesToEdge, handledEdges);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleEdge(DEdge toHandleEdge, List<DEdge> edgesToEdge, List<DEdge> handledEdges) {
        EObject targetElement = this.correspondenceMap.get(toHandleEdge.getTarget());
        if (targetElement == null) return;
        EdgeTarget sourceNode = toHandleEdge.getSourceNode();
        EdgeTarget targetNode = toHandleEdge.getTargetNode();
        if (sourceNode instanceof DEdge || targetNode instanceof DEdge) {
            edgesToEdge.add(toHandleEdge);
            return;
        }
        DDiagramElement sourceDiagramSourceEdgeTarget = this.getSourceDDiagramElementToTargetDDiagramElementMap().get(sourceNode);
        DDiagramElement sourceDiagramTargetEdgeTarget = this.getSourceDDiagramElementToTargetDDiagramElementMap().get(targetNode);
        if (sourceDiagramSourceEdgeTarget != null && sourceDiagramTargetEdgeTarget != null && sourceDiagramSourceEdgeTarget instanceof EdgeTarget && sourceDiagramTargetEdgeTarget instanceof EdgeTarget) {
            RepresentationElementMapping mapping = toHandleEdge.getMapping();
            Optional<DiagramElementMapping> targetSessionMapping = this.getTargetSessionMapping(mapping, targetElement);
            DEdgeCandidate abstractDEdgeCandidate = new DEdgeCandidate((EdgeMapping)targetSessionMapping.get(), targetElement, (EdgeTarget)sourceDiagramSourceEdgeTarget, (EdgeTarget)sourceDiagramTargetEdgeTarget, RefreshIdsHolder.getOrCreateHolder((EObject)this.getTargetDiagram()));
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(targetElement);
            DDiagramElementSynchronizer sync = new DDiagramElementSynchronizer(this.getTargetDiagram(), this.interpreter, accessor);
            HashMap edgeToMappingBasedDecoration = new HashMap();
            HashMap edgeToSemanticBasedDecoration = new HashMap();
            Map mappingsToEdgeTargets = sync.computeMappingsToEdgeTargets(this.targetSession.getSelectedViewpoints(false));
            new DecorationHelperInternal((DDiagram)this.targetDiagram, this.interpreter, accessor).computeDecorations(mappingsToEdgeTargets, edgeToSemanticBasedDecoration, edgeToMappingBasedDecoration);
            DEdge createdNewEdge = sync.createNewEdge(this.mappingManager, abstractDEdgeCandidate, mappingsToEdgeTargets, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration);
            if (createdNewEdge == null) throw new IllegalArgumentException(MessageFormat.format(Messages.MappingBasedDiagramContentDuplicationSwitch_ErrorImpossibleToCreateEdgeFromEdgeCandidate, abstractDEdgeCandidate, toHandleEdge));
            this.replicateShowHideAndFiltersOnElement((DDiagramElement)toHandleEdge, (DDiagramElement)createdNewEdge);
            handledEdges.add(toHandleEdge);
            this.getSourceDDiagramElementToTargetDDiagramElementMap().put((DDiagramElement)toHandleEdge, (DDiagramElement)createdNewEdge);
            return;
        } else {
            if (handledEdges.contains(toHandleEdge)) return;
            edgesToEdge.add(toHandleEdge);
            return;
        }
    }

    private void handleEdgesToEdges(List<DEdge> edgesToEdge, List<DEdge> handledEdges) {
        ArrayList<DEdge> newEdgesToEdge = new ArrayList<DEdge>(edgesToEdge);
        List<DEdge> newlyHandledEdges = handledEdges;
        for (DEdge edge : edgesToEdge) {
            boolean targetHandlable;
            EdgeTarget sourceNode = edge.getSourceNode();
            EdgeTarget targetNode = edge.getTargetNode();
            boolean sourceHandlable = !(sourceNode instanceof DEdge) || handledEdges.contains(sourceNode);
            boolean bl = targetHandlable = !(targetNode instanceof DEdge) || handledEdges.contains(targetNode);
            if (!sourceHandlable || !targetHandlable) continue;
            this.handleEdge(edge, newEdgesToEdge, newlyHandledEdges);
            newlyHandledEdges.add(edge);
            newEdgesToEdge.remove(edge);
        }
        if (newEdgesToEdge.size() > 0) {
            this.handleEdgesToEdges(newEdgesToEdge, newlyHandledEdges);
        }
    }

    public DSemanticDiagram getTargetDiagram() {
        return this.targetDiagram;
    }

    public Map<DDiagramElement, DDiagramElement> getSourceDDiagramElementToTargetDDiagramElementMap() {
        return this.sourceDDiagramElementToTargetDDiagramElementMap;
    }
}

