/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.service;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecoretools.design.service.ProcessGenModels;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class GenModelAutoReload
implements ModelChangeTrigger {
    private Session session;
    public static final NotificationFilter IS_TOUCH = new NotificationFilter.Custom(){

        public boolean matches(Notification input) {
            return input.isTouch();
        }
    };
    public static final NotificationFilter IS_ECORE = new NotificationFilter.Custom(){

        public boolean matches(Notification input) {
            return input.getNotifier() instanceof EObject && ((EObject)input.getNotifier()).eClass().getEPackage() == EcorePackage.eINSTANCE;
        }
    };
    public static final NotificationFilter IS_ATTACHMENT = new NotificationFilter.Custom(){

        public boolean matches(Notification input) {
            return input.getFeature() instanceof EReference && ((EReference)input.getFeature()).isContainment();
        }
    };
    public static final NotificationFilter IS_EREFENCE_CONTAINMENT = new NotificationFilter.Custom(){

        public boolean matches(Notification input) {
            return input.getFeature() == EcorePackage.eINSTANCE.getEReference_Containment();
        }
    };
    public static final NotificationFilter SHOULD_RELOAD = IS_TOUCH.negated().and(IS_ECORE.and(IS_ATTACHMENT));
    public static final int PRIORITY = -2;

    public GenModelAutoReload(Session newSession) {
        this.session = newSession;
    }

    public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
        ArrayList<GenModel> genModels = new ArrayList<GenModel>();
        for (Resource res : this.session.getTransactionalEditingDomain().getResourceSet().getResources()) {
            for (EObject root : res.getContents()) {
                if (!(root instanceof GenModel)) continue;
                genModels.add((GenModel)root);
            }
        }
        if (genModels.size() > 0) {
            ProcessGenModels result = new ProcessGenModels(this.session, genModels);
            return Options.newSome((Object)((Object)result));
        }
        return Options.newNone();
    }

    public int priority() {
        return -2;
    }
}

