/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.service;

import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecoretools.design.service.DesignServices;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class ReviewServices
extends DesignServices {
    public Collection<EPackage> getPackageDependencies(EPackage source) {
        LinkedHashSet<EPackage> dependencies = new LinkedHashSet<EPackage>();
        for (EClassifier classifier : source.getEClassifiers()) {
            if (!(classifier instanceof EClass)) continue;
            EClass eClass = (EClass)classifier;
            dependencies.addAll(this.externalDependencies(eClass));
        }
        dependencies.remove(source);
        return dependencies;
    }

    private Set<EPackage> externalDependencies(EClass containedClassifiers) {
        LinkedHashSet<EPackage> dependencies = new LinkedHashSet<EPackage>();
        for (EStructuralFeature eRef : containedClassifiers.getEAllStructuralFeatures()) {
            if (eRef.getEType() == null || eRef.getEType().getEPackage() == null) continue;
            dependencies.add(eRef.getEType().getEPackage());
        }
        for (EClass superClazz : containedClassifiers.getEAllSuperTypes()) {
            if (superClazz.getEPackage() == null) continue;
            dependencies.add(superClazz.getEPackage());
        }
        return dependencies;
    }

    public Integer getDependenciesAmount(EObject a) {
        return 2;
    }

    public String getDependenciesTooltip(EClass clazz, DSemanticDecorator view) {
        Option diag = new EObjectQuery((EObject)view).getParentDiagram();
        if (diag.some()) {
            Set<EPackage> displayedPackages = this.getDisplayedEPackages((DDiagram)diag.get());
            displayedPackages.remove(clazz.getEPackage());
            LinkedHashSet<CallSite> explanations = new LinkedHashSet<CallSite>();
            if (diag != null) {
                for (EPackage dep : this.externalDependencies(clazz)) {
                    if (!displayedPackages.contains(dep)) continue;
                    explanations.add((CallSite)((Object)("Dependency to " + dep.getNsURI() + ": \n" + this.externalDependenciesExplanation(dep, clazz))));
                }
            }
            return String.join((CharSequence)"\n", explanations);
        }
        return "";
    }

    public String getDependenciesLabel(EClass clazz) {
        return clazz.getName() + " (" + this.externalDependencies(clazz).size() + ")";
    }

    public Collection<EClassifier> getElementsIntroducingDependencies(EPackage source, DSemanticDiagram diagram) {
        LinkedHashSet<EClassifier> classifiersIntroducingDependencies = new LinkedHashSet<EClassifier>();
        Set<EPackage> otherPackages = this.getDisplayedEPackages((DDiagram)diagram);
        otherPackages.remove(source);
        for (EClassifier classifier : source.getEClassifiers()) {
            if (!(classifier instanceof EClass)) continue;
            EClass eClass = (EClass)classifier;
            for (EStructuralFeature eRef : eClass.getEAllStructuralFeatures()) {
                if (eRef.getEType() == null || !otherPackages.contains(eRef.getEType().getEPackage())) continue;
                classifiersIntroducingDependencies.add((EClassifier)eRef.getEContainingClass());
            }
            for (EClass superClazz : eClass.getEAllSuperTypes()) {
                if (!otherPackages.contains(superClazz.getEPackage())) continue;
                classifiersIntroducingDependencies.add((EClassifier)eClass);
            }
        }
        return classifiersIntroducingDependencies;
    }

    private Set<EPackage> getDisplayedEPackages(DDiagram diagram) {
        LinkedHashSet<EPackage> otherPackages = new LinkedHashSet<EPackage>();
        for (DDiagramElement element : diagram.getOwnedDiagramElements()) {
            DNodeList list;
            if (!(element instanceof DNodeList) || new DDiagramElementQuery((DDiagramElement)(list = (DNodeList)element)).isHidden() || !(list.getTarget() instanceof EPackage)) continue;
            otherPackages.add((EPackage)list.getTarget());
        }
        return otherPackages;
    }

    private String externalDependenciesExplanation(EPackage dep, EClass clazz) {
        LinkedHashSet<CallSite> explanations = new LinkedHashSet<CallSite>();
        for (EStructuralFeature eRef : clazz.getEAllStructuralFeatures()) {
            if (eRef.getEType() == null || eRef.getEType().getEPackage() != dep) continue;
            explanations.add((CallSite)((Object)(" - " + eRef.eClass().getName() + " " + eRef.getName() + " refers to type " + eRef.getEType().getName() + " in package " + dep.getName())));
        }
        for (EClass superClazz : clazz.getEAllSuperTypes()) {
            if (superClazz.getEPackage() != dep) continue;
            explanations.add((CallSite)((Object)(" - EClass" + clazz.getName() + " extends type " + superClazz.getName() + " in package " + dep.getName())));
        }
        return String.join((CharSequence)"\n", explanations);
    }
}

